/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.csvdir.methods;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.tirasa.connid.bundles.csvdir.CSVDirConfiguration;
import net.tirasa.connid.bundles.csvdir.CSVDirConnection;
import net.tirasa.connid.bundles.csvdir.methods.CommonOperation;
import net.tirasa.connid.commons.db.FilterWhereBuilder;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.ConnectorIOException;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Uid;

public class CSVDirExecuteQuery
extends CommonOperation {
    private static final Log LOG = Log.getLog(CSVDirExecuteQuery.class);
    private final CSVDirConfiguration conf;
    private final CSVDirConnection conn;
    private final ObjectClass oclass;
    private final FilterWhereBuilder where;
    private final ResultsHandler handler;
    private final OperationOptions options;

    public CSVDirExecuteQuery(CSVDirConfiguration configuration, ObjectClass oclass, FilterWhereBuilder where, ResultsHandler handler, OperationOptions options) throws ClassNotFoundException, SQLException {
        this.conf = configuration;
        this.oclass = oclass;
        this.where = where;
        this.handler = handler;
        this.options = options;
        this.conn = CSVDirConnection.open(configuration);
    }

    public void execute() {
        try {
            this.executeImpl();
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "error during updating", new Object[0]);
            throw new ConnectorException((Throwable)e);
        }
        finally {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                LOG.error((Throwable)e, "Error closing connections", new Object[0]);
            }
        }
    }

    private void executeImpl() throws SQLException {
        LOG.info("check the ObjectClass and result handler", new Object[0]);
        if (this.oclass == null || !this.oclass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException("Object class required");
        }
        if (this.handler == null) {
            throw new IllegalArgumentException("Result handler required");
        }
        LOG.ok("The ObjectClass and result handler is ok", new Object[0]);
        Set<String> columnNamesToGet = this.resolveColumnNamesToGet();
        LOG.ok("Column Names {0} To Get", new Object[]{columnNamesToGet});
        String whereClause = this.where == null ? null : this.where.getWhereClause();
        LOG.ok("Where Clause {0}", new Object[]{whereClause});
        List params = this.where == null ? null : this.where.getParams();
        LOG.ok("Where Params {0}", new Object[]{params});
        ResultSet resultSet = null;
        try {
            resultSet = this.conn.allCsvFiles(whereClause, params);
            boolean handled = true;
            while (resultSet.next() && handled) {
                if (!StringUtil.isBlank((String)this.conf.getDeleteColumnName()) && Boolean.valueOf(resultSet.getString(resultSet.findColumn(this.conf.getDeleteColumnName()))).booleanValue()) continue;
                handled = this.handler.handle(this.buildConnectorObject(this.conf, resultSet));
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Search query failed", new Object[0]);
            throw new ConnectorIOException((Throwable)e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException e) {
                LOG.error((Throwable)e, "Error closing result set", new Object[0]);
            }
        }
        LOG.ok("Query Account commited", new Object[0]);
    }

    private Set<String> resolveColumnNamesToGet() {
        HashSet<String> attributesToGet = new HashSet<String>();
        attributesToGet.add(Uid.NAME);
        String[] attributes = this.options == null || this.options.getAttributesToGet() == null ? this.conf.getFields() : this.options.getAttributesToGet();
        attributesToGet.addAll(Arrays.asList(attributes));
        return attributesToGet;
    }
}

