/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.csvdir.methods;

import java.sql.SQLException;
import net.tirasa.connid.bundles.csvdir.CSVDirConfiguration;
import net.tirasa.connid.bundles.csvdir.CSVDirConnection;
import net.tirasa.connid.bundles.csvdir.methods.CommonOperation;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Uid;

public class CSVDirDelete
extends CommonOperation {
    private static final Log LOG = Log.getLog(CSVDirDelete.class);
    private final CSVDirConnection conn;
    private final CSVDirConfiguration conf;
    private Uid uid = null;

    public CSVDirDelete(CSVDirConfiguration conf, Uid uid) throws ClassNotFoundException, SQLException {
        this.conf = conf;
        this.uid = uid;
        this.conn = CSVDirConnection.open(conf);
    }

    public void execute() {
        try {
            this.executeImpl();
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "error during updating", new Object[0]);
            throw new ConnectorException((Throwable)e);
        }
        finally {
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (SQLException e) {
                LOG.error((Throwable)e, "Error closing connections", new Object[0]);
            }
        }
    }

    private void executeImpl() throws SQLException {
        if (!CSVDirDelete.userExists(this.uid.getUidValue(), this.conn, this.conf).booleanValue()) {
            throw new ConnectorException("User does not exist");
        }
        this.conn.deleteAccount(this.uid);
        LOG.ok("Delete completed", new Object[0]);
    }
}

