/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ad.util;

import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.naming.directory.BasicAttribute;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.OperationalAttributes;

public abstract class ADGuardedPasswordAttribute {
    private static final Log LOG = Log.getLog(ADGuardedPasswordAttribute.class);

    public static ADGuardedPasswordAttribute create(String attrName, Attribute attr) {
        assert (attr.is(OperationalAttributes.PASSWORD_NAME));
        List value = attr.getValue();
        if (value != null && !value.isEmpty()) {
            return ADGuardedPasswordAttribute.create(attrName, (GuardedString)value.get(0));
        }
        return ADGuardedPasswordAttribute.create(attrName);
    }

    public static ADGuardedPasswordAttribute create(String attrName, GuardedString password) {
        return new Simple(attrName, password);
    }

    public static ADGuardedPasswordAttribute create(String attrName) {
        return new Empty(attrName);
    }

    public abstract void access(Accessor var1);

    private static final class Empty
    extends ADGuardedPasswordAttribute {
        private final String attrName;

        private Empty(String attrName) {
            this.attrName = attrName;
        }

        @Override
        public void access(Accessor accessor) {
            accessor.access(new BasicAttribute(this.attrName));
        }
    }

    private static final class Simple
    extends ADGuardedPasswordAttribute {
        private final String attrName;
        private final GuardedString password;

        private Simple(String attrName, GuardedString password) {
            this.attrName = attrName;
            this.password = password;
        }

        @Override
        public void access(final Accessor accessor) {
            this.password.access(new GuardedString.Accessor(){

                public void access(char[] clearChars) {
                    String quotedPwd = "\"" + new String(clearChars) + "\"";
                    try {
                        byte[] unicodePwd = quotedPwd.getBytes("UTF-16LE");
                        BasicAttribute attr = new BasicAttribute(Simple.this.attrName, unicodePwd);
                        accessor.access(attr);
                    }
                    catch (UnsupportedEncodingException e) {
                        LOG.error((Throwable)e, "Error encoding password", new Object[0]);
                    }
                }
            });
        }
    }

    public static interface Accessor {
        public void access(BasicAttribute var1);
    }
}

