/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.scim;

import java.util.Base64;
import java.util.Date;
import org.apache.syncope.common.lib.scim.SCIMConf;
import org.apache.syncope.common.lib.scim.SCIMGeneralConf;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.core.logic.ConfigurationLogic;
import org.apache.syncope.core.logic.SchemaLogic;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component
public class SCIMConfManager {
    protected static final Logger LOG = LoggerFactory.getLogger(SCIMConfManager.class);
    @Autowired
    private ConfigurationLogic configurationLogic;
    @Autowired
    private SchemaLogic schemaLogic;

    @PreAuthorize(value="hasRole('SCIM_CONF_GET')")
    public SCIMConf get() {
        AttrTO confTO = null;
        try {
            confTO = this.configurationLogic.get("scimv2.conf");
        }
        catch (Exception e) {
            LOG.error("{} not found, reverting to default", (Object)"scimv2.conf");
        }
        SCIMConf conf = null;
        if (confTO != null) {
            try {
                conf = (SCIMConf)POJOHelper.deserialize((String)new String(Base64.getDecoder().decode((String)confTO.getValues().get(0))), SCIMConf.class);
            }
            catch (Exception e) {
                LOG.error("Could not deserialize, reverting to default", (Throwable)e);
            }
        }
        if (conf == null) {
            conf = new SCIMConf();
            this.set(conf);
        }
        return conf;
    }

    @PreAuthorize(value="hasRole('SCIM_CONF_SET')")
    public void set(SCIMConf conf) {
        try {
            this.schemaLogic.read(SchemaType.PLAIN, "scimv2.conf");
        }
        catch (NotFoundException e) {
            PlainSchemaTO scimConf = new PlainSchemaTO();
            scimConf.setKey("scimv2.conf");
            scimConf.setType(AttrSchemaType.Binary);
            scimConf.setMimeType("application/json");
            this.schemaLogic.create(SchemaType.PLAIN, (SchemaTO)scimConf);
        }
        conf.setGeneralConf(new SCIMGeneralConf());
        conf.getGeneralConf().setLastChangeDate(new Date());
        this.configurationLogic.set(new AttrTO.Builder().schema("scimv2.conf").value(Base64.getEncoder().encodeToString(POJOHelper.serialize((Object)conf).getBytes())).build());
    }
}

