/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import java.util.HashSet;
import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.anyobject.ADynGroupMembership;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.GroupCheck;

public class GroupValidator
extends AbstractValidator<GroupCheck, Group> {
    public boolean isValid(Group group, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean isValid = true;
        if (group.getUserOwner() != null && group.getGroupOwner() != null) {
            isValid = false;
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidGroupOwner, "A group must either be owned by an user or a group, not both")).addPropertyNode("owner").addConstraintViolation();
        }
        if (isValid && (group.getName() == null || !Entity.ID_PATTERN.matcher(group.getName()).matches())) {
            isValid = false;
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidName, group.getName())).addPropertyNode("name").addConstraintViolation();
        }
        if (isValid) {
            HashSet<AnyType> anyTypes = new HashSet<AnyType>();
            for (ADynGroupMembership memb : group.getADynMemberships()) {
                anyTypes.add(memb.getAnyType());
                if (memb.getAnyType().getKind() == AnyTypeKind.ANY_OBJECT) continue;
                isValid = false;
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidADynMemberships, "No user or group dynamic membership condition are allowed here")).addPropertyNode("aDynMemberships").addConstraintViolation();
            }
            if (isValid && anyTypes.size() < group.getADynMemberships().size()) {
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidADynMemberships, "Each dynamic membership condition requires a different " + AnyType.class.getSimpleName())).addPropertyNode("aDynMemberships").addConstraintViolation();
                return false;
            }
        }
        return isValid;
    }
}

