/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.EntityManagerFactory;
import javax.persistence.JoinTable;
import javax.persistence.Table;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.PluralAttribute;
import javax.sql.DataSource;
import javax.xml.bind.DatatypeConverter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.openjpa.lib.util.collections.BidiMap;
import org.apache.openjpa.lib.util.collections.DualHashBidiMap;
import org.apache.syncope.core.persistence.api.content.ContentExporter;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.jpa.content.AbstractContentDealer;
import org.apache.syncope.core.persistence.jpa.content.MultiParentNode;
import org.apache.syncope.core.persistence.jpa.content.MultiParentNodeOp;
import org.apache.syncope.core.provisioning.api.utils.FormatUtils;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.stereotype.Component;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@Component
public class XMLContentExporter
extends AbstractContentDealer
implements ContentExporter {
    protected static final Set<String> TABLE_PREFIXES_TO_BE_EXCLUDED = new HashSet<String>(Arrays.asList("QRTZ_", "LOGGING", "NotificationTask_recipients", "SYNCOPEAUDIT", "ReportExec", "TaskExec", "SyncopeUser", "UPlainAttr", "UPlainAttrValue", "UPlainAttrUniqueValue", "URelationship", "UMembership", "AnyObject", "APlainAttr", "APlainAttrValue", "APlainAttrUniqueValue", "ARelationship", "AMembership", "AccessToken"));
    protected static final Map<String, String> TABLES_TO_BE_FILTERED = Collections.singletonMap("TASK", "DTYPE <> 'PropagationTask' AND DTYPE <> 'NotificationTask'");
    protected static final Map<String, Set<String>> COLUMNS_TO_BE_NULLIFIED = Collections.singletonMap("SYNCOPEGROUP", Collections.singleton("USEROWNER_ID"));
    @Autowired
    private RealmDAO realmDAO;

    private boolean isTableAllowed(String tableName) {
        return TABLE_PREFIXES_TO_BE_EXCLUDED.stream().allMatch(prefix -> !tableName.toUpperCase().startsWith(prefix.toUpperCase()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> sortByForeignKeys(String dbSchema, Connection conn, Set<String> tableNames) throws SQLException {
        HashSet roots = new HashSet();
        DatabaseMetaData meta = conn.getMetaData();
        TreeMap<String, MultiParentNode<String>> exploited = new TreeMap<String, MultiParentNode<String>>(String.CASE_INSENSITIVE_ORDER);
        HashSet<String> pkTableNames = new HashSet<String>();
        for (String tableName : tableNames) {
            MultiParentNode<String> node = (MultiParentNode<String>)exploited.get(tableName);
            if (node == null) {
                node = new MultiParentNode<String>(tableName);
                roots.add(node);
                exploited.put(tableName, node);
            }
            pkTableNames.clear();
            ResultSet rs = null;
            try {
                rs = meta.getImportedKeys(conn.getCatalog(), dbSchema, tableName);
                while (rs.next()) {
                    pkTableNames.add(rs.getString("PKTABLE_NAME"));
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        LOG.error("While closing tables result set", (Throwable)e);
                    }
                }
            }
            for (String pkTableName : pkTableNames) {
                if (tableName.equalsIgnoreCase(pkTableName)) continue;
                MultiParentNode<String> pkNode = (MultiParentNode<String>)exploited.get(pkTableName);
                if (pkNode == null) {
                    pkNode = new MultiParentNode<String>(pkTableName);
                    roots.add(pkNode);
                    exploited.put(pkTableName, pkNode);
                }
                pkNode.addChild(node);
                if (!roots.contains(node)) continue;
                roots.remove(node);
            }
        }
        ArrayList<String> sortedTableNames = new ArrayList<String>(tableNames.size());
        MultiParentNodeOp.traverseTree(roots, sortedTableNames);
        sortedTableNames.retainAll(tableNames);
        LOG.debug("Tables after retainAll {}", sortedTableNames);
        Collections.reverse(sortedTableNames);
        return sortedTableNames;
    }

    private String getValues(ResultSet rs, String columnName, Integer columnType) throws SQLException {
        String res = null;
        try {
            switch (columnType) {
                case -4: 
                case -3: 
                case -2: {
                    InputStream is = rs.getBinaryStream(columnName);
                    if (is != null) {
                        res = DatatypeConverter.printHexBinary((byte[])IOUtils.toByteArray((InputStream)is));
                    }
                    break;
                }
                case 2004: {
                    Blob blob = rs.getBlob(columnName);
                    if (blob != null) {
                        res = DatatypeConverter.printHexBinary((byte[])IOUtils.toByteArray((InputStream)blob.getBinaryStream()));
                    }
                    break;
                }
                case -7: 
                case 16: {
                    if (rs.getBoolean(columnName)) {
                        res = "1";
                        break;
                    }
                    res = "0";
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    Timestamp timestamp = rs.getTimestamp(columnName);
                    if (timestamp != null) {
                        res = FormatUtils.format((Date)new Date(timestamp.getTime()));
                    }
                    break;
                }
                default: {
                    res = rs.getString(columnName);
                    break;
                }
            }
        }
        catch (IOException e) {
            LOG.error("Error retrieving hexadecimal string", (Throwable)e);
        }
        return res;
    }

    private String columnName(Supplier<Stream<Attribute<?, ?>>> attrs, String columnName) {
        String name = attrs.get().map(attr -> {
            if (attr.getName().equalsIgnoreCase(columnName)) {
                return attr.getName();
            }
            Field field = (Field)attr.getJavaMember();
            Column column = field.getAnnotation(Column.class);
            if (column != null && column.name().equalsIgnoreCase(columnName)) {
                return column.name();
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(columnName);
        if (StringUtils.endsWithIgnoreCase((CharSequence)name, (CharSequence)"_ID")) {
            String left = StringUtils.substringBefore((String)name, (String)"_");
            String prefix = attrs.get().filter(attr -> left.equalsIgnoreCase(attr.getName())).findFirst().map(Attribute::getName).orElse(left);
            name = prefix + "_id";
        }
        return name;
    }

    private boolean isTask(String tableName) {
        return "TASK".equalsIgnoreCase(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportTable(TransformerHandler handler, Connection conn, String tableName, String whereClause, BidiMap<String, EntityType<?>> entities, Set<EntityType<?>> taskEntities, Map<String, Pair<String, String>> relationTables) throws SQLException, SAXException {
        LOG.debug("Export table {}", (Object)tableName);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String outputTableName;
            StringBuilder orderBy = new StringBuilder();
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet pkeyRS = null;
            try {
                pkeyRS = meta.getPrimaryKeys(null, null, tableName);
                while (pkeyRS.next()) {
                    String columnName = pkeyRS.getString("COLUMN_NAME");
                    if (columnName == null) continue;
                    if (orderBy.length() > 0) {
                        orderBy.append(",");
                    }
                    orderBy.append(columnName);
                }
            }
            finally {
                if (pkeyRS != null) {
                    try {
                        pkeyRS.close();
                    }
                    catch (SQLException e) {
                        LOG.error("While closing result set", (Throwable)e);
                    }
                }
            }
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM ").append(tableName).append(" a");
            if (StringUtils.isNotBlank((CharSequence)whereClause)) {
                query.append(" WHERE ").append(whereClause);
            }
            if (orderBy.length() > 0) {
                query.append(" ORDER BY ").append((CharSequence)orderBy);
            }
            stmt = conn.prepareStatement(query.toString());
            ArrayList rows = new ArrayList();
            Optional<EntityType> entity = entities.entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(tableName)).findFirst().map(Map.Entry::getValue);
            String string = outputTableName = entity.isPresent() ? (String)entities.getKey((Object)entity.get()) : relationTables.keySet().stream().filter(key -> tableName.equalsIgnoreCase((String)key)).findFirst().orElse(tableName);
            if (this.isTask(tableName)) {
                outputTableName = "Task";
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                HashMap<String, String> row = new HashMap<String, String>();
                rows.add(row);
                ResultSetMetaData resultSetMetaData = rs.getMetaData();
                for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                    Integer columnType;
                    String columnName = resultSetMetaData.getColumnName(i + 1);
                    String value2 = this.getValues(rs, columnName, columnType = Integer.valueOf(resultSetMetaData.getColumnType(i + 1)));
                    if (value2 == null || COLUMNS_TO_BE_NULLIFIED.containsKey(tableName) && COLUMNS_TO_BE_NULLIFIED.get(tableName).contains(columnName)) continue;
                    String name = columnName;
                    if (entity.isPresent()) {
                        name = this.columnName(() -> ((EntityType)entity.get()).getAttributes().stream(), columnName);
                    }
                    if (this.isTask(tableName)) {
                        name = this.columnName(() -> taskEntities.stream().flatMap(e -> e.getAttributes().stream()), columnName);
                    }
                    if (relationTables.containsKey(outputTableName)) {
                        Pair<String, String> relationColumns = relationTables.get(outputTableName);
                        if (name.equalsIgnoreCase((String)relationColumns.getLeft())) {
                            name = (String)relationColumns.getLeft();
                        } else if (name.equalsIgnoreCase((String)relationColumns.getRight())) {
                            name = (String)relationColumns.getRight();
                        }
                    }
                    row.put(name, value2);
                    LOG.debug("Add for table {}: {}=\"{}\"", new Object[]{outputTableName, name, value2});
                }
            }
            if (tableName.equalsIgnoreCase("Realm")) {
                ArrayList realmRows = new ArrayList(rows);
                rows.clear();
                this.realmDAO.findAll().forEach(realm -> realmRows.stream().filter(row -> {
                    String id = (String)row.get("ID");
                    if (id == null) {
                        id = (String)row.get("id");
                    }
                    return realm.getKey().equals(id);
                }).findFirst().ifPresent(row -> rows.add(row)));
            }
            for (Map map : rows) {
                AttributesImpl attrs = new AttributesImpl();
                map.forEach((key, value) -> attrs.addAttribute("", "", (String)key, "CDATA", (String)value));
                handler.startElement("", "", outputTableName, attrs);
                handler.endElement("", "", outputTableName);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    LOG.error("While closing result set", (Throwable)e);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    LOG.error("While closing statement", (Throwable)e);
                }
            }
        }
    }

    private Set<EntityType<?>> taskEntities(Set<EntityType<?>> entityTypes) {
        return entityTypes.stream().filter(e -> e.getName().endsWith("Task")).collect(Collectors.toSet());
    }

    private BidiMap<String, EntityType<?>> entities(Set<EntityType<?>> entityTypes) {
        DualHashBidiMap entities = new DualHashBidiMap();
        entityTypes.forEach(arg_0 -> XMLContentExporter.lambda$entities$13((BidiMap)entities, arg_0));
        return entities;
    }

    private Map<String, Pair<String, String>> relationTables(BidiMap<String, EntityType<?>> entities) {
        HashMap<String, Pair<String, String>> relationTables = new HashMap<String, Pair<String, String>>();
        entities.values().stream().forEach(e -> e.getAttributes().stream().filter(a -> a.getPersistentAttributeType() != Attribute.PersistentAttributeType.BASIC).forEach(a -> {
            JoinTable joinTable;
            CollectionTable collectionTable;
            String attrName = a.getName();
            Field field = (Field)a.getJavaMember();
            Column column = field.getAnnotation(Column.class);
            if (column != null) {
                attrName = column.name();
            }
            if ((collectionTable = field.getAnnotation(CollectionTable.class)) != null) {
                relationTables.put(collectionTable.name(), Pair.of((Object)attrName, (Object)collectionTable.joinColumns()[0].name()));
            }
            if ((joinTable = field.getAnnotation(JoinTable.class)) != null) {
                String tableName = joinTable.name();
                if (StringUtils.isBlank((CharSequence)tableName)) {
                    tableName = (String)entities.getKey(e) + "_" + (String)entities.getKey((Object)((EntityType)((PluralAttribute)a).getElementType()));
                }
                relationTables.put(tableName, Pair.of((Object)joinTable.joinColumns()[0].name(), (Object)joinTable.inverseJoinColumns()[0].name()));
            }
        }));
        return relationTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(String domain, OutputStream os, String uwfPrefix, String gwfPrefix, String awfPrefix) throws SAXException, TransformerConfigurationException {
        if (StringUtils.isNotBlank((CharSequence)uwfPrefix)) {
            TABLE_PREFIXES_TO_BE_EXCLUDED.add(uwfPrefix);
        }
        if (StringUtils.isNotBlank((CharSequence)gwfPrefix)) {
            TABLE_PREFIXES_TO_BE_EXCLUDED.add(gwfPrefix);
        }
        if (StringUtils.isNotBlank((CharSequence)awfPrefix)) {
            TABLE_PREFIXES_TO_BE_EXCLUDED.add(awfPrefix);
        }
        StreamResult streamResult = new StreamResult(os);
        SAXTransformerFactory transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        TransformerHandler handler = transformerFactory.newTransformerHandler();
        Transformer serializer = handler.getTransformer();
        serializer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
        serializer.setOutputProperty("indent", "yes");
        handler.setResult(streamResult);
        handler.startDocument();
        handler.startElement("", "", "dataset", new AttributesImpl());
        DataSource dataSource = (DataSource)this.domainsHolder.getDomains().get(domain);
        if (dataSource == null) {
            throw new IllegalArgumentException("Could not find DataSource for domain " + domain);
        }
        String schema = (String)ApplicationContextProvider.getBeanFactory().getBean(domain + "DatabaseSchema", String.class);
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = DataSourceUtils.getConnection((DataSource)dataSource);
            DatabaseMetaData meta = conn.getMetaData();
            rs = meta.getTables(null, StringUtils.isBlank((CharSequence)schema) ? null : schema, null, new String[]{"TABLE"});
            TreeSet<String> tableNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                LOG.debug("Found table {}", (Object)tableName);
                if (!this.isTableAllowed(tableName)) continue;
                tableNames.add(tableName);
            }
            LOG.debug("Tables to be exported {}", tableNames);
            EntityManagerFactory emf = EntityManagerFactoryUtils.findEntityManagerFactory((ListableBeanFactory)ApplicationContextProvider.getBeanFactory(), (String)domain);
            Set entityTypes = emf == null ? Collections.emptySet() : emf.getMetamodel().getEntities();
            BidiMap<String, EntityType<?>> entities = this.entities(entityTypes);
            for (String tableName : this.sortByForeignKeys(schema, conn, tableNames)) {
                try {
                    this.exportTable(handler, conn, tableName, TABLES_TO_BE_FILTERED.get(tableName.toUpperCase()), entities, this.taskEntities(entityTypes), this.relationTables(entities));
                }
                catch (Exception e) {
                    LOG.error("Failure exporting table {}", (Object)tableName, (Object)e);
                }
            }
        }
        catch (SQLException e) {
            LOG.error("While exporting database content", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    LOG.error("While closing tables result set", (Throwable)e);
                }
            }
            DataSourceUtils.releaseConnection((Connection)conn, (DataSource)dataSource);
            if (conn != null) {
                try {
                    if (!conn.isClosed()) {
                        conn.close();
                    }
                }
                catch (SQLException e) {
                    LOG.error("While releasing connection", (Throwable)e);
                }
            }
        }
        handler.endElement("", "", "dataset");
        handler.endDocument();
    }

    private static /* synthetic */ void lambda$entities$13(BidiMap entities, EntityType entity) {
        Table table = entity.getBindableJavaType().getAnnotation(Table.class);
        if (table != null) {
            entities.put((Object)table.name(), (Object)entity);
        }
    }
}

