/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.ImplementationType;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.PushActions;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopeSinglePushExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.UserPushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.PushJobDelegate;
import org.apache.syncope.core.spring.ImplementationManager;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public class SinglePushJobDelegate
extends PushJobDelegate
implements SyncopeSinglePushExecutor {
    @Autowired
    private ImplementationDAO implementationDAO;

    private List<PushActions> before(Provision provision, Connector connector, PushTaskTO pushTaskTO) throws JobExecutionException {
        LOG.debug("Executing push on {}", (Object)provision.getResource());
        ArrayList<PushActions> actions = new ArrayList<PushActions>();
        pushTaskTO.getActions().forEach(key -> {
            Implementation impl = this.implementationDAO.find(key);
            if (impl == null || impl.getType() != ImplementationType.PUSH_ACTIONS) {
                LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", key);
            } else {
                try {
                    actions.add((PushActions)ImplementationManager.build((Implementation)impl));
                }
                catch (Exception e) {
                    LOG.warn("While building {}", (Object)impl, (Object)e);
                }
            }
        });
        PushTask pushTask = (PushTask)this.entityFactory.newEntity(PushTask.class);
        pushTask.setResource(provision.getResource());
        pushTask.setMatchingRule(pushTaskTO.getMatchingRule() == null ? MatchingRule.LINK : pushTaskTO.getMatchingRule());
        pushTask.setUnmatchingRule(pushTaskTO.getUnmatchingRule() == null ? UnmatchingRule.ASSIGN : pushTaskTO.getUnmatchingRule());
        pushTask.setPerformCreate(pushTaskTO.isPerformCreate());
        pushTask.setPerformUpdate(pushTaskTO.isPerformUpdate());
        pushTask.setPerformDelete(pushTaskTO.isPerformDelete());
        pushTask.setSyncStatus(pushTaskTO.isSyncStatus());
        this.profile = new ProvisioningProfile(connector, (ProvisioningTask)pushTask);
        this.profile.getActions().addAll(actions);
        this.profile.setConflictResolutionAction(ConflictResolutionAction.FIRSTMATCH);
        for (PushActions action : actions) {
            action.beforeAll(this.profile);
        }
        return actions;
    }

    public List<ProvisioningReport> push(Provision provision, Connector connector, Any<?> any, PushTaskTO pushTaskTO) throws JobExecutionException {
        try {
            UserPushResultHandler handler;
            List<PushActions> actions = this.before(provision, connector, pushTaskTO);
            switch (provision.getAnyType().getKind()) {
                case USER: {
                    handler = this.buildUserHandler();
                    break;
                }
                case GROUP: {
                    handler = this.buildGroupHandler();
                    break;
                }
                default: {
                    handler = this.buildAnyObjectHandler();
                }
            }
            handler.setProfile(this.profile);
            this.doHandle(Collections.singletonList(any), (SyncopePushResultHandler)handler, provision.getResource());
            for (PushActions action : actions) {
                action.afterAll(this.profile);
            }
            return this.profile.getResults();
        }
        catch (Exception e) {
            throw e instanceof JobExecutionException ? (JobExecutionException)((Object)e) : new JobExecutionException("While pushing to connector", (Throwable)e);
        }
    }

    public ProvisioningReport push(Provision provision, Connector connector, LinkedAccount account, PushTaskTO pushTaskTO) throws JobExecutionException {
        try {
            List<PushActions> actions = this.before(provision, connector, pushTaskTO);
            UserPushResultHandler handler = this.buildUserHandler();
            handler.setProfile(this.profile);
            handler.handle(account, provision);
            for (PushActions action : actions) {
                action.afterAll(this.profile);
            }
            return (ProvisioningReport)this.profile.getResults().get(0);
        }
        catch (Exception e) {
            throw e instanceof JobExecutionException ? (JobExecutionException)((Object)e) : new JobExecutionException("While pushing to connector", (Throwable)e);
        }
    }
}

