/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.types.ImplementationType;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.DomainsHolder;
import org.apache.syncope.core.persistence.api.SyncopeLoader;
import org.apache.syncope.core.persistence.api.dao.ConfDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.ReportDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.api.entity.conf.CPlainAttr;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.provisioning.api.job.JobManager;
import org.apache.syncope.core.provisioning.api.job.JobNamer;
import org.apache.syncope.core.provisioning.api.job.SchedTaskJobDelegate;
import org.apache.syncope.core.provisioning.java.job.SystemLoadReporterJob;
import org.apache.syncope.core.provisioning.java.job.TaskJob;
import org.apache.syncope.core.provisioning.java.job.notification.NotificationJob;
import org.apache.syncope.core.provisioning.java.job.report.ReportJob;
import org.apache.syncope.core.provisioning.java.pushpull.PullJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.PushJobDelegate;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.identityconnectors.common.IOUtil;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.transaction.annotation.Transactional;

public class JobManagerImpl
implements JobManager,
SyncopeLoader {
    private static final Logger LOG = LoggerFactory.getLogger(JobManager.class);
    @Autowired
    private DomainsHolder domainsHolder;
    @Autowired
    private SchedulerFactoryBean scheduler;
    @Autowired
    private TaskDAO taskDAO;
    @Autowired
    private ReportDAO reportDAO;
    @Autowired
    private ConfDAO confDAO;
    @Autowired
    private ImplementationDAO implementationDAO;
    private boolean disableQuartzInstance;

    public void setDisableQuartzInstance(boolean disableQuartzInstance) {
        this.disableQuartzInstance = disableQuartzInstance;
    }

    private boolean isRunningHere(JobKey jobKey) throws SchedulerException {
        return this.scheduler.getScheduler().getCurrentlyExecutingJobs().stream().anyMatch(jec -> jobKey.equals((Object)jec.getJobDetail().getKey()));
    }

    private boolean isRunningElsewhere(JobKey jobKey) throws SchedulerException {
        boolean bl;
        if (!this.scheduler.getScheduler().getMetaData().isJobStoreClustered()) {
            return false;
        }
        DataSource dataSource = (DataSource)this.domainsHolder.getDomains().get("Master");
        Connection conn = DataSourceUtils.getConnection((DataSource)dataSource);
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = conn.prepareStatement("SELECT 1 FROM QRTZ_FIRED_TRIGGERS WHERE JOB_NAME = ? AND JOB_GROUP = ?");
            stmt.setString(1, jobKey.getName());
            stmt.setString(2, jobKey.getGroup());
            resultSet = stmt.executeQuery();
            bl = resultSet.next();
        }
        catch (SQLException e) {
            try {
                throw new SchedulerException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.quietClose(resultSet);
                IOUtil.quietClose((Statement)stmt);
                DataSourceUtils.releaseConnection((Connection)conn, (DataSource)dataSource);
                throw throwable;
            }
        }
        IOUtil.quietClose((ResultSet)resultSet);
        IOUtil.quietClose((Statement)stmt);
        DataSourceUtils.releaseConnection((Connection)conn, (DataSource)dataSource);
        return bl;
    }

    public boolean isRunning(JobKey jobKey) throws SchedulerException {
        return this.isRunningHere(jobKey) || this.isRunningElsewhere(jobKey);
    }

    private void registerJob(String jobName, Class<? extends Job> jobClass, String cronExpression, Date startAt, Map<String, Object> jobMap) throws SchedulerException {
        if (this.isRunning(new JobKey(jobName, "DEFAULT"))) {
            LOG.debug("Job {} already running, cancel", (Object)jobName);
            return;
        }
        this.unregisterJob(jobName);
        JobBuilder jobDetailBuilder = JobBuilder.newJob(jobClass).withIdentity(jobName).usingJobData(new JobDataMap(jobMap));
        if (cronExpression == null && startAt == null) {
            this.scheduler.getScheduler().addJob(jobDetailBuilder.storeDurably().build(), true);
        } else {
            TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(JobNamer.getTriggerName((String)jobName));
            if (cronExpression == null) {
                triggerBuilder.startAt(startAt);
            } else {
                triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression));
                if (startAt == null) {
                    triggerBuilder.startNow();
                } else {
                    triggerBuilder.startAt(startAt);
                }
            }
            this.scheduler.getScheduler().scheduleJob(jobDetailBuilder.build(), triggerBuilder.build());
        }
    }

    public Map<String, Object> register(SchedTask task, Date startAt, long interruptMaxRetries) throws SchedulerException {
        Implementation jobDelegate;
        Object object = task.getJobDelegate() == null ? (task instanceof PullTask ? (Implementation)this.implementationDAO.find(ImplementationType.TASKJOB_DELEGATE).stream().filter(impl -> PullJobDelegate.class.getName().equals(impl.getBody())).findFirst().orElse(null) : (task instanceof PushTask ? (Implementation)this.implementationDAO.find(ImplementationType.TASKJOB_DELEGATE).stream().filter(impl -> PushJobDelegate.class.getName().equals(impl.getBody())).findFirst().orElse(null) : null)) : (jobDelegate = task.getJobDelegate());
        if (jobDelegate == null) {
            throw new IllegalArgumentException("Task " + task + " does not provide any " + SchedTaskJobDelegate.class.getSimpleName());
        }
        HashMap<String, Object> jobMap = new HashMap<String, Object>();
        jobMap.put("task", task.getKey());
        jobMap.put("domain", AuthContextUtils.getDomain());
        jobMap.put("delegateImpl", jobDelegate.getKey());
        this.registerJob(JobNamer.getJobKey((Task)task).getName(), TaskJob.class, task.getCronExpression(), startAt, jobMap);
        return jobMap;
    }

    public void register(Report report, Date startAt, long interruptMaxRetries) throws SchedulerException {
        HashMap<String, Object> jobMap = new HashMap<String, Object>();
        jobMap.put("report", report.getKey());
        jobMap.put("domain", AuthContextUtils.getDomain());
        this.registerJob(JobNamer.getJobKey((Report)report).getName(), ReportJob.class, report.getCronExpression(), startAt, jobMap);
    }

    private void unregisterJob(String jobName) {
        try {
            this.scheduler.getScheduler().unscheduleJob(new TriggerKey(jobName, "DEFAULT"));
            this.scheduler.getScheduler().deleteJob(new JobKey(jobName, "DEFAULT"));
        }
        catch (SchedulerException e) {
            LOG.error("Could not remove job " + jobName, (Throwable)e);
        }
    }

    public void unregister(Task task) {
        this.unregisterJob(JobNamer.getJobKey((Task)task).getName());
    }

    public void unregister(Report report) {
        this.unregisterJob(JobNamer.getJobKey((Report)report).getName());
    }

    public Integer getPriority() {
        return 200;
    }

    @Transactional
    public void load() {
        if (this.disableQuartzInstance) {
            String instanceId = "AUTO";
            try {
                instanceId = this.scheduler.getScheduler().getSchedulerInstanceId();
                this.scheduler.getScheduler().standby();
                LOG.info("Successfully put Quartz instance {} in standby", (Object)instanceId);
            }
            catch (SchedulerException e) {
                LOG.error("Could not put Quartz instance {} in standby", (Object)instanceId, (Object)e);
            }
            return;
        }
        Pair conf = (Pair)AuthContextUtils.execWithAuthContext((String)"Master", () -> {
            String notificationJobCronExpression = "";
            Optional notificationJobCronExp = this.confDAO.find("notificationjob.cronExpression");
            if (!notificationJobCronExp.isPresent()) {
                notificationJobCronExpression = "0 0/5 * * * ?";
            } else if (!((CPlainAttr)notificationJobCronExp.get()).getValuesAsStrings().isEmpty()) {
                notificationJobCronExpression = (String)((CPlainAttr)notificationJobCronExp.get()).getValuesAsStrings().get(0);
            }
            long interruptMaxRetries = (Long)this.confDAO.find("tasks.interruptMaxRetries", (Object)1L);
            return Pair.of((Object)notificationJobCronExpression, (Object)interruptMaxRetries);
        });
        for (String domain : this.domainsHolder.getDomains().keySet()) {
            AuthContextUtils.execWithAuthContext((String)domain, () -> {
                HashSet tasks = new HashSet(this.taskDAO.findAll(TaskType.SCHEDULED));
                tasks.addAll(this.taskDAO.findAll(TaskType.PULL));
                tasks.addAll(this.taskDAO.findAll(TaskType.PUSH));
                boolean loadException = false;
                Iterator it = tasks.iterator();
                while (it.hasNext() && !loadException) {
                    SchedTask task = (SchedTask)it.next();
                    try {
                        this.register(task, task.getStartAt(), (long)((Long)conf.getRight()));
                    }
                    catch (Exception e) {
                        LOG.error("While loading job instance for task " + task.getKey(), (Throwable)e);
                        loadException = true;
                    }
                }
                if (loadException) {
                    LOG.debug("Errors while loading job instances for tasks, aborting");
                } else {
                    it = this.reportDAO.findAll().iterator();
                    while (it.hasNext() && !loadException) {
                        Report report = (Report)it.next();
                        try {
                            this.register(report, null, (long)((Long)conf.getRight()));
                        }
                        catch (Exception e) {
                            LOG.error("While loading job instance for report " + report.getName(), (Throwable)e);
                            loadException = true;
                        }
                    }
                    if (loadException) {
                        LOG.debug("Errors while loading job instances for reports, aborting");
                    }
                }
                return null;
            });
        }
        HashMap<String, Object> jobMap = new HashMap<String, Object>();
        jobMap.put("domain", AuthContextUtils.getDomain());
        if (StringUtils.isBlank((CharSequence)((CharSequence)conf.getLeft()))) {
            LOG.debug("Empty value provided for {}'s cron, not registering anything on Quartz", (Object)NotificationJob.class.getSimpleName());
        } else {
            LOG.debug("{}'s cron expression: {} - registering Quartz job and trigger", (Object)NotificationJob.class.getSimpleName(), conf.getLeft());
            try {
                this.registerJob(NOTIFICATION_JOB.getName(), NotificationJob.class, (String)conf.getLeft(), null, jobMap);
            }
            catch (Exception e) {
                LOG.error("While loading {} instance", (Object)NotificationJob.class.getSimpleName(), (Object)e);
            }
        }
        LOG.debug("Registering {}", SystemLoadReporterJob.class);
        try {
            this.registerJob("systemLoadReporterJob", SystemLoadReporterJob.class, "0 * * * * ?", null, jobMap);
        }
        catch (Exception e) {
            LOG.error("While loading {} instance", (Object)SystemLoadReporterJob.class.getSimpleName(), (Object)e);
        }
    }
}

