/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.stream.Collectors;
import org.apache.syncope.common.lib.policy.AccountPolicyTO;
import org.apache.syncope.common.lib.policy.PasswordPolicyTO;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.policy.PropagationPolicyTO;
import org.apache.syncope.common.lib.policy.PullPolicyTO;
import org.apache.syncope.common.lib.policy.PushPolicyTO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.api.entity.policy.PropagationPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PullCorrelationRuleEntity;
import org.apache.syncope.core.persistence.api.entity.policy.PullPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PushCorrelationRuleEntity;
import org.apache.syncope.core.persistence.api.entity.policy.PushPolicy;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.provisioning.api.data.PolicyDataBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PolicyDataBinderImpl
implements PolicyDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyDataBinder.class);
    @Autowired
    private ExternalResourceDAO resourceDAO;
    @Autowired
    private RealmDAO realmDAO;
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private ImplementationDAO implementationDAO;
    @Autowired
    private EntityFactory entityFactory;

    private <T extends Policy> T getPolicy(T policy, PolicyTO policyTO) {
        Object result = policy;
        if (policyTO instanceof PasswordPolicyTO) {
            if (result == null) {
                result = (Policy)this.entityFactory.newEntity(PasswordPolicy.class);
            }
            PasswordPolicy passwordPolicy = (PasswordPolicy)PasswordPolicy.class.cast(result);
            PasswordPolicyTO passwordPolicyTO = (PasswordPolicyTO)PasswordPolicyTO.class.cast(policyTO);
            passwordPolicy.setAllowNullPassword(passwordPolicyTO.isAllowNullPassword());
            passwordPolicy.setHistoryLength(passwordPolicyTO.getHistoryLength());
            passwordPolicyTO.getRules().forEach(ruleKey -> {
                Implementation rule = this.implementationDAO.find(ruleKey);
                if (rule == null) {
                    LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", ruleKey);
                } else {
                    passwordPolicy.add(rule);
                }
            });
            passwordPolicy.getRules().removeIf(implementation -> !passwordPolicyTO.getRules().contains(implementation.getKey()));
        } else if (policyTO instanceof AccountPolicyTO) {
            if (result == null) {
                result = (Policy)this.entityFactory.newEntity(AccountPolicy.class);
            }
            AccountPolicy accountPolicy = (AccountPolicy)AccountPolicy.class.cast(result);
            AccountPolicyTO accountPolicyTO = (AccountPolicyTO)AccountPolicyTO.class.cast(policyTO);
            accountPolicy.setMaxAuthenticationAttempts(accountPolicyTO.getMaxAuthenticationAttempts());
            accountPolicy.setPropagateSuspension(accountPolicyTO.isPropagateSuspension());
            accountPolicyTO.getRules().forEach(ruleKey -> {
                Implementation rule = this.implementationDAO.find(ruleKey);
                if (rule == null) {
                    LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", ruleKey);
                } else {
                    accountPolicy.add(rule);
                }
            });
            accountPolicy.getRules().removeIf(implementation -> !accountPolicyTO.getRules().contains(implementation.getKey()));
            accountPolicy.getResources().clear();
            accountPolicyTO.getPassthroughResources().forEach(resourceName -> {
                ExternalResource resource = this.resourceDAO.find(resourceName);
                if (resource == null) {
                    LOG.debug("Ignoring invalid resource {} ", resourceName);
                } else {
                    accountPolicy.add(resource);
                }
            });
        } else if (policyTO instanceof PropagationPolicyTO) {
            if (result == null) {
                result = (Policy)this.entityFactory.newEntity(PropagationPolicy.class);
            }
            PropagationPolicy propagationPolicy = (PropagationPolicy)PropagationPolicy.class.cast(result);
            PropagationPolicyTO propagationPolicyTO = (PropagationPolicyTO)PropagationPolicyTO.class.cast(policyTO);
            propagationPolicy.setBackOffStrategy(propagationPolicyTO.getBackOffStrategy());
            propagationPolicy.setBackOffParams(propagationPolicyTO.getBackOffParams());
            propagationPolicy.setMaxAttempts(propagationPolicyTO.getMaxAttempts());
        } else if (policyTO instanceof PullPolicyTO) {
            if (result == null) {
                result = (Policy)this.entityFactory.newEntity(PullPolicy.class);
            }
            PullPolicy pullPolicy = (PullPolicy)PullPolicy.class.cast(result);
            PullPolicyTO pullPolicyTO = (PullPolicyTO)PullPolicyTO.class.cast(policyTO);
            pullPolicy.setConflictResolutionAction(pullPolicyTO.getConflictResolutionAction());
            pullPolicyTO.getCorrelationRules().forEach((type, impl) -> {
                AnyType anyType = this.anyTypeDAO.find(type);
                if (anyType == null) {
                    LOG.debug("Invalid AnyType {} specified, ignoring...", type);
                } else {
                    Implementation rule;
                    PullCorrelationRuleEntity correlationRule = pullPolicy.getCorrelationRule(anyType).orElse(null);
                    if (correlationRule == null) {
                        correlationRule = (PullCorrelationRuleEntity)this.entityFactory.newEntity(PullCorrelationRuleEntity.class);
                        correlationRule.setAnyType(anyType);
                        correlationRule.setPullPolicy(pullPolicy);
                        pullPolicy.add(correlationRule);
                    }
                    if ((rule = this.implementationDAO.find(impl)) == null) {
                        throw new NotFoundException("Implementation " + type + " " + impl);
                    }
                    correlationRule.setImplementation(rule);
                }
            });
            pullPolicy.getCorrelationRules().removeIf(anyFilter -> !pullPolicyTO.getCorrelationRules().containsKey(anyFilter.getAnyType().getKey()));
        } else if (policyTO instanceof PushPolicyTO) {
            if (result == null) {
                result = (Policy)this.entityFactory.newEntity(PushPolicy.class);
            }
            PushPolicy pushPolicy = (PushPolicy)PushPolicy.class.cast(result);
            PushPolicyTO pushPolicyTO = (PushPolicyTO)PushPolicyTO.class.cast(policyTO);
            pushPolicy.setConflictResolutionAction(pushPolicyTO.getConflictResolutionAction());
            pushPolicyTO.getCorrelationRules().forEach((type, impl) -> {
                AnyType anyType = this.anyTypeDAO.find(type);
                if (anyType == null) {
                    LOG.debug("Invalid AnyType {} specified, ignoring...", type);
                } else {
                    Implementation rule;
                    PushCorrelationRuleEntity correlationRule = pushPolicy.getCorrelationRule(anyType).orElse(null);
                    if (correlationRule == null) {
                        correlationRule = (PushCorrelationRuleEntity)this.entityFactory.newEntity(PushCorrelationRuleEntity.class);
                        correlationRule.setAnyType(anyType);
                        correlationRule.setPushPolicy(pushPolicy);
                        pushPolicy.add(correlationRule);
                    }
                    if ((rule = this.implementationDAO.find(impl)) == null) {
                        throw new NotFoundException("Implementation " + type + " " + impl);
                    }
                    correlationRule.setImplementation(rule);
                }
            });
            pushPolicy.getCorrelationRules().removeIf(anyFilter -> !pushPolicyTO.getCorrelationRules().containsKey(anyFilter.getAnyType().getKey()));
        }
        if (result != null) {
            result.setDescription(policyTO.getDescription());
        }
        return result;
    }

    public <T extends Policy> T create(PolicyTO policyTO) {
        return this.getPolicy(null, policyTO);
    }

    public <T extends Policy> T update(T policy, PolicyTO policyTO) {
        return this.getPolicy(policy, policyTO);
    }

    public <T extends PolicyTO> T getPolicyTO(Policy policy) {
        PasswordPolicyTO policyTO = null;
        if (policy instanceof PasswordPolicy) {
            PasswordPolicyTO passwordPolicyTO;
            PasswordPolicy passwordPolicy = (PasswordPolicy)PasswordPolicy.class.cast(policy);
            policyTO = passwordPolicyTO = new PasswordPolicyTO();
            passwordPolicyTO.setAllowNullPassword(passwordPolicy.isAllowNullPassword());
            passwordPolicyTO.setHistoryLength(passwordPolicy.getHistoryLength());
            passwordPolicyTO.getRules().addAll(passwordPolicy.getRules().stream().map(Entity::getKey).collect(Collectors.toList()));
        } else if (policy instanceof AccountPolicy) {
            AccountPolicy accountPolicy = (AccountPolicy)AccountPolicy.class.cast(policy);
            AccountPolicyTO accountPolicyTO = new AccountPolicyTO();
            policyTO = accountPolicyTO;
            accountPolicyTO.setMaxAuthenticationAttempts(accountPolicy.getMaxAuthenticationAttempts());
            accountPolicyTO.setPropagateSuspension(accountPolicy.isPropagateSuspension());
            accountPolicyTO.getRules().addAll(accountPolicy.getRules().stream().map(Entity::getKey).collect(Collectors.toList()));
            accountPolicyTO.getPassthroughResources().addAll(accountPolicy.getResources().stream().map(Entity::getKey).collect(Collectors.toList()));
        } else if (policy instanceof PropagationPolicy) {
            PropagationPolicy propagationPolicy = (PropagationPolicy)PropagationPolicy.class.cast(policy);
            PropagationPolicyTO propagationPolicyTO = new PropagationPolicyTO();
            policyTO = propagationPolicyTO;
            propagationPolicyTO.setBackOffStrategy(propagationPolicy.getBackOffStrategy());
            propagationPolicyTO.setBackOffParams(propagationPolicy.getBackOffParams());
            propagationPolicyTO.setMaxAttempts(propagationPolicy.getMaxAttempts());
        } else if (policy instanceof PullPolicy) {
            PullPolicy pullPolicy = (PullPolicy)PullPolicy.class.cast(policy);
            PullPolicyTO pullPolicyTO = new PullPolicyTO();
            policyTO = pullPolicyTO;
            pullPolicyTO.setConflictResolutionAction(((PullPolicy)policy).getConflictResolutionAction());
            pullPolicy.getCorrelationRules().forEach(rule -> pullPolicyTO.getCorrelationRules().put(rule.getAnyType().getKey(), rule.getImplementation().getKey()));
        } else if (policy instanceof PushPolicy) {
            PushPolicy pushPolicy = (PushPolicy)PushPolicy.class.cast(policy);
            PushPolicyTO pushPolicyTO = new PushPolicyTO();
            policyTO = pushPolicyTO;
            pushPolicyTO.setConflictResolutionAction(((PushPolicy)policy).getConflictResolutionAction());
            pushPolicy.getCorrelationRules().forEach(rule -> pushPolicyTO.getCorrelationRules().put(rule.getAnyType().getKey(), rule.getImplementation().getKey()));
        }
        if (policyTO != null) {
            policyTO.setKey(policy.getKey());
            policyTO.setDescription(policy.getDescription());
            for (ExternalResource resource : this.resourceDAO.findByPolicy(policy)) {
                policyTO.getUsedByResources().add(resource.getKey());
            }
            for (Realm realm : this.realmDAO.findByPolicy(policy)) {
                policyTO.getUsedByRealms().add(realm.getFullPath());
            }
        }
        return (T)policyTO;
    }
}

