/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.syncope.core.persistence.api.dao.AllowedSchemas;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.LinkingMappingItem;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.provisioning.api.ConnectorFactory;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCache;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCacheKey;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCacheValue;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Component
public class VirAttrHandlerImpl
implements VirAttrHandler {
    private static final Logger LOG = LoggerFactory.getLogger(VirAttrHandler.class);
    @Autowired
    private ConnectorFactory connFactory;
    @Autowired
    private VirAttrCache virAttrCache;
    @Autowired
    private OutboundMatcher outboundMatcher;
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;

    public void setValues(Any<?> any, ConnectorObject connObj) {
        if (any == null) {
            LOG.debug("Null any passed, ignoring");
            return;
        }
        AllowedSchemas schemas = this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, VirSchema.class);
        Stream.concat(schemas.getForSelf().stream(), schemas.getForMemberships().values().stream().flatMap(Collection::stream)).forEach(schema -> {
            VirAttrCacheKey cacheKey = new VirAttrCacheKey(any.getType().getKey(), any.getKey(), schema.getKey());
            Attribute attr = connObj.getAttributeByName(schema.getExtAttrName());
            if (attr == null) {
                this.virAttrCache.expire(cacheKey);
                LOG.debug("Evicted from cache: {}", (Object)cacheKey);
            } else {
                VirAttrCacheValue cacheValue = new VirAttrCacheValue((Collection)attr.getValue());
                this.virAttrCache.put(cacheKey, cacheValue);
                LOG.debug("Set in cache: {}={}", (Object)cacheKey, (Object)cacheValue);
            }
        });
    }

    private Map<VirSchema, List<String>> getValues(Any<?> any, Set<VirSchema> schemas) {
        Set resources = this.anyUtilsFactory.getInstance(any).getAllResources(any);
        HashMap<VirSchema, List<String>> result = new HashMap<VirSchema, List<String>>();
        HashMap<Provision, Set> toRead = new HashMap<Provision, Set>();
        schemas.stream().filter(schema -> resources.contains(schema.getProvision().getResource())).forEach(schema -> {
            VirAttrCacheKey cacheKey = new VirAttrCacheKey(any.getType().getKey(), any.getKey(), schema.getKey());
            VirAttrCacheValue cacheValue = this.virAttrCache.get(cacheKey);
            if (cacheValue != null) {
                LOG.debug("Found in cache: {}={}", (Object)cacheKey, (Object)cacheValue);
                result.put((VirSchema)schema, cacheValue.getValues());
            } else if (schema.getProvision().getAnyType().equals(any.getType())) {
                HashSet<VirSchema> schemasToRead = (HashSet<VirSchema>)toRead.get(schema.getProvision());
                if (schemasToRead == null) {
                    schemasToRead = new HashSet<VirSchema>();
                    toRead.put(schema.getProvision(), schemasToRead);
                }
                schemasToRead.add((VirSchema)schema);
            }
        });
        toRead.forEach((provision, schemasToRead) -> {
            LOG.debug("About to read from {}: {}", provision, schemasToRead);
            this.outboundMatcher.match(this.connFactory.getConnector(provision.getResource()), any, (Provision)provision, Optional.empty(), (LinkingMappingItem[])schemasToRead.stream().map(VirSchema::asLinkingMappingItem).toArray(LinkingMappingItem[]::new)).forEach(connObj -> schemasToRead.forEach(schema -> {
                Attribute attr = connObj.getAttributeByName(schema.getExtAttrName());
                if (attr != null) {
                    VirAttrCacheKey cacheKey = new VirAttrCacheKey(any.getType().getKey(), any.getKey(), schema.getKey());
                    VirAttrCacheValue cacheValue = this.virAttrCache.put(cacheKey, new VirAttrCacheValue((Collection)attr.getValue()));
                    LOG.debug("Set in cache: {}={}", (Object)cacheKey, (Object)cacheValue);
                    result.put((VirSchema)schema, cacheValue.getValues());
                }
            }));
        });
        return result;
    }

    public List<String> getValues(Any<?> any, VirSchema schema) {
        if (!this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, VirSchema.class).forSelfContains((Schema)schema)) {
            LOG.debug("{} not allowed for {}", (Object)schema, any);
            return Collections.emptyList();
        }
        List<String> result = this.getValues(any, Collections.singleton(schema)).get(schema);
        return result == null ? Collections.emptyList() : result;
    }

    public List<String> getValues(Any<?> any, Membership<?> membership, VirSchema schema) {
        if (!this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, VirSchema.class).getForMembership((Group)membership.getRightEnd()).contains(schema)) {
            LOG.debug("{} not allowed for {}", (Object)schema, any);
            return Collections.emptyList();
        }
        List<String> result = this.getValues(any, Collections.singleton(schema)).get(schema);
        return result == null ? Collections.emptyList() : result;
    }

    public Map<VirSchema, List<String>> getValues(Any<?> any) {
        return this.getValues(any, this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, VirSchema.class).getForSelf());
    }

    public Map<VirSchema, List<String>> getValues(Any<?> any, Membership<?> membership) {
        return this.getValues(any, this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, VirSchema.class).getForMembership((Group)membership.getRightEnd()));
    }
}

