/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.common.lib.log.AuditEntry;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.syncope.common.lib.types.LoggerLevel;
import org.apache.syncope.core.persistence.api.dao.LoggerDAO;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.event.AfterHandlingEvent;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.provisioning.api.utils.ExceptionUtils2;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class DefaultAuditManager
implements AuditManager {
    private static final String MASKED_VALUE = "<MASKED>";
    @Autowired
    private LoggerDAO loggerDAO;

    private static Object maskSensitive(Object object) {
        Object masked;
        if (object instanceof UserTO) {
            masked = SerializationUtils.clone((Serializable)((UserTO)object));
            if (((UserTO)masked).getPassword() != null) {
                ((UserTO)masked).setPassword(MASKED_VALUE);
            }
            if (((UserTO)masked).getSecurityAnswer() != null) {
                ((UserTO)masked).setSecurityAnswer(MASKED_VALUE);
            }
        } else if (object instanceof UserPatch && ((UserPatch)object).getPassword() != null) {
            masked = SerializationUtils.clone((Serializable)((UserPatch)object));
            ((UserPatch)masked).getPassword().setValue((Object)MASKED_VALUE);
        } else {
            masked = object;
        }
        return masked;
    }

    public boolean auditRequested(String who, AuditElements.EventCategoryType type, String category, String subcategory, String event) {
        boolean auditRequested;
        AuditEntry auditEntry = new AuditEntry();
        auditEntry.setWho(who);
        auditEntry.setLogger(new AuditLoggerName.Builder().type(type).category(category).subcategory(subcategory).event(event).result(AuditElements.Result.SUCCESS).build());
        auditEntry.setDate(new Date());
        org.apache.syncope.core.persistence.api.entity.Logger syncopeLogger = this.loggerDAO.find(auditEntry.getLogger().toLoggerName());
        boolean bl = auditRequested = syncopeLogger != null && syncopeLogger.getLevel() == LoggerLevel.DEBUG;
        if (auditRequested) {
            return true;
        }
        auditEntry.setLogger(new AuditLoggerName.Builder().type(type).category(category).subcategory(subcategory).event(event).result(AuditElements.Result.FAILURE).build());
        syncopeLogger = this.loggerDAO.find(auditEntry.getLogger().toLoggerName());
        auditRequested = syncopeLogger != null && syncopeLogger.getLevel() == LoggerLevel.DEBUG;
        return auditRequested;
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void audit(AfterHandlingEvent event) {
        this.audit(event.getWho(), event.getType(), event.getCategory(), event.getSubcategory(), event.getEvent(), event.getCondition(), event.getBefore(), event.getOutput(), event.getInput());
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void audit(String who, AuditElements.EventCategoryType type, String category, String subcategory, String event, AuditElements.Result condition, Object before, Object output, Object ... input) {
        AuditLoggerName auditLoggerName = new AuditLoggerName.Builder().type(type).category(category).subcategory(subcategory).event(event).result(condition).build();
        org.apache.syncope.core.persistence.api.entity.Logger syncopeLogger = this.loggerDAO.find(auditLoggerName.toLoggerName());
        if (syncopeLogger != null && syncopeLogger.getLevel() == LoggerLevel.DEBUG) {
            Throwable throwable = null;
            if (output instanceof Throwable) {
                throwable = (Throwable)output;
            }
            AuditEntry auditEntry = new AuditEntry();
            auditEntry.setWho(who);
            auditEntry.setLogger(auditLoggerName);
            auditEntry.setDate(new Date());
            auditEntry.setBefore(POJOHelper.serialize((Object)DefaultAuditManager.maskSensitive(before)));
            if (throwable == null) {
                auditEntry.setOutput(POJOHelper.serialize((Object)DefaultAuditManager.maskSensitive(output)));
            } else {
                auditEntry.setOutput(throwable.getMessage());
                auditEntry.setThrowable(ExceptionUtils2.getFullStackTrace((Throwable)throwable));
            }
            if (input != null) {
                auditEntry.getInputs().addAll(Arrays.stream(input).map(DefaultAuditManager::maskSensitive).map(POJOHelper::serialize).collect(Collectors.toList()));
            }
            Logger logger = LoggerFactory.getLogger((String)AuditLoggerName.getAuditLoggerName((String)AuthContextUtils.getDomain()));
            Logger eventLogger = LoggerFactory.getLogger((String)AuditLoggerName.getAuditEventLoggerName((String)AuthContextUtils.getDomain(), (String)syncopeLogger.getKey()));
            String serializedAuditEntry = POJOHelper.serialize((Object)auditEntry);
            if (throwable == null) {
                logger.debug(serializedAuditEntry);
                eventLogger.debug(serializedAuditEntry);
            } else {
                logger.debug(serializedAuditEntry, throwable);
                eventLogger.debug(serializedAuditEntry, throwable);
            }
        }
    }
}

