/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.AnyObjectPatch;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.GroupPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.RemediationTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.core.logic.AbstractLogic;
import org.apache.syncope.core.logic.AnyObjectLogic;
import org.apache.syncope.core.logic.GroupLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.logic.UserLogic;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RemediationDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.Remediation;
import org.apache.syncope.core.provisioning.api.data.RemediationDataBinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class RemediationLogic
extends AbstractLogic<RemediationTO> {
    @Autowired
    private UserLogic userLogic;
    @Autowired
    private GroupLogic groupLogic;
    @Autowired
    private AnyObjectLogic anyObjectLogic;
    @Autowired
    private RemediationDataBinder binder;
    @Autowired
    private RemediationDAO remediationDAO;

    @PreAuthorize(value="hasRole('REMEDIATION_LIST')")
    @Transactional(readOnly=true)
    public Pair<Integer, List<RemediationTO>> list(int page, int size, List<OrderByClause> orderByClauses) {
        int count = this.remediationDAO.count();
        List result = this.remediationDAO.findAll(page, size, orderByClauses).stream().map(arg_0 -> ((RemediationDataBinder)this.binder).getRemediationTO(arg_0)).collect(Collectors.toList());
        return Pair.of((Object)count, result);
    }

    @PreAuthorize(value="hasRole('REMEDIATION_READ')")
    @Transactional(readOnly=true)
    public RemediationTO read(String key) {
        Remediation remediation = Optional.ofNullable(this.remediationDAO.find(key)).orElseThrow(() -> new NotFoundException(key));
        return this.binder.getRemediationTO(remediation);
    }

    @PreAuthorize(value="hasRole('REMEDIATION_DELETE')")
    @Transactional
    public void delete(String key) {
        Optional.ofNullable(this.remediationDAO.find(key)).orElseThrow(() -> new NotFoundException(key));
        this.remediationDAO.delete(key);
    }

    @PreAuthorize(value="hasRole('REMEDIATION_REMEDY')")
    public ProvisioningResult<?> remedy(String key, AnyTO anyTO, boolean nullPriorityAsync) {
        ProvisioningResult<GroupTO> result;
        switch (this.read(key).getAnyType()) {
            case "USER": {
                result = this.userLogic.create((UserTO)anyTO, true, nullPriorityAsync);
                break;
            }
            case "GROUP": {
                result = this.groupLogic.create((GroupTO)anyTO, nullPriorityAsync);
                break;
            }
            default: {
                result = this.anyObjectLogic.create((AnyObjectTO)anyTO, nullPriorityAsync);
            }
        }
        this.remediationDAO.delete(key);
        return result;
    }

    @PreAuthorize(value="hasRole('REMEDIATION_REMEDY')")
    public ProvisioningResult<?> remedy(String key, AnyPatch anyPatch, boolean nullPriorityAsync) {
        ProvisioningResult<UserTO> result;
        switch (this.read(key).getAnyType()) {
            case "USER": {
                result = this.userLogic.update((UserPatch)anyPatch, nullPriorityAsync);
                break;
            }
            case "GROUP": {
                result = this.groupLogic.update((GroupPatch)anyPatch, nullPriorityAsync);
                break;
            }
            default: {
                result = this.anyObjectLogic.update((AnyObjectPatch)anyPatch, nullPriorityAsync);
            }
        }
        this.remediationDAO.delete(key);
        return result;
    }

    @PreAuthorize(value="hasRole('REMEDIATION_REMEDY')")
    public ProvisioningResult<?> remedy(String key, String anyKey, boolean nullPriorityAsync) {
        ProvisioningResult<UserTO> result;
        switch (this.read(key).getAnyType()) {
            case "USER": {
                result = this.userLogic.delete(anyKey, nullPriorityAsync);
                break;
            }
            case "GROUP": {
                result = this.groupLogic.delete(anyKey, nullPriorityAsync);
                break;
            }
            default: {
                result = this.anyObjectLogic.delete(anyKey, nullPriorityAsync);
            }
        }
        this.remediationDAO.delete(key);
        return result;
    }

    @Override
    protected RemediationTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof RemediationTO)) continue;
                key = ((RemediationTO)args[i]).getKey();
            }
        }
        if (StringUtils.isNotBlank(key)) {
            try {
                return this.binder.getRemediationTO(this.remediationDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

