/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractResourceAssociator;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.provisioning.api.LogicActions;
import org.apache.syncope.core.provisioning.java.utils.TemplateUtils;
import org.apache.syncope.core.spring.ImplementationManager;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractAnyLogic<TO extends AnyTO, P extends AnyPatch>
extends AbstractResourceAssociator<TO> {
    @Autowired
    private RealmDAO realmDAO;
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private TemplateUtils templateUtils;

    private List<LogicActions> getActions(Realm realm) {
        ArrayList<LogicActions> actions = new ArrayList<LogicActions>();
        realm.getActions().forEach(impl -> {
            try {
                actions.add((LogicActions)ImplementationManager.build((Implementation)impl));
            }
            catch (Exception e) {
                LOG.warn("While building {}", impl, (Object)e);
            }
        });
        return actions;
    }

    protected Pair<TO, List<LogicActions>> beforeCreate(TO input) {
        AnyType anyType;
        Realm realm = this.realmDAO.findByFullPath(input.getRealm());
        if (realm == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            sce.getElements().add(input.getRealm());
            throw sce;
        }
        AnyType anyType2 = input instanceof UserTO ? this.anyTypeDAO.findUser() : (anyType = input instanceof GroupTO ? this.anyTypeDAO.findGroup() : this.anyTypeDAO.find(input.getType()));
        if (anyType == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
            sce.getElements().add(input.getType());
            throw sce;
        }
        Object any = input;
        this.templateUtils.apply(any, realm.getTemplate(anyType));
        List<LogicActions> actions = this.getActions(realm);
        for (LogicActions action : actions) {
            any = action.beforeCreate(any);
        }
        LOG.debug("Input: {}\nOutput: {}\n", input, any);
        return Pair.of(any, actions);
    }

    protected Pair<P, List<LogicActions>> beforeUpdate(P input, String realmPath) {
        Realm realm = this.realmDAO.findByFullPath(realmPath);
        if (realm == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            sce.getElements().add(realmPath);
            throw sce;
        }
        Object patch = input;
        List<LogicActions> actions = this.getActions(realm);
        for (LogicActions action : actions) {
            patch = action.beforeUpdate(patch);
        }
        LOG.debug("Input: {}\nOutput: {}\n", input, patch);
        return Pair.of(patch, actions);
    }

    protected Pair<TO, List<LogicActions>> beforeDelete(TO input) {
        Realm realm = this.realmDAO.findByFullPath(input.getRealm());
        if (realm == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            sce.getElements().add(input.getRealm());
            throw sce;
        }
        Object any = input;
        List<LogicActions> actions = this.getActions(realm);
        for (LogicActions action : actions) {
            any = action.beforeDelete(any);
        }
        LOG.debug("Input: {}\nOutput: {}\n", input, any);
        return Pair.of(any, actions);
    }

    protected ProvisioningResult<TO> afterCreate(TO input, List<PropagationStatus> statuses, List<LogicActions> actions) {
        Object any = input;
        for (LogicActions action : actions) {
            any = action.afterCreate(any, statuses);
        }
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity(any);
        result.getPropagationStatuses().addAll(statuses);
        return result;
    }

    protected ProvisioningResult<TO> afterUpdate(TO input, List<PropagationStatus> statuses, List<LogicActions> actions) {
        Object any = input;
        for (LogicActions action : actions) {
            any = action.afterUpdate(any, statuses);
        }
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity(any);
        result.getPropagationStatuses().addAll(statuses);
        return result;
    }

    protected ProvisioningResult<TO> afterDelete(TO input, List<PropagationStatus> statuses, List<LogicActions> actions) {
        Object any = input;
        for (LogicActions action : actions) {
            any = action.afterDelete(any, statuses);
        }
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity(any);
        result.getPropagationStatuses().addAll(statuses);
        return result;
    }

    public abstract TO read(String var1);

    public abstract Pair<Integer, List<TO>> search(SearchCond var1, int var2, int var3, List<OrderByClause> var4, String var5, boolean var6);

    public abstract ProvisioningResult<TO> update(P var1, boolean var2);

    public abstract ProvisioningResult<TO> delete(String var1, boolean var2);
}

