/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.Process;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cmd.StartProcessInstanceCmd;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.runtime.ProcessInstanceBuilderImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.JobUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;

public class StartProcessInstanceAsyncCmd
extends StartProcessInstanceCmd {
    public StartProcessInstanceAsyncCmd(ProcessInstanceBuilderImpl processInstanceBuilder) {
        super(processInstanceBuilder);
    }

    @Override
    public ProcessInstance execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        ProcessDefinition processDefinition = this.getProcessDefinition(processEngineConfiguration, commandContext);
        this.processInstanceHelper = processEngineConfiguration.getProcessInstanceHelper();
        ExecutionEntity processInstance = (ExecutionEntity)this.processInstanceHelper.createProcessInstance(processDefinition, this.businessKey, this.businessStatus, this.processInstanceName, this.overrideDefinitionTenantId, this.predefinedProcessInstanceId, this.variables, this.transientVariables, this.callbackId, this.callbackType, this.referenceId, this.referenceType, this.stageInstanceId, false);
        ExecutionEntity execution = processInstance.getExecutions().get(0);
        Process process = ProcessDefinitionUtil.getProcess(processInstance.getProcessDefinitionId());
        this.processInstanceHelper.processAvailableEventSubProcesses(processInstance, (FlowElementsContainer)process, commandContext);
        FlowableEventDispatcher eventDispatcher = processEngineConfiguration.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createProcessStartedEvent(execution, this.variables, false), processEngineConfiguration.getEngineCfgKey());
        }
        this.executeAsynchronous(execution, process, commandContext);
        return processInstance;
    }

    protected void executeAsynchronous(ExecutionEntity execution, Process process, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        JobService jobService = processEngineConfiguration.getJobServiceConfiguration().getJobService();
        JobEntity job = JobUtil.createJob(execution, (BaseElement)process, "async-continuation", processEngineConfiguration);
        job.setElementName(process.getName());
        jobService.createAsyncJob(job, false);
        jobService.scheduleAsyncJob(job);
    }
}

