/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.RanChangeSet;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.database.Database;

public class InternalHistoryCommandStep
extends AbstractCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"internalHistory"};
    public static final CommandArgumentDefinition<Database> DATABASE_ARG;
    public static final CommandArgumentDefinition<DateFormat> DATE_FORMAT_ARG;
    public static final CommandResultDefinition<DeploymentHistory> DEPLOYMENTS_RESULT;

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setInternal(true);
    }

    @Override
    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        PrintWriter output = new PrintWriter(resultsBuilder.getOutputStream());
        CommandScope commandScope = resultsBuilder.getCommandScope();
        DeploymentHistory deploymentHistory = new DeploymentHistory();
        Database database = commandScope.getArgumentValue(DATABASE_ARG);
        ChangeLogHistoryService historyService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database);
        output.println("Liquibase History for " + database.getConnection().getURL());
        output.println("");
        DeploymentDetails deployment = null;
        for (RanChangeSet ranChangeSet : historyService.getRanChangeSets()) {
            String thisDeploymentId = ranChangeSet.getDeploymentId();
            if (deployment == null || !Objects.equals(thisDeploymentId, deployment.getDeploymentId())) {
                if (deployment != null) {
                    deployment.printReport(output);
                }
                deployment = new DeploymentDetails(commandScope);
                deploymentHistory.deployments.add(deployment);
            }
            deployment.changeSets.add(ranChangeSet);
        }
        if (deployment == null) {
            output.println("No changesets deployed");
        } else {
            deployment.printReport(output);
        }
        resultsBuilder.addResult(DEPLOYMENTS_RESULT, deploymentHistory);
        output.flush();
    }

    static {
        CommandBuilder builder = new CommandBuilder(new String[][]{COMMAND_NAME});
        DATABASE_ARG = builder.argument("database", Database.class).required().build();
        DATE_FORMAT_ARG = builder.argument("dateFormat", DateFormat.class).defaultValue(DateFormat.getDateTimeInstance(3, 3), "Platform specific 'short' format").build();
        DEPLOYMENTS_RESULT = builder.result("deployments", DeploymentHistory.class).build();
    }

    public static class DeploymentDetails {
        private final CommandScope commandScope;
        List<RanChangeSet> changeSets = new ArrayList<RanChangeSet>();

        public DeploymentDetails(CommandScope commandScope) {
            this.commandScope = commandScope;
        }

        void printReport(PrintWriter output) {
            DateFormat dateFormat = this.commandScope.getArgumentValue(DATE_FORMAT_ARG);
            if (dateFormat == null) {
                dateFormat = DateFormat.getDateTimeInstance(3, 3);
            }
            String executionTime = null;
            RanChangeSet firstChangeSet = this.changeSets.get(0);
            if (this.changeSets.size() > 1) {
                RanChangeSet last = this.changeSets.get(this.changeSets.size() - 1);
                long executionMs = last.getDateExecuted().getTime() - firstChangeSet.getDateExecuted().getTime();
                executionTime = (float)executionMs / 1000.0f + "s";
            }
            String message = "- Database updated at " + dateFormat.format(firstChangeSet.getDateExecuted()) + ". Applied " + this.changeSets.size() + " changeset(s)";
            if (executionTime != null) {
                message = message + " in " + executionTime;
            }
            message = message + ", DeploymentId: " + firstChangeSet.getDeploymentId();
            output.println(message);
            for (RanChangeSet changeSet : this.changeSets) {
                output.println("  " + changeSet.toString());
            }
            output.println("");
        }

        String getDeploymentId() {
            if (this.changeSets.size() == 0) {
                return null;
            }
            return this.changeSets.get(0).getDeploymentId();
        }
    }

    public static class DeploymentHistory {
        private List<DeploymentDetails> deployments = new ArrayList<DeploymentDetails>();

        public List<DeploymentDetails> getDeployments() {
            return this.deployments;
        }

        public String toString() {
            return this.deployments.size() + " past deployments";
        }
    }
}

