/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.flowable.support;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.core.flowable.support.DomainProcessEngine;
import org.apache.syncope.core.flowable.support.DropdownFormType;
import org.apache.syncope.core.flowable.support.PasswordFormType;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.cfg.SpringBeanFactoryProxyMap;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.form.AbstractFormType;
import org.flowable.engine.impl.el.ProcessExpressionManager;
import org.flowable.engine.impl.util.EngineServiceUtil;
import org.flowable.idm.spring.SpringIdmEngineConfiguration;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;

@Component
public class DomainProcessEngineFactoryBean
implements FactoryBean<DomainProcessEngine>,
DisposableBean,
ApplicationContextAware {
    private ApplicationContext ctx;
    private DomainProcessEngine engine;

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.ctx = ctx;
    }

    public DomainProcessEngine getObject() throws Exception {
        if (this.engine == null) {
            HashMap<String, ProcessEngine> engines = new HashMap<String, ProcessEngine>();
            this.ctx.getBeansOfType(DataSource.class).forEach((key, dataSource) -> {
                if (!key.startsWith("local")) {
                    String domain = StringUtils.substringBefore((String)key, (String)DataSource.class.getSimpleName());
                    PlatformTransactionManager transactionManager = (PlatformTransactionManager)this.ctx.getBean(domain + "TransactionManager", PlatformTransactionManager.class);
                    Object entityManagerFactory = this.ctx.getBean(domain + "EntityManagerFactory");
                    SpringProcessEngineConfiguration conf = (SpringProcessEngineConfiguration)this.ctx.getBean(SpringProcessEngineConfiguration.class);
                    conf.setDataSource(dataSource);
                    conf.setTransactionManager(transactionManager);
                    conf.setTransactionsExternallyManaged(true);
                    conf.setJpaEntityManagerFactory(entityManagerFactory);
                    if (conf.getBeans() == null) {
                        conf.setBeans((Map)new SpringBeanFactoryProxyMap((BeanFactory)this.ctx));
                    }
                    if (conf.getExpressionManager() == null) {
                        conf.setExpressionManager((ExpressionManager)new ProcessExpressionManager(conf.getBeans()));
                    }
                    if (EngineServiceUtil.getIdmEngineConfiguration((AbstractEngineConfiguration)conf) == null) {
                        SpringIdmEngineConfiguration spiec = (SpringIdmEngineConfiguration)this.ctx.getBean(SpringIdmEngineConfiguration.class);
                        conf.addEngineConfiguration(spiec.getEngineCfgKey(), spiec.getEngineScopeType(), (AbstractEngineConfiguration)spiec);
                    }
                    conf.setEnableSafeBpmnXml(true);
                    conf.setCustomFormTypes(Arrays.asList(new AbstractFormType[]{new DropdownFormType(null), new PasswordFormType()}));
                    conf.setDisableEventRegistry(true);
                    engines.put(domain, conf.buildProcessEngine());
                }
            });
            this.engine = new DomainProcessEngine(engines);
        }
        return this.engine;
    }

    public Class<DomainProcessEngine> getObjectType() {
        return DomainProcessEngine.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        if (this.engine != null) {
            this.engine.close();
        }
    }
}

