/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.slider.util;

import de.agilecoders.wicket.extensions.slider.util.DoubleValue;
import de.agilecoders.wicket.extensions.slider.util.INumericValue;
import de.agilecoders.wicket.extensions.slider.util.IntegerValue;
import de.agilecoders.wicket.extensions.slider.util.LongValue;
import org.apache.wicket.model.IModel;

public class NumericModel<T extends Number>
implements IModel<INumericValue<T>> {
    private final IModel<T> model;

    public NumericModel(IModel<T> model) {
        this.model = model;
    }

    public INumericValue<T> getObject() {
        INumericValue<?> value = NumericModel.getValue(((Number)this.model.getObject()).getClass());
        value.setValue((Number)this.model.getObject());
        return value;
    }

    public void setObject(INumericValue<T> object) {
        this.model.setObject(object.getValue());
    }

    public void detach() {
        this.model.detach();
    }

    public static INumericValue<?> getValue(Class<?> typeClass) {
        if (Double.class.isAssignableFrom(typeClass)) {
            return new DoubleValue();
        }
        if (Long.class.isAssignableFrom(typeClass)) {
            return new LongValue();
        }
        if (Integer.class.isAssignableFrom(typeClass)) {
            return new IntegerValue();
        }
        return new DoubleValue();
    }
}

