/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security.jws;

import java.security.KeyFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jws.HmacJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.PrivateKeyJwsSignatureProvider;
import org.springframework.beans.factory.InitializingBean;

public class AccessTokenJwsSignatureProvider
implements JwsSignatureProvider,
InitializingBean {
    private SignatureAlgorithm jwsAlgorithm;
    private String jwsKey;
    private JwsSignatureProvider delegate;

    public void setJwsAlgorithm(SignatureAlgorithm jwsAlgorithm) {
        this.jwsAlgorithm = jwsAlgorithm;
    }

    public void setJwsKey(String jwsKey) {
        this.jwsKey = jwsKey;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.jwsAlgorithm == null) {
            throw new IllegalArgumentException("An instance of " + SignatureAlgorithm.class + " is required");
        }
        if (SignatureAlgorithm.isPublicKeyAlgorithm((SignatureAlgorithm)this.jwsAlgorithm)) {
            if (!this.jwsAlgorithm.getJwaName().startsWith("RS")) {
                throw new IllegalArgumentException(this.jwsAlgorithm.getJavaName() + " not supported.");
            }
            if (this.jwsKey == null || this.jwsKey.indexOf(58) == -1) {
                throw new IllegalArgumentException("A key pair is required, in the 'private:public' format");
            }
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec keySpecPKCS8 = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(StringUtils.substringBefore((String)this.jwsKey, (String)":").getBytes()));
            this.delegate = new PrivateKeyJwsSignatureProvider(kf.generatePrivate(keySpecPKCS8), this.jwsAlgorithm);
        } else {
            if (this.jwsKey == null) {
                throw new IllegalArgumentException("A shared key is required");
            }
            this.delegate = new HmacJwsSignatureProvider(this.jwsKey.getBytes(), this.jwsAlgorithm);
        }
    }

    public SignatureAlgorithm getAlgorithm() {
        return this.delegate.getAlgorithm();
    }

    public byte[] sign(JwsHeaders headers, byte[] content) {
        return this.delegate.sign(headers, content);
    }

    public JwsSignature createJwsSignature(JwsHeaders headers) {
        return this.delegate.createJwsSignature(headers);
    }
}

