/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.provisioning.api.EntitlementsHolder;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.SyncopeAuthenticationDetails;
import org.apache.syncope.core.spring.security.SyncopeGrantedAuthority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;

public final class AuthContextUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AuthContextUtils.class);
    private static final String UNAUTHENTICATED = "unauthenticated";

    public static String getUsername() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication == null ? UNAUTHENTICATED : authentication.getName();
    }

    public static void updateUsername(String newUsername) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        UsernamePasswordAuthenticationToken newAuth = new UsernamePasswordAuthenticationToken((Object)new User(newUsername, "FAKE_PASSWORD", auth.getAuthorities()), auth.getCredentials(), auth.getAuthorities());
        newAuth.setDetails(auth.getDetails());
        SecurityContextHolder.getContext().setAuthentication((Authentication)newAuth);
    }

    public static Optional<String> getDelegatedBy() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        return auth != null && auth.getDetails() instanceof SyncopeAuthenticationDetails ? Optional.ofNullable(((SyncopeAuthenticationDetails)SyncopeAuthenticationDetails.class.cast(auth.getDetails())).getDelegatedBy()) : Optional.empty();
    }

    public static String getWho() {
        return AuthContextUtils.getUsername() + AuthContextUtils.getDelegatedBy().map(d -> {
            String delegatedBy = AuthContextUtils.execWithAuthContext(AuthContextUtils.getDomain(), () -> ((UserDAO)ApplicationContextProvider.getApplicationContext().getBean(UserDAO.class)).findUsername(d)).orElse(d);
            return " [delegated by " + delegatedBy + "]";
        }).orElse("");
    }

    public static Set<SyncopeGrantedAuthority> getAuthorities() {
        return Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication()).map(authentication -> authentication.getAuthorities().stream().filter(SyncopeGrantedAuthority.class::isInstance).map(SyncopeGrantedAuthority.class::cast).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    public static Map<String, Set<String>> getAuthorizations() {
        return Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication()).map(authentication -> authentication.getAuthorities().stream().filter(SyncopeGrantedAuthority.class::isInstance).map(SyncopeGrantedAuthority.class::cast).collect(Collectors.toMap(SyncopeGrantedAuthority::getAuthority, SyncopeGrantedAuthority::getRealms))).orElse(Collections.emptyMap());
    }

    public static String getDomain() {
        String domainKey;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String string = domainKey = auth != null && auth.getDetails() instanceof SyncopeAuthenticationDetails ? ((SyncopeAuthenticationDetails)SyncopeAuthenticationDetails.class.cast(auth.getDetails())).getDomain() : null;
        if (StringUtils.isBlank(domainKey)) {
            domainKey = "Master";
        }
        return domainKey;
    }

    private static Authentication getFakeAuth(String domain) {
        List authorities = EntitlementsHolder.getInstance().getValues().stream().map(entitlement -> new SyncopeGrantedAuthority((String)entitlement, "/")).collect(Collectors.toList());
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)new User((String)ApplicationContextProvider.getBeanFactory().getBean("adminUser", String.class), "FAKE_PASSWORD", authorities), (Object)"FAKE_PASSWORD", authorities);
        auth.setDetails((Object)new SyncopeAuthenticationDetails(domain, null));
        return auth;
    }

    public static <T> T execWithAuthContext(String domain, Executable<T> executable) {
        Authentication original = SecurityContextHolder.getContext().getAuthentication();
        SecurityContextHolder.getContext().setAuthentication(AuthContextUtils.getFakeAuth(domain));
        try {
            T t = executable.exec();
            return t;
        }
        catch (Throwable t) {
            LOG.debug("Error during execution with domain {} context", (Object)domain, (Object)t);
            throw t;
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(original);
        }
    }

    private AuthContextUtils() {
    }

    public static interface Executable<T> {
        public T exec();
    }
}

