/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.policy;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.policy.DefaultPasswordRuleConf;
import org.apache.syncope.common.lib.policy.PasswordRuleConf;
import org.apache.syncope.core.persistence.api.dao.PasswordRule;
import org.apache.syncope.core.persistence.api.dao.PasswordRuleConfClass;
import org.apache.syncope.core.persistence.api.entity.user.LAPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.api.entity.user.UPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.spring.policy.PasswordPolicyException;
import org.apache.syncope.core.spring.policy.PolicyPattern;
import org.apache.syncope.core.spring.security.Encryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@PasswordRuleConfClass(value=DefaultPasswordRuleConf.class)
public class DefaultPasswordRule
implements PasswordRule {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPasswordRule.class);
    private static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    private DefaultPasswordRuleConf conf;

    public PasswordRuleConf getConf() {
        return this.conf;
    }

    public void setConf(PasswordRuleConf conf) {
        if (!(conf instanceof DefaultPasswordRuleConf)) {
            throw new IllegalArgumentException(DefaultPasswordRuleConf.class.getName() + " expected, got " + conf.getClass().getName());
        }
        this.conf = (DefaultPasswordRuleConf)conf;
    }

    protected void enforce(String clear, String username, Set<String> wordsNotPermitted) {
        if (this.conf.getMinLength() > 0 && this.conf.getMinLength() > clear.length()) {
            throw new PasswordPolicyException("Password too short");
        }
        if (this.conf.getMaxLength() > 0 && this.conf.getMaxLength() < clear.length()) {
            throw new PasswordPolicyException("Password too long");
        }
        if (!this.conf.isUsernameAllowed() && username != null && username.equals(clear)) {
            throw new PasswordPolicyException("Password mustn't be equal to username");
        }
        wordsNotPermitted.stream().filter(word -> StringUtils.containsIgnoreCase((CharSequence)clear, (CharSequence)word)).forEach(item -> {
            throw new PasswordPolicyException("Used word(s) not permitted");
        });
        if (this.conf.isDigitRequired() && !PolicyPattern.DIGIT.matcher(clear).matches()) {
            throw new PasswordPolicyException("Password must contain digit(s)");
        }
        if (this.conf.isLowercaseRequired() && !PolicyPattern.ALPHA_LOWERCASE.matcher(clear).matches()) {
            throw new PasswordPolicyException("Password must contain lowercase alphabetic character(s)");
        }
        if (this.conf.isUppercaseRequired() && !PolicyPattern.ALPHA_UPPERCASE.matcher(clear).matches()) {
            throw new PasswordPolicyException("Password must contain uppercase alphabetic character(s)");
        }
        this.conf.getPrefixesNotPermitted().stream().filter(prefix -> clear.startsWith((String)prefix)).forEach(item -> {
            throw new PasswordPolicyException("Prefix not permitted");
        });
        this.conf.getSuffixesNotPermitted().stream().filter(suffix -> clear.endsWith((String)suffix)).forEach(item -> {
            throw new PasswordPolicyException("Suffix not permitted");
        });
        if (this.conf.isMustStartWithDigit() && !PolicyPattern.FIRST_DIGIT.matcher(clear).matches()) {
            throw new PasswordPolicyException("Password must start with a digit");
        }
        if (this.conf.isMustntStartWithDigit() && PolicyPattern.FIRST_DIGIT.matcher(clear).matches()) {
            throw new PasswordPolicyException("Password mustn't start with a digit");
        }
        if (this.conf.isMustEndWithDigit() && !PolicyPattern.LAST_DIGIT.matcher(clear).matches()) {
            throw new PasswordPolicyException("Password must end with a digit");
        }
        if (this.conf.isMustntEndWithDigit() && PolicyPattern.LAST_DIGIT.matcher(clear).matches()) {
            throw new PasswordPolicyException("Password mustn't end with a digit");
        }
        if (this.conf.isAlphanumericRequired() && !PolicyPattern.ALPHANUMERIC.matcher(clear).matches()) {
            throw new PasswordPolicyException("Password must contain alphanumeric character(s)");
        }
        if (this.conf.isNonAlphanumericRequired() && !PolicyPattern.NON_ALPHANUMERIC.matcher(clear).matches()) {
            throw new PasswordPolicyException("Password must contain non-alphanumeric character(s)");
        }
        if (this.conf.isMustStartWithAlpha() && !PolicyPattern.FIRST_ALPHANUMERIC.matcher(clear).matches()) {
            throw new PasswordPolicyException("Password must start with an alphanumeric character");
        }
        if (this.conf.isMustntStartWithAlpha() && PolicyPattern.FIRST_ALPHANUMERIC.matcher(clear).matches()) {
            throw new PasswordPolicyException("Password mustn't start with an alphanumeric character");
        }
        if (this.conf.isMustEndWithAlpha() && !PolicyPattern.LAST_ALPHANUMERIC.matcher(clear).matches()) {
            throw new PasswordPolicyException("Password must end with an alphanumeric character");
        }
        if (this.conf.isMustntEndWithAlpha() && PolicyPattern.LAST_ALPHANUMERIC.matcher(clear).matches()) {
            throw new PasswordPolicyException("Password mustn't end with an alphanumeric character");
        }
        if (this.conf.isMustStartWithNonAlpha() && !PolicyPattern.FIRST_NON_ALPHANUMERIC.matcher(clear).matches()) {
            throw new PasswordPolicyException("Password must start with a non-alphanumeric character");
        }
        if (this.conf.isMustntStartWithNonAlpha() && PolicyPattern.FIRST_NON_ALPHANUMERIC.matcher(clear).matches()) {
            throw new PasswordPolicyException("Password mustn't start with a non-alphanumeric character");
        }
        if (this.conf.isMustEndWithNonAlpha() && !PolicyPattern.LAST_NON_ALPHANUMERIC.matcher(clear).matches()) {
            throw new PasswordPolicyException("Password must end with a non-alphanumeric character");
        }
        if (this.conf.isMustntEndWithNonAlpha() && PolicyPattern.LAST_NON_ALPHANUMERIC.matcher(clear).matches()) {
            throw new PasswordPolicyException("Password mustn't end with a non-alphanumeric character");
        }
    }

    @Transactional(readOnly=true)
    public void enforce(User user) {
        if (user.getPassword() != null && user.getClearPassword() != null) {
            HashSet<String> wordsNotPermitted = new HashSet<String>(this.conf.getWordsNotPermitted());
            wordsNotPermitted.addAll(this.conf.getSchemasNotPermitted().stream().map(schema -> user.getPlainAttr(schema)).filter(Optional::isPresent).map(attr -> ((UPlainAttr)attr.get()).getValuesAsStrings()).filter(values -> !CollectionUtils.isEmpty((Collection)values)).flatMap(Collection::stream).collect(Collectors.toSet()));
            this.enforce(user.getClearPassword(), user.getUsername(), wordsNotPermitted);
        }
    }

    @Transactional(readOnly=true)
    public void enforce(LinkedAccount account) {
        this.conf.getWordsNotPermitted().addAll(this.conf.getSchemasNotPermitted().stream().map(schema -> account.getPlainAttr(schema)).filter(Optional::isPresent).map(attr -> ((LAPlainAttr)attr.get()).getValuesAsStrings()).filter(values -> !CollectionUtils.isEmpty((Collection)values)).flatMap(Collection::stream).collect(Collectors.toList()));
        if (account.getPassword() != null) {
            String clear = null;
            if (account.canDecodeSecrets()) {
                try {
                    clear = ENCRYPTOR.decode(account.getPassword(), account.getCipherAlgorithm());
                }
                catch (Exception e) {
                    LOG.error("Could not decode password for {}", (Object)account, (Object)e);
                }
            }
            if (clear != null) {
                HashSet<String> wordsNotPermitted = new HashSet<String>(this.conf.getWordsNotPermitted());
                wordsNotPermitted.addAll(this.conf.getSchemasNotPermitted().stream().map(schema -> account.getPlainAttr(schema)).filter(Optional::isPresent).map(attr -> ((LAPlainAttr)attr.get()).getValuesAsStrings()).filter(values -> !CollectionUtils.isEmpty((Collection)values)).flatMap(Collection::stream).collect(Collectors.toSet()));
                this.enforce(clear, account.getUsername(), wordsNotPermitted);
            }
        }
    }
}

