/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring;

import java.io.IOException;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ResourceWithFallbackLoader
implements ResourceLoaderAware,
ResourcePatternResolver {
    private ResourcePatternResolver resolver;
    private String primary;
    private String fallback;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resolver = (ResourcePatternResolver)resourceLoader;
    }

    public void setPrimary(String primary) {
        this.primary = primary;
    }

    public void setFallback(String fallback) {
        this.fallback = fallback;
    }

    public Resource getResource(String location) {
        Resource resource = this.resolver.getResource(this.primary + location);
        if (!resource.exists()) {
            resource = this.resolver.getResource(this.fallback + location);
        }
        return resource;
    }

    public Resource getResource() {
        return this.getResource("");
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        Object[] resources = this.resolver.getResources(this.primary + locationPattern);
        if (ArrayUtils.isEmpty((Object[])resources)) {
            resources = this.resolver.getResources(this.fallback + locationPattern);
        }
        return resources;
    }

    public Resource[] getResources() throws IOException {
        return this.getResources("");
    }

    public ClassLoader getClassLoader() {
        return this.resolver.getClassLoader();
    }
}

