/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.serialization;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import org.apache.syncope.core.provisioning.api.serialization.AttributeDeserializer;
import org.apache.syncope.core.provisioning.api.serialization.AttributeSerializer;
import org.apache.syncope.core.provisioning.api.serialization.GuardedStringDeserializer;
import org.apache.syncope.core.provisioning.api.serialization.GuardedStringSerializer;
import org.apache.syncope.core.provisioning.api.serialization.SyncTokenDeserializer;
import org.apache.syncope.core.provisioning.api.serialization.SyncTokenSerializer;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class POJOHelper {
    private static final Logger LOG = LoggerFactory.getLogger(POJOHelper.class);
    private static final ObjectMapper MAPPER;

    public static String serialize(Object object) {
        String result = null;
        try {
            result = MAPPER.writeValueAsString(object);
        }
        catch (Exception e) {
            LOG.error("During serialization", (Throwable)e);
        }
        return result;
    }

    public static <T> T deserialize(String serialized, Class<T> reference) {
        Object result = null;
        try {
            result = MAPPER.readValue(serialized, reference);
        }
        catch (Exception e) {
            LOG.error("During deserialization", (Throwable)e);
        }
        return (T)result;
    }

    public static <T> T deserialize(String serialized, TypeReference<T> reference) {
        Object result = null;
        try {
            result = MAPPER.readValue(serialized, reference);
        }
        catch (Exception e) {
            LOG.error("During deserialization", (Throwable)e);
        }
        return (T)result;
    }

    private POJOHelper() {
    }

    static {
        SimpleModule pojoModule = new SimpleModule("POJOModule", new Version(1, 0, 0, null, null, null));
        pojoModule.addSerializer(GuardedString.class, (JsonSerializer)new GuardedStringSerializer());
        pojoModule.addSerializer(Attribute.class, (JsonSerializer)new AttributeSerializer());
        pojoModule.addSerializer(SyncToken.class, (JsonSerializer)new SyncTokenSerializer());
        pojoModule.addDeserializer(GuardedString.class, (JsonDeserializer)new GuardedStringDeserializer());
        pojoModule.addDeserializer(Attribute.class, (JsonDeserializer)new AttributeDeserializer());
        pojoModule.addDeserializer(SyncToken.class, (JsonDeserializer)new SyncTokenDeserializer());
        MAPPER = new ObjectMapper();
        MAPPER.registerModule((Module)pojoModule);
        MAPPER.registerModule((Module)new AfterburnerModule());
    }
}

