/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.policies;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.panels.WizardModalPanel;
import org.apache.syncope.client.console.rest.PolicyRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxSpinnerFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wizards.AbstractModalPanelBuilder;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.common.lib.policy.AccountPolicyTO;
import org.apache.syncope.common.lib.policy.PasswordPolicyTO;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.policy.PropagationPolicyTO;
import org.apache.syncope.common.lib.policy.ProvisioningPolicyTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.types.BackOffStrategy;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;

public class PolicyModalPanelBuilder<T extends PolicyTO>
extends AbstractModalPanelBuilder<T> {
    private static final long serialVersionUID = 5945391813567245081L;
    private final BaseModal<T> modal;
    private final PolicyType type;
    private final PolicyRestClient restClient = new PolicyRestClient();

    public PolicyModalPanelBuilder(PolicyType type, T policyTO, BaseModal<T> modal, PageReference pageRef) {
        super(policyTO, pageRef);
        this.type = type;
        this.modal = modal;
    }

    @Override
    public WizardModalPanel<T> build(String id, int index, AjaxWizard.Mode mode) {
        return new Profile(this, (PolicyTO)this.newModelObject(), this.modal, this.pageRef);
    }

    public static class Profile
    extends AbstractModalPanel<T> {
        private static final long serialVersionUID = -3043839139187792810L;
        private final T policyTO;
        private final LoadableDetachableModel<List<String>> resources;
        final /* synthetic */ PolicyModalPanelBuilder this$0;

        public Profile(T policyTO, BaseModal<T> modal, PageReference pageRef) {
            this.this$0 = this$0;
            super(modal, pageRef);
            this.resources = new LoadableDetachableModel<List<String>>(){
                private static final long serialVersionUID = 5275935387613157437L;

                protected List<String> load() {
                    return new ResourceRestClient().list().stream().map(EntityTO::getKey).collect(Collectors.toList());
                }
            };
            modal.setFormModel(policyTO);
            this.policyTO = policyTO;
            ArrayList fields = new ArrayList();
            AjaxTextFieldPanel description = new AjaxTextFieldPanel("field", "description", (IModel<String>)new PropertyModel(policyTO, "description"), false);
            description.setRequired(true);
            fields.add(description);
            if (policyTO instanceof AccountPolicyTO) {
                fields.add(new AjaxSpinnerFieldPanel.Builder<Integer>().build("field", "maxAuthenticationAttempts", Integer.class, (IModel<Integer>)new PropertyModel(policyTO, "maxAuthenticationAttempts")));
                fields.add(new AjaxCheckBoxPanel("field", "propagateSuspension", (IModel<Boolean>)new PropertyModel(policyTO, "propagateSuspension"), false));
                fields.add(new AjaxPalettePanel.Builder().setName("passthroughResources").build("field", new PropertyModel(policyTO, "passthroughResources"), new ListModel((List)this.resources.getObject())));
            } else if (policyTO instanceof PasswordPolicyTO) {
                fields.add(new AjaxSpinnerFieldPanel.Builder<Integer>().build("field", "historyLength", Integer.class, (IModel<Integer>)new PropertyModel(policyTO, "historyLength")));
                fields.add(new AjaxCheckBoxPanel("field", "allowNullPassword", (IModel<Boolean>)new PropertyModel(policyTO, "allowNullPassword"), false));
            } else if (policyTO instanceof PropagationPolicyTO) {
                fields.add(new AjaxSpinnerFieldPanel.Builder<Integer>().build("field", "maxAttempts", Integer.class, (IModel<Integer>)new PropertyModel(policyTO, "maxAttempts")));
                final AjaxDropDownChoicePanel<Serializable> backOffStrategy = new AjaxDropDownChoicePanel<Serializable>("field", "backOffStrategy", (IModel<Serializable>)new PropertyModel(policyTO, "backOffStrategy")).setChoices(Arrays.asList((Serializable[])BackOffStrategy.values()));
                fields.add(backOffStrategy);
                final PropertyModel backOffParamsModel = new PropertyModel(policyTO, "backOffParams");
                final AjaxSpinnerFieldPanel<Long> initialInterval = new AjaxSpinnerFieldPanel.Builder<Long>().min(1L).build("field", "initialInterval", Long.class, new BackOffParamsModel((PropertyModel<String>)backOffParamsModel, 0));
                fields.add(initialInterval.setOutputMarkupPlaceholderTag(true));
                final AjaxSpinnerFieldPanel<Long> maxInterval = new AjaxSpinnerFieldPanel.Builder<Long>().min(1L).build("field", "maxInterval", Long.class, new BackOffParamsModel((PropertyModel<String>)backOffParamsModel, 1));
                fields.add(maxInterval.setOutputMarkupPlaceholderTag(true).setVisible(false));
                final AjaxSpinnerFieldPanel<Double> multiplier = new AjaxSpinnerFieldPanel.Builder<Double>().min(1.0).build("field", "multiplier", Double.class, new BackOffParamsModel((PropertyModel<String>)backOffParamsModel, 2));
                fields.add(multiplier.setOutputMarkupPlaceholderTag(true).setVisible(false));
                this.showHide(backOffStrategy, initialInterval, maxInterval, multiplier);
                backOffStrategy.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                    private static final long serialVersionUID = -1107858522700306810L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        BackOffStrategy strategy = (BackOffStrategy)backOffStrategy.getField().getModelObject();
                        backOffParamsModel.setObject((Object)strategy.getDefaultBackOffParams());
                        Profile.this.showHide(backOffStrategy, initialInterval, maxInterval, multiplier);
                        target.add(new Component[]{initialInterval});
                        target.add(new Component[]{maxInterval});
                        target.add(new Component[]{multiplier});
                    }
                }});
            } else if (policyTO instanceof ProvisioningPolicyTO) {
                fields.add(new AjaxDropDownChoicePanel<Serializable>("field", "conflictResolutionAction", (IModel<Serializable>)new PropertyModel(policyTO, "conflictResolutionAction")).setChoices(Arrays.asList((Serializable[])ConflictResolutionAction.values())));
            }
            this.add(new Component[]{new ListView<Component>("fields", fields){
                private static final long serialVersionUID = -9180479401817023838L;

                protected void populateItem(ListItem<Component> item) {
                    item.add(new Component[]{(Component)item.getModelObject()});
                }
            }});
        }

        private void showHide(AjaxDropDownChoicePanel<Serializable> backOffStrategy, AjaxSpinnerFieldPanel<Long> initialInterval, AjaxSpinnerFieldPanel<Long> maxInterval, AjaxSpinnerFieldPanel<Double> multiplier) {
            BackOffStrategy strategy = (BackOffStrategy)backOffStrategy.getField().getModelObject();
            switch (strategy) {
                case EXPONENTIAL: {
                    initialInterval.addLabel("initialInterval");
                    maxInterval.setVisible(true);
                    multiplier.setVisible(true);
                    break;
                }
                case RANDOM: {
                    initialInterval.addLabel("initialInterval");
                    maxInterval.setVisible(true);
                    multiplier.setVisible(true);
                    break;
                }
                default: {
                    initialInterval.addLabel("period");
                    maxInterval.setVisible(false);
                    multiplier.setVisible(false);
                }
            }
        }

        @Override
        public void onSubmit(AjaxRequestTarget target) {
            try {
                if (this.policyTO.getKey() == null) {
                    this.this$0.restClient.createPolicy(this.this$0.type, this.policyTO);
                } else {
                    this.this$0.restClient.updatePolicy(this.this$0.type, this.policyTO);
                }
                SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                this.modal.close((IPartialPageRequestHandler)target);
            }
            catch (Exception e) {
                LOG.error("While creating/updating policy", (Throwable)e);
                SyncopeConsoleSession.get().onException(e);
            }
            ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        }
    }

    private static class BackOffParamsModel<N extends Number>
    implements IModel<N> {
        private static final long serialVersionUID = 28839546672164L;
        private final PropertyModel<String> backOffParamsModel;
        private final int index;

        BackOffParamsModel(PropertyModel<String> backOffParamsModel, int index) {
            this.backOffParamsModel = backOffParamsModel;
            this.index = index;
        }

        public N getObject() {
            String[] split = ((String)this.backOffParamsModel.getObject()).split(";");
            if (this.index >= split.length) {
                return null;
            }
            return (N)(this.index == 2 ? (Number)Double.valueOf(((String)this.backOffParamsModel.getObject()).split(";")[this.index]) : (Number)Long.valueOf(((String)this.backOffParamsModel.getObject()).split(";")[this.index]));
        }

        public void setObject(N object) {
            String[] split = ((String)this.backOffParamsModel.getObject()).split(";");
            if (this.index < split.length) {
                split[this.index] = object.toString();
                this.backOffParamsModel.setObject((Object)Arrays.stream(split).collect(Collectors.joining(";")));
            }
        }
    }
}

