/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ParametersCreateModalPanel;
import org.apache.syncope.client.console.panels.ParametersEditModalPanel;
import org.apache.syncope.client.console.panels.WizardModalPanel;
import org.apache.syncope.client.console.rest.ConfRestClient;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.AbstractModalPanelBuilder;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class ParametersDirectoryPanel
extends DirectoryPanel<AttrTO, AttrTO, ParametersProvider, ConfRestClient> {
    private static final long serialVersionUID = 2765863608539154422L;
    private final SchemaRestClient schemaRestClient = new SchemaRestClient();
    private final BaseModal<AttrTO> modalDetails = new BaseModal<AttrTO>("modalDetails"){
        private static final long serialVersionUID = 389935548143327858L;

        protected void onConfigure() {
            super.onConfigure();
            this.setFooterVisible(true);
        }
    };

    public ParametersDirectoryPanel(String id, PageReference pageRef) {
        super(id, new DirectoryPanel.Builder<AttrTO, AttrTO, ConfRestClient>(new ConfRestClient(), pageRef){
            private static final long serialVersionUID = 8769126634538601689L;

            @Override
            protected WizardMgtPanel<AttrTO> newInstance(String id, boolean wizardInModal) {
                throw new UnsupportedOperationException();
            }
        });
        this.itemKeyFieldName = "schema";
        this.disableCheckBoxes();
        this.modalDetails.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                ParametersDirectoryPanel.this.modalDetails.show(false);
                target.add(new Component[]{ParametersDirectoryPanel.this.container});
            }
        });
        this.modalDetails.size(Modal.Size.Medium);
        this.addInnerObject(new Component[]{this.modalDetails});
        this.addNewItemPanelBuilder(new AbstractModalPanelBuilder<AttrTO>(new AttrTO(), pageRef){
            private static final long serialVersionUID = 1995192603527154740L;

            @Override
            public WizardModalPanel<AttrTO> build(String id, int index, AjaxWizard.Mode mode) {
                return new ParametersCreateModalPanel(ParametersDirectoryPanel.this.modal, (AttrTO)this.newModelObject(), this.pageRef);
            }
        }, true);
        this.modal.size(Modal.Size.Medium);
        this.initResultTable();
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"CONFIGURATION_SET");
    }

    public ParametersDirectoryPanel(String id, DirectoryPanel.Builder<AttrTO, AttrTO, ConfRestClient> builder) {
        super(id, builder);
    }

    @Override
    protected ParametersProvider dataProvider() {
        return new ParametersProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "parameters.paginator.rows";
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return Collections.singletonList(ActionLink.ActionType.DELETE);
    }

    @Override
    protected List<IColumn<AttrTO, String>> getColumns() {
        ArrayList<IColumn<AttrTO, String>> columns = new ArrayList<IColumn<AttrTO, String>>();
        columns.add((IColumn<AttrTO, String>)new PropertyColumn((IModel)new ResourceModel("schema"), "schema"));
        columns.add((IColumn<AttrTO, String>)new PropertyColumn<AttrTO, String>((IModel)new ResourceModel("values"), "values"){
            private static final long serialVersionUID = -1822504503325964706L;

            public void populateItem(Item<ICellPopulator<AttrTO>> item, String componentId, IModel<AttrTO> rowModel) {
                AttrSchemaType type;
                PlainSchemaTO schema = null;
                try {
                    schema = (PlainSchemaTO)ParametersDirectoryPanel.this.schemaRestClient.read(SchemaType.PLAIN, ((AttrTO)rowModel.getObject()).getSchema());
                }
                catch (Exception e) {
                    DirectoryPanel.LOG.error("Could not read conf schema {}", (Object)((AttrTO)rowModel.getObject()).getSchema(), (Object)e);
                }
                AttrSchemaType attrSchemaType = type = schema == null ? null : schema.getType();
                if (type == AttrSchemaType.Binary || type == AttrSchemaType.Encrypted) {
                    item.add(new Component[]{new Label(componentId, (Serializable)((Object)type.name())).add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)"font-style:italic"))})});
                } else {
                    super.populateItem(item, componentId, rowModel);
                }
            }
        });
        return columns;
    }

    @Override
    public ActionsPanel<AttrTO> getActions(final IModel<AttrTO> model) {
        ActionsPanel<AttrTO> panel = super.getActions(model);
        panel.add(new ActionLink<AttrTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, AttrTO ignore) {
                target.add(new Component[]{ParametersDirectoryPanel.this.modalDetails});
                ParametersDirectoryPanel.this.modalDetails.addSubmitButton();
                ParametersDirectoryPanel.this.modalDetails.header((IModel)new StringResourceModel("any.edit"));
                ParametersDirectoryPanel.this.modalDetails.setContent(new ParametersEditModalPanel(ParametersDirectoryPanel.this.modalDetails, (AttrTO)model.getObject(), ParametersDirectoryPanel.this.pageRef));
                ParametersDirectoryPanel.this.modalDetails.show(true);
            }
        }, ActionLink.ActionType.EDIT, "CONFIGURATION_SET");
        panel.add(new ActionLink<AttrTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, AttrTO ignore) {
                try {
                    ((ConfRestClient)ParametersDirectoryPanel.this.restClient).delete(((AttrTO)model.getObject()).getSchema());
                    ParametersDirectoryPanel.this.schemaRestClient.deletePlainSchema(((AttrTO)model.getObject()).getSchema());
                    SyncopeConsoleSession.get().success((Serializable)((Object)ParametersDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{ParametersDirectoryPanel.this.container});
                }
                catch (Exception e) {
                    DirectoryPanel.LOG.error("While deleting {}", model.getObject(), (Object)e);
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BasePage)ParametersDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "CONFIGURATION_DELETE", true);
        return panel;
    }

    protected final class ParametersProvider
    extends DirectoryDataProvider<AttrTO> {
        private static final long serialVersionUID = -185944053385660794L;
        private final SortableDataProviderComparator<AttrTO> comparator;

        private ParametersProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("schema", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<AttrTO>(this);
        }

        public Iterator<AttrTO> iterator(long first, long count) {
            List<AttrTO> list = ((ConfRestClient)ParametersDirectoryPanel.this.restClient).list();
            Collections.sort(list, this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((ConfRestClient)ParametersDirectoryPanel.this.restClient).list().size();
        }

        public IModel<AttrTO> model(AttrTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

