/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.RestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.console.wizards.resources.ConnectorWizardBuilder;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

public class ConnidLocations
extends DirectoryPanel<Serializable, Serializable, ConnidLocationsDataProvider, RestClient> {
    public ConnidLocations(String id, Builder builder) {
        super(id, builder);
        this.disableCheckBoxes();
        this.setShowResultPage(true);
        this.modal.size(Modal.Size.Large);
        this.initResultTable();
    }

    @Override
    protected ConnidLocationsDataProvider dataProvider() {
        return new ConnidLocationsDataProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "dynRealm.paginator.rows";
    }

    @Override
    protected List<IColumn<Serializable, String>> getColumns() {
        ArrayList<IColumn<Serializable, String>> columns = new ArrayList<IColumn<Serializable, String>>();
        columns.add((IColumn<Serializable, String>)new AbstractColumn<Serializable, String>((IModel)new ResourceModel("key"), "key"){

            public void populateItem(Item cellItem, String componentId, IModel rowModel) {
                cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)rowModel.getObject().toString()))});
            }
        });
        return columns;
    }

    @Override
    public ActionsPanel<Serializable> getActions(IModel<Serializable> model) {
        ActionsPanel<Serializable> panel = super.getActions(model);
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = 293293495682202660L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                ConnInstanceTO modelObject = new ConnInstanceTO();
                modelObject.setLocation((String)((Object)ignore));
                CompoundPropertyModel model = new CompoundPropertyModel((Object)modelObject);
                ConnidLocations.this.modal.setFormModel(model);
                target.add(new Component[]{ConnidLocations.this.modal.setContent(new ConnectorWizardBuilder(modelObject, ConnidLocations.this.pageRef).build("content", AjaxWizard.Mode.CREATE))});
                ConnidLocations.this.modal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(ConnidLocations.this.getString("connector.new"), (String)((Object)ignore)))));
                ConnidLocations.this.modal.show(true);
            }
        }, ActionLink.ActionType.CREATE, String.format("%s", "CONNECTOR_CREATE"));
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return Collections.emptyList();
    }

    protected class ConnidLocationsDataProvider
    extends DirectoryDataProvider<Serializable> {
        private static final long serialVersionUID = 3161906945317209169L;

        public ConnidLocationsDataProvider(int paginatorRows) {
            super(paginatorRows);
        }

        public Iterator<String> iterator(long first, long count) {
            ArrayList result = new ArrayList(SyncopeConsoleSession.get().getPlatformInfo().getConnIdLocations());
            return result.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return SyncopeConsoleSession.get().getPlatformInfo().getConnIdLocations().size();
        }

        public IModel<Serializable> model(Serializable object) {
            return new CompoundPropertyModel((Object)object);
        }
    }

    public static abstract class Builder
    extends DirectoryPanel.Builder<Serializable, Serializable, RestClient> {
        private static final long serialVersionUID = 4448348557808690524L;

        public Builder(PageReference pageRef) {
            super(null, pageRef);
        }

        @Override
        protected WizardMgtPanel<Serializable> newInstance(String id, boolean wizardInModal) {
            return new ConnidLocations(id, this);
        }
    }
}

