/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.tabs.Collapsible;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.commons.RealmsUtils;
import org.apache.syncope.client.console.layout.AbstractAnyFormLayout;
import org.apache.syncope.client.console.layout.AnyLayout;
import org.apache.syncope.client.console.layout.AnyLayoutUtils;
import org.apache.syncope.client.console.panels.AnyObjectDirectoryPanel;
import org.apache.syncope.client.console.panels.GroupDirectoryPanel;
import org.apache.syncope.client.console.panels.LabelPanel;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.panels.UserDirectoryPanel;
import org.apache.syncope.client.console.panels.search.AbstractSearchPanel;
import org.apache.syncope.client.console.panels.search.AnyObjectSearchPanel;
import org.apache.syncope.client.console.panels.search.GroupSearchPanel;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.SearchClausePanel;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.console.panels.search.UserSearchPanel;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLinksTogglePanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.search.AnyObjectCompleteCondition;
import org.apache.syncope.common.lib.search.GroupCompleteCondition;
import org.apache.syncope.common.lib.search.UserCompleteCondition;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyEntitlement;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyPanel
extends Panel
implements ModalPanel {
    private static final long serialVersionUID = -1100228004207271270L;
    protected static final Logger LOG = LoggerFactory.getLogger(AnyPanel.class);
    protected static final String DIRECTORY_PANEL_ID = "searchResult";
    protected static DirectoryPanelSupplier DEFAULT_DIRECTORYPANEL_SUPPLIER = (id, anyTypeTO, realmTO, anyLayout, pageRef) -> {
        WizardMgtPanel panel;
        String dynRealm;
        String realm;
        AnyTypeClassRestClient anyTypeClassRestClient = new AnyTypeClassRestClient();
        if (StringUtils.startsWith((CharSequence)realmTO.getFullPath(), (CharSequence)"/")) {
            realm = RealmsUtils.getFullPath(realmTO.getFullPath());
            dynRealm = null;
        } else {
            realm = "/";
            dynRealm = realmTO.getKey();
        }
        switch (anyTypeTO.getKind()) {
            case USER: {
                String fiql = dynRealm == null ? ((UserCompleteCondition)SyncopeClient.getUserSearchConditionBuilder().is("key").notNullValue()).query() : ((UserCompleteCondition)SyncopeClient.getUserSearchConditionBuilder().inDynRealms(dynRealm, new String[0])).query();
                UserTO userTO = new UserTO();
                userTO.setRealm(RealmsUtils.getFullPath(realmTO.getFullPath()));
                panel = new UserDirectoryPanel.Builder(anyTypeClassRestClient.list(anyTypeTO.getClasses()), anyTypeTO.getKey(), pageRef).setRealm(realm).setDynRealm(dynRealm).setFiltered(true).setFiql(fiql).setWizardInModal(true).addNewItemPanelBuilder(AnyLayoutUtils.newLayoutInfo(userTO, anyTypeTO.getClasses(), anyLayout.getUser(), pageRef)).build(id);
                MetaDataRoleAuthorizationStrategy.authorize(panel, (Action)WebPage.RENDER, (String)"USER_SEARCH");
                break;
            }
            case GROUP: {
                String fiql = dynRealm == null ? ((GroupCompleteCondition)SyncopeClient.getGroupSearchConditionBuilder().is("key").notNullValue()).query() : ((GroupCompleteCondition)SyncopeClient.getGroupSearchConditionBuilder().inDynRealms(dynRealm, new String[0])).query();
                GroupTO groupTO = new GroupTO();
                groupTO.setRealm(RealmsUtils.getFullPath(realmTO.getFullPath()));
                panel = new GroupDirectoryPanel.Builder(anyTypeClassRestClient.list(anyTypeTO.getClasses()), anyTypeTO.getKey(), pageRef).setRealm(realm).setDynRealm(dynRealm).setFiltered(true).setFiql(fiql).setWizardInModal(true).addNewItemPanelBuilder(AnyLayoutUtils.newLayoutInfo(groupTO, anyTypeTO.getClasses(), anyLayout.getGroup(), pageRef)).build(id);
                break;
            }
            case ANY_OBJECT: {
                String fiql = dynRealm == null ? ((AnyObjectCompleteCondition)SyncopeClient.getAnyObjectSearchConditionBuilder((String)anyTypeTO.getKey()).is("key").notNullValue()).query() : ((AnyObjectCompleteCondition)SyncopeClient.getAnyObjectSearchConditionBuilder((String)anyTypeTO.getKey()).inDynRealms(dynRealm, new String[0])).query();
                AnyObjectTO anyObjectTO = new AnyObjectTO();
                anyObjectTO.setRealm(RealmsUtils.getFullPath(realmTO.getFullPath()));
                anyObjectTO.setType(anyTypeTO.getKey());
                panel = new AnyObjectDirectoryPanel.Builder(anyTypeClassRestClient.list(anyTypeTO.getClasses()), anyTypeTO.getKey(), pageRef).setRealm(realm).setDynRealm(dynRealm).setFiltered(true).setFiql(fiql).setWizardInModal(true).addNewItemPanelBuilder(AnyLayoutUtils.newLayoutInfo(anyObjectTO, anyTypeTO.getClasses(), (AbstractAnyFormLayout)anyLayout.getAnyObjects().get(anyTypeTO.getKey()), pageRef)).build(id);
                MetaDataRoleAuthorizationStrategy.authorize(panel, (Action)WebPage.RENDER, (String)AnyEntitlement.SEARCH.getFor(anyTypeTO.getKey()));
                break;
            }
            default: {
                panel = new LabelPanel(id, null);
            }
        }
        return panel;
    };
    protected final AnyTypeTO anyTypeTO;
    protected final RealmTO realmTO;
    protected final PageReference pageRef;
    protected AbstractSearchPanel searchPanel;
    protected final Panel directoryPanel;

    public AnyPanel(String id, AnyTypeTO anyTypeTO, RealmTO realmTO, AnyLayout anyLayout, boolean enableSearch, PageReference pageRef) {
        this(id, anyTypeTO, realmTO, anyLayout, enableSearch, DEFAULT_DIRECTORYPANEL_SUPPLIER, pageRef);
    }

    public AnyPanel(String id, AnyTypeTO anyTypeTO, RealmTO realmTO, AnyLayout anyLayout, boolean enableSearch, DirectoryPanelSupplier directoryPanelSupplier, PageReference pageRef) {
        super(id);
        this.anyTypeTO = anyTypeTO;
        this.realmTO = realmTO;
        this.pageRef = pageRef;
        final Model model = Model.of((Serializable)Integer.valueOf(-1));
        Accordion accordion = new Accordion("accordionPanel", Collections.singletonList(new AbstractTab((IModel)new ResourceModel("search.result")){
            protected static final long serialVersionUID = 1037272333056449377L;

            public WebMarkupContainer getPanel(String panelId) {
                AnyPanel.this.searchPanel = AnyPanel.this.getSearchPanel(panelId);
                return AnyPanel.this.searchPanel;
            }
        }), (IModel)model){
            protected static final long serialVersionUID = -3056452800492734900L;

            protected Component newTitle(String markupId, ITab tab, Collapsible.State state) {
                return new AjaxLink<Integer>(markupId){
                    protected static final long serialVersionUID = 6250423506463465679L;

                    protected void onComponentTag(ComponentTag tag) {
                        super.onComponentTag(tag);
                        tag.put("style", (CharSequence)"color: #337ab7");
                    }

                    public void onClick(AjaxRequestTarget target) {
                        model.setObject((Serializable)Integer.valueOf((Integer)model.getObject() == 0 ? -1 : 0));
                    }
                }.setBody(tab.getTitle()).setEscapeModelStrings(false);
            }
        };
        accordion.setOutputMarkupId(true);
        this.add(new Component[]{accordion.setEnabled(enableSearch).setVisible(enableSearch)});
        this.directoryPanel = this.createDirectoryPanel(anyTypeTO, realmTO, anyLayout, enableSearch, directoryPanelSupplier);
        this.add(new Component[]{this.directoryPanel});
    }

    protected Panel createDirectoryPanel(AnyTypeTO anyTypeTO, RealmTO realmTO, AnyLayout anyLayout, boolean enableSearch, DirectoryPanelSupplier directoryPanelSupplier) {
        return directoryPanelSupplier.supply(DIRECTORY_PANEL_ID, anyTypeTO, realmTO, anyLayout, this.pageRef);
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof SearchClausePanel.SearchEvent) {
            AjaxRequestTarget target = ((SearchClausePanel.SearchEvent)SearchClausePanel.SearchEvent.class.cast(event.getPayload())).getTarget();
            this.send((IEventSink)this.directoryPanel, Broadcast.BREADTH, new ActionLinksTogglePanel.ActionLinkToggleCloseEventPayload(target));
            String precond = this.realmTO.getFullPath().startsWith("/") ? "" : String.format("$dynRealms=~%s;", this.realmTO.getKey());
            switch (this.anyTypeTO.getKind()) {
                case USER: {
                    ((UserDirectoryPanel)((Object)UserDirectoryPanel.class.cast(this.directoryPanel))).search(precond + SearchUtils.buildFIQL((List)this.searchPanel.getModel().getObject(), SyncopeClient.getUserSearchConditionBuilder(), this.searchPanel.getAvailableSchemaTypes(), SearchUtils.NO_CUSTOM_CONDITION), target);
                    break;
                }
                case GROUP: {
                    ((GroupDirectoryPanel)((Object)GroupDirectoryPanel.class.cast(this.directoryPanel))).search(precond + SearchUtils.buildFIQL((List)this.searchPanel.getModel().getObject(), SyncopeClient.getGroupSearchConditionBuilder(), this.searchPanel.getAvailableSchemaTypes(), SearchUtils.NO_CUSTOM_CONDITION), target);
                    break;
                }
                case ANY_OBJECT: {
                    ((AnyObjectDirectoryPanel)((Object)AnyObjectDirectoryPanel.class.cast(this.directoryPanel))).search(precond + SearchUtils.buildFIQL((List)this.searchPanel.getModel().getObject(), SyncopeClient.getAnyObjectSearchConditionBuilder((String)this.anyTypeTO.getKey()), this.searchPanel.getAvailableSchemaTypes(), SearchUtils.NO_CUSTOM_CONDITION), target);
                    break;
                }
            }
        } else {
            super.onEvent(event);
        }
    }

    protected AbstractSearchPanel getSearchPanel(String id) {
        AbstractSearchPanel panel;
        ArrayList<SearchClause> clauses = new ArrayList<SearchClause>();
        SearchClause clause = new SearchClause();
        clauses.add(clause);
        switch (this.anyTypeTO.getKind()) {
            case USER: {
                clause.setComparator(SearchClause.Comparator.EQUALS);
                clause.setType(SearchClause.Type.ATTRIBUTE);
                clause.setProperty("username");
                panel = (AbstractSearchPanel)((Object)new UserSearchPanel.Builder((IModel<List<SearchClause>>)new ListModel(clauses)).required(true).enableSearch().build(id));
                break;
            }
            case GROUP: {
                clause.setComparator(SearchClause.Comparator.EQUALS);
                clause.setType(SearchClause.Type.ATTRIBUTE);
                clause.setProperty("name");
                panel = (AbstractSearchPanel)((Object)new GroupSearchPanel.Builder((IModel<List<SearchClause>>)new ListModel(clauses)).required(true).enableSearch().build(id));
                break;
            }
            case ANY_OBJECT: {
                clause.setComparator(SearchClause.Comparator.EQUALS);
                clause.setType(SearchClause.Type.ATTRIBUTE);
                clause.setProperty("name");
                panel = (AbstractSearchPanel)((Object)new AnyObjectSearchPanel.Builder(this.anyTypeTO.getKey(), (IModel<List<SearchClause>>)new ListModel(clauses)).required(true).enableSearch().build(id));
                break;
            }
            default: {
                panel = null;
            }
        }
        return panel;
    }

    @FunctionalInterface
    public static interface DirectoryPanelSupplier {
        public Panel supply(String var1, AnyTypeTO var2, RealmTO var3, AnyLayout var4, PageReference var5);
    }
}

