/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.AnyDataProvider;
import org.apache.syncope.client.console.commons.status.ConnObjectWrapper;
import org.apache.syncope.client.console.commons.status.StatusBean;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.DisplayAttributesModalPanel;
import org.apache.syncope.client.console.rest.AbstractAnyRestClient;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.console.wicket.ajax.form.AjaxDownloadBehavior;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.AttrColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.BooleanPropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.TokenColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.CSVPullWizardBuilder;
import org.apache.syncope.client.console.wizards.CSVPushWizardBuilder;
import org.apache.syncope.client.console.wizards.any.AnyWrapper;
import org.apache.syncope.client.console.wizards.any.ProvisioningReportsPanel;
import org.apache.syncope.client.console.wizards.any.ResultPage;
import org.apache.syncope.client.console.wizards.any.StatusPanel;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.common.rest.api.beans.AnyQuery;
import org.apache.syncope.common.rest.api.beans.CSVPullSpec;
import org.apache.syncope.common.rest.api.beans.CSVPushSpec;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.springframework.util.ReflectionUtils;

public abstract class AnyDirectoryPanel<A extends AnyTO, E extends AbstractAnyRestClient<A>>
extends DirectoryPanel<A, AnyWrapper<A>, AnyDataProvider<A>, E> {
    private static final long serialVersionUID = -1100228004207271270L;
    protected final SchemaRestClient schemaRestClient = new SchemaRestClient();
    protected final List<String> pSchemaNames;
    protected final List<String> dSchemaNames;
    protected String fiql;
    protected final String realm;
    protected final String type;
    protected final BaseModal<Serializable> utilityModal = new BaseModal("outer");
    protected final AjaxLink<Void> csvPushLink;
    protected final AjaxLink<Void> csvPullLink;

    protected AnyDirectoryPanel(String id, Builder<A, E> builder) {
        this(id, builder, true);
    }

    protected AnyDirectoryPanel(String id, Builder<A, E> builder, boolean wizardInModal) {
        super(id, builder, wizardInModal);
        if (SyncopeConsoleSession.get().owns(String.format("%s_CREATE", builder.type), builder.realm) && builder.realm.startsWith("/")) {
            MetaDataRoleAuthorizationStrategy.authorizeAll((Component)this.addAjaxLink, (Action)RENDER);
        } else {
            MetaDataRoleAuthorizationStrategy.unauthorizeAll((Component)this.addAjaxLink, (Action)RENDER);
        }
        if (builder.dynRealm == null) {
            this.setReadOnly(!SyncopeConsoleSession.get().owns(String.format("%s_UPDATE", builder.type), builder.realm));
        } else {
            this.setReadOnly(!SyncopeConsoleSession.get().owns(String.format("%s_UPDATE", builder.type), builder.dynRealm));
        }
        this.realm = builder.realm;
        this.type = builder.type;
        this.fiql = builder.fiql;
        this.utilityModal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.utilityModal});
        this.setWindowClosedReloadCallback(this.utilityModal);
        this.modal.size(Modal.Size.Large);
        this.altDefaultModal.size(Modal.Size.Large);
        this.pSchemaNames = ((AnyDirectoryPanelBuilder)AnyDirectoryPanelBuilder.class.cast(builder)).getAnyTypeClassTOs().stream().flatMap(anyTypeClassTO -> anyTypeClassTO.getPlainSchemas().stream()).collect(Collectors.toList());
        this.dSchemaNames = ((AnyDirectoryPanelBuilder)AnyDirectoryPanelBuilder.class.cast(builder)).getAnyTypeClassTOs().stream().flatMap(anyTypeClassTO -> anyTypeClassTO.getDerSchemas().stream()).collect(Collectors.toList());
        this.initResultTable();
        final AjaxDownloadBehavior csvDownloadBehavior = new AjaxDownloadBehavior();
        final WebMarkupContainer csvEventSink = new WebMarkupContainer("outer"){
            private static final long serialVersionUID = -957948639666058749L;

            public void onEvent(IEvent<?> event) {
                if (event.getPayload() instanceof AjaxWizard.NewItemCancelEvent) {
                    ((AjaxWizard.NewItemCancelEvent)event.getPayload()).getTarget().ifPresent(arg_0 -> ((BaseModal)AnyDirectoryPanel.this.modal).close(arg_0));
                } else if (event.getPayload() instanceof AjaxWizard.NewItemFinishEvent) {
                    AjaxWizard.NewItemFinishEvent payload = (AjaxWizard.NewItemFinishEvent)event.getPayload();
                    Optional<AjaxRequestTarget> target = payload.getTarget();
                    if (payload.getResult() instanceof ArrayList) {
                        AnyDirectoryPanel.this.modal.setContent(new ResultPage<Serializable>(null, payload.getResult()){
                            private static final long serialVersionUID = -2630573849050255233L;

                            @Override
                            protected void closeAction(AjaxRequestTarget target) {
                                AnyDirectoryPanel.this.modal.close((IPartialPageRequestHandler)target);
                            }

                            @Override
                            protected Panel customResultBody(String id, Serializable item, Serializable result) {
                                ArrayList reports = (ArrayList)result;
                                return new ProvisioningReportsPanel(id, reports, AnyDirectoryPanel.this.pageRef);
                            }
                        });
                        target.ifPresent(t -> t.add(new Component[]{AnyDirectoryPanel.this.modal.getForm()}));
                        SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                    } else if ("operation_succeeded".equals(payload.getResult())) {
                        target.ifPresent(arg_0 -> ((BaseModal)AnyDirectoryPanel.this.modal).close(arg_0));
                        SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                    } else if (payload.getResult() instanceof Exception) {
                        SyncopeConsoleSession.get().onException((Exception)payload.getResult());
                    } else {
                        SyncopeConsoleSession.get().error(payload.getResult());
                    }
                    if (target.isPresent()) {
                        ((BasePage)AnyDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target.get());
                        target.get().add(new Component[]{AnyDirectoryPanel.this.container});
                    }
                }
            }
        };
        csvEventSink.add(new Behavior[]{csvDownloadBehavior});
        this.addOuterObject(new Component[]{csvEventSink});
        this.csvPushLink = new AjaxLink<Void>("csvPush"){
            private static final long serialVersionUID = -817438685948164787L;

            public void onClick(AjaxRequestTarget target) {
                CSVPushSpec spec = AnyDirectoryPanel.this.csvPushSpec();
                AnyQuery query = AnyDirectoryPanel.this.csvAnyQuery();
                target.add(new Component[]{AnyDirectoryPanel.this.modal.setContent(new CSVPushWizardBuilder(spec, query, csvDownloadBehavior, AnyDirectoryPanel.this.pageRef).setEventSink((IEventSink)csvEventSink).setAsync(false).build("content", AjaxWizard.Mode.EDIT))});
                AnyDirectoryPanel.this.modal.header((IModel)new StringResourceModel("csvPush", (Component)AnyDirectoryPanel.this, (IModel)Model.of((Serializable)spec)));
                AnyDirectoryPanel.this.modal.show(true);
            }
        };
        this.csvPushLink.setOutputMarkupPlaceholderTag(true).setVisible(wizardInModal).setEnabled(wizardInModal);
        MetaDataRoleAuthorizationStrategy.authorize(this.csvPushLink, (Action)RENDER, (String)String.format("%s,%s", "IMPLEMENTATION_LIST", "TASK_EXECUTE"));
        this.addInnerObject(this.csvPushLink.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true));
        this.csvPullLink = new AjaxLink<Void>("csvPull"){
            private static final long serialVersionUID = -817438685948164787L;

            public void onClick(AjaxRequestTarget target) {
                CSVPullSpec spec = AnyDirectoryPanel.this.csvPullSpec();
                target.add(new Component[]{AnyDirectoryPanel.this.modal.setContent(new CSVPullWizardBuilder(spec, AnyDirectoryPanel.this.pageRef).setEventSink((IEventSink)csvEventSink).build("content", AjaxWizard.Mode.EDIT))});
                AnyDirectoryPanel.this.modal.header((IModel)new StringResourceModel("csvPull", (Component)AnyDirectoryPanel.this, (IModel)Model.of((Serializable)spec)));
                AnyDirectoryPanel.this.modal.show(true);
            }
        };
        this.csvPullLink.setOutputMarkupPlaceholderTag(true).setVisible(wizardInModal).setEnabled(wizardInModal);
        MetaDataRoleAuthorizationStrategy.authorize(this.csvPullLink, (Action)RENDER, (String)String.format("%s,%s", "IMPLEMENTATION_LIST", "TASK_EXECUTE"));
        this.addInnerObject(this.csvPullLink.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true));
    }

    protected CSVPushSpec csvPushSpec() {
        CSVPushSpec spec = (CSVPushSpec)new CSVPushSpec.Builder(this.type).build();
        spec.setFields(this.prefMan.getList(this.getRequest(), DisplayAttributesModalPanel.getPrefDetailView(this.type)).stream().filter(name -> !"key".equalsIgnoreCase((String)name)).collect(Collectors.toList()));
        spec.setPlainAttrs(this.prefMan.getList(this.getRequest(), DisplayAttributesModalPanel.getPrefPlainAttributeView(this.type)).stream().filter(name -> this.pSchemaNames.contains(name)).collect(Collectors.toList()));
        spec.setDerAttrs(this.prefMan.getList(this.getRequest(), DisplayAttributesModalPanel.getPrefPlainAttributeView(this.type)).stream().filter(name -> this.dSchemaNames.contains(name)).collect(Collectors.toList()));
        return spec;
    }

    protected CSVPullSpec csvPullSpec() {
        CSVPullSpec spec = new CSVPullSpec();
        spec.setAnyTypeKey(this.type);
        spec.setDestinationRealm(this.realm);
        return spec;
    }

    protected AnyQuery csvAnyQuery() {
        return (AnyQuery)((AnyQuery.Builder)((AnyQuery.Builder)((AnyQuery.Builder)new AnyQuery.Builder().realm(this.realm).fiql(this.fiql).page(Integer.valueOf(((AnyDataProvider)this.dataProvider).getCurrentPage() + 1))).size(Integer.valueOf(this.rows))).orderBy(BaseRestClient.toOrderBy((SortParam<String>)((AnyDataProvider)this.dataProvider).getSort()))).build();
    }

    @Override
    protected List<IColumn<A, String>> getColumns() {
        ArrayList<IColumn<A, String>> columns = new ArrayList<IColumn<A, String>>();
        columns.add((IColumn<A, String>)new KeyPropertyColumn((IModel<String>)new ResourceModel("key", "key"), "key"));
        ArrayList prefcolumns = new ArrayList();
        this.prefMan.getList(this.getRequest(), DisplayAttributesModalPanel.getPrefDetailView(this.type)).stream().filter(name -> !"key".equalsIgnoreCase((String)name)).forEach(name -> this.addPropertyColumn((String)name, ReflectionUtils.findField(DisplayAttributesModalPanel.getTOClass(this.type), (String)name), prefcolumns));
        this.prefMan.getList(this.getRequest(), DisplayAttributesModalPanel.getPrefPlainAttributeView(this.type)).stream().filter(name -> this.pSchemaNames.contains(name)).forEach(name -> prefcolumns.add((IColumn)new AttrColumn((String)name, SchemaType.PLAIN)));
        this.prefMan.getList(this.getRequest(), DisplayAttributesModalPanel.getPrefDerivedAttributeView(this.type)).stream().filter(name -> this.dSchemaNames.contains(name)).forEach(name -> prefcolumns.add((IColumn)new AttrColumn((String)name, SchemaType.DERIVED)));
        if (prefcolumns.isEmpty()) {
            for (String name2 : this.getDefaultAttributeSelection()) {
                this.addPropertyColumn(name2, ReflectionUtils.findField(DisplayAttributesModalPanel.getTOClass(this.type), (String)name2), prefcolumns);
            }
            this.prefMan.setList(this.getRequest(), this.getResponse(), DisplayAttributesModalPanel.getPrefDetailView(this.type), Arrays.asList(this.getDefaultAttributeSelection()));
        }
        columns.addAll(prefcolumns);
        return columns;
    }

    protected abstract String[] getDefaultAttributeSelection();

    protected void addPropertyColumn(String name, Field field, List<IColumn<A, String>> columns) {
        if ("key".equalsIgnoreCase(name)) {
            columns.add((IColumn<A, String>)new KeyPropertyColumn((IModel<String>)new ResourceModel(name, name), name, name));
        } else if ("token".equalsIgnoreCase(name)) {
            columns.add((IColumn<A, String>)new TokenColumn((IModel<String>)new ResourceModel(name, name), name));
        } else if (field != null && !field.isSynthetic() && (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE))) {
            columns.add((IColumn<A, String>)new BooleanPropertyColumn((IModel<String>)new ResourceModel(name, name), name, name));
        } else if (field != null && !field.isSynthetic() && field.getType().equals(Date.class)) {
            columns.add((IColumn<A, String>)new DatePropertyColumn((IModel<String>)new ResourceModel(name, name), name, name));
        } else {
            columns.add((IColumn<A, String>)new PropertyColumn((IModel)new ResourceModel(name, name), (Object)name, name));
        }
    }

    @Override
    protected AnyDataProvider<A> dataProvider() {
        return new AnyDataProvider((AbstractAnyRestClient)this.restClient, this.rows, this.filtered, this.realm, this.type, this.pageRef).setFIQL(this.fiql);
    }

    public void search(String fiql, AjaxRequestTarget target) {
        this.fiql = fiql;
        ((AnyDataProvider)this.dataProvider).setFIQL(fiql);
        super.search(target);
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        ArrayList<ActionLink.ActionType> batches = new ArrayList<ActionLink.ActionType>();
        batches.add(ActionLink.ActionType.DELETE);
        return batches;
    }

    @Override
    protected Panel customResultBody(String panelId, AnyWrapper<A> item, Serializable result) {
        if (!(result instanceof ProvisioningResult)) {
            throw new IllegalStateException("Unsupported result type");
        }
        return new StatusPanel(panelId, (AnyTO)((ProvisioningResult)result).getEntity(), (IModel<List<StatusBean>>)new ListModel(new ArrayList()), ((ProvisioningResult)result).getPropagationStatuses().stream().map(status -> {
            ConnObjectTO before = status.getBeforeObj();
            ConnObjectWrapper afterObjWrapper = new ConnObjectWrapper((AnyTO)((ProvisioningResult)result).getEntity(), status.getResource(), status.getAfterObj());
            return Triple.of((Object)before, (Object)afterObjWrapper, (Object)status.getFailureReason());
        }).collect(Collectors.toList()), this.pageRef);
    }

    public static abstract class Builder<A extends AnyTO, E extends AbstractAnyRestClient<A>>
    extends DirectoryPanel.Builder<A, AnyWrapper<A>, E>
    implements AnyDirectoryPanelBuilder {
        private static final long serialVersionUID = -6828423611982275640L;
        protected String realm = "/";
        protected String dynRealm = null;
        protected final String type;
        private final List<AnyTypeClassTO> anyTypeClassTOs;

        public Builder(List<AnyTypeClassTO> anyTypeClassTOs, E restClient, String type, PageReference pageRef) {
            super(restClient, pageRef);
            this.anyTypeClassTOs = anyTypeClassTOs;
            this.type = type;
        }

        public Builder<A, E> setRealm(String realm) {
            this.realm = realm;
            return this;
        }

        public Builder<A, E> setDynRealm(String dynRealm) {
            this.dynRealm = dynRealm;
            return this;
        }

        @Override
        public List<AnyTypeClassTO> getAnyTypeClassTOs() {
            return this.anyTypeClassTOs;
        }
    }

    public static interface AnyDirectoryPanelBuilder
    extends Serializable {
        public List<AnyTypeClassTO> getAnyTypeClassTOs();
    }
}

