/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.schema;

import java.util.List;
import org.apache.syncope.client.cli.SyncopeServices;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.common.rest.api.beans.SchemaQuery;
import org.apache.syncope.common.rest.api.service.SchemaService;

public class SchemaSyncopeOperations {
    private final SchemaService schemaService = SyncopeServices.get(SchemaService.class);

    public <T extends SchemaTO> T read(String schemaTypeString, String schemaName) {
        return (T)this.schemaService.read(SchemaType.valueOf((String)schemaTypeString), schemaName);
    }

    public <T extends SchemaTO> List<T> list(String schemaTypeString) {
        return this.schemaService.search(new SchemaQuery.Builder().type(SchemaType.valueOf((String)schemaTypeString)).build());
    }

    public <T extends SchemaTO> List<T> listPlain() {
        return this.schemaService.search(new SchemaQuery.Builder().type(SchemaType.PLAIN).build());
    }

    public <T extends SchemaTO> List<T> listDerived() {
        return this.schemaService.search(new SchemaQuery.Builder().type(SchemaType.DERIVED).build());
    }

    public <T extends SchemaTO> List<T> listVirtual() {
        return this.schemaService.search(new SchemaQuery.Builder().type(SchemaType.VIRTUAL).build());
    }

    public void delete(String schemaTypeString, String schemaName) {
        this.schemaService.delete(SchemaType.valueOf((String)schemaTypeString), schemaName);
    }
}

