/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.entitlement;

import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.entitlement.AbstractEntitlementCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitlementSearchByRole
extends AbstractEntitlementCommand {
    private static final Logger LOG = LoggerFactory.getLogger(EntitlementSearchByRole.class);
    private static final String READ_HELP_MESSAGE = "entitlement --search-by-role {ROLE-KEY}";
    private final Input input;

    public EntitlementSearchByRole(Input input) {
        this.input = input;
    }

    public void search() {
        block6: {
            if (this.input.getParameters().length == 1) {
                try {
                    this.entitlementResultManager.toView(this.entitlementSyncopeOperations.entitlementsPerRole(this.input.firstParameter()));
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error searching entitlement", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.entitlementResultManager.notFoundError("User", this.input.firstParameter());
                        break block6;
                    }
                    this.entitlementResultManager.genericError(ex.getMessage());
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error searching entitlement", (Throwable)ex);
                    this.entitlementResultManager.numberFormatException("user", this.input.firstParameter());
                }
            } else {
                this.entitlementResultManager.commandOptionError(READ_HELP_MESSAGE);
            }
        }
    }
}

