/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ad;

import com.sun.jndi.ldap.ctl.PasswordExpiredResponseControl;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import net.tirasa.adsddl.ntsd.controls.SDFlagsControl;
import net.tirasa.connid.bundles.ad.ADConfiguration;
import net.tirasa.connid.bundles.ad.schema.ADSchema;
import net.tirasa.connid.bundles.ad.util.TrustAllSocketFactory;
import net.tirasa.connid.bundles.ldap.LdapConfiguration;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import net.tirasa.connid.bundles.ldap.commons.LdapUtil;
import org.identityconnectors.common.Pair;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConnectorException;

public class ADConnection
extends LdapConnection {
    private static final Log LOG = Log.getLog(ADConnection.class);
    private static final String LDAP_CTX_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String LDAP_CTX_SOCKET_FACTORY = "java.naming.ldap.factory.socket";
    private static final String LDAP_BINARY_ATTRIBUTE = "java.naming.ldap.attributes.binary";
    private LdapContext initCtx = null;
    private LdapContext syncCtx = null;
    private final ADSchema schema;
    private final ADConfiguration config;

    public ADConnection(ADConfiguration config) {
        super((LdapConfiguration)config);
        this.config = config;
        this.schema = new ADSchema(this);
    }

    public LdapConnection.AuthenticationResult authenticate(String entryDN, GuardedString password) {
        assert (entryDN != null);
        if (LOG.isOk()) {
            LOG.ok("Attempting to authenticate {0}", new Object[]{entryDN});
        }
        Pair<LdapConnection.AuthenticationResult, LdapContext> pair = this.createContext(entryDN, password);
        if (pair.second != null) {
            ADConnection.quietClose((LdapContext)pair.second);
        }
        if (LOG.isOk()) {
            LOG.ok("Authentication result: {0}", new Object[]{pair.first});
        }
        return (LdapConnection.AuthenticationResult)pair.first;
    }

    public ADSchema getADSchema() {
        return this.schema;
    }

    public LdapContext getSyncContext(Control[] control) {
        return this.cloneContext(control);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            super.close();
            ADConnection.quietClose(this.initCtx);
            ADConnection.quietClose(this.syncCtx);
        }
        finally {
            this.initCtx = null;
            this.syncCtx = null;
        }
    }

    private LdapContext cloneContext(Control[] control) {
        InitialLdapContext ctx = null;
        try {
            Hashtable env = new Hashtable(this.getInitialContext().getEnvironment());
            ctx = new InitialLdapContext(env, null);
            ctx.setRequestControls(control);
        }
        catch (NamingException e) {
            LOG.error((Throwable)e, "Context initialization failed", new Object[0]);
        }
        return ctx;
    }

    private static void quietClose(LdapContext ctx) {
        try {
            if (ctx != null) {
                ctx.close();
            }
        }
        catch (NamingException e) {
            LOG.warn((Throwable)e, "Failure closing context", new Object[0]);
        }
    }

    public LdapContext getInitialContext() {
        if (this.initCtx != null) {
            return this.initCtx;
        }
        this.initCtx = this.connect(this.config.getPrincipal(), this.config.getCredentials());
        try {
            this.initCtx.setRequestControls(new Control[]{new SDFlagsControl(4)});
        }
        catch (NamingException e) {
            LOG.error((Throwable)e, "Error initializing request controls", new Object[0]);
        }
        return this.initCtx;
    }

    private LdapContext connect(String principal, GuardedString credentials) {
        Pair<LdapConnection.AuthenticationResult, LdapContext> pair = this.createContext(principal, credentials);
        if (LOG.isOk()) {
            LOG.ok("Authentication result {0}", new Object[]{((LdapConnection.AuthenticationResult)pair.first).getType()});
        }
        if (((LdapConnection.AuthenticationResult)pair.first).getType().equals((Object)LdapConnection.AuthenticationResultType.SUCCESS)) {
            return (LdapContext)pair.second;
        }
        ((LdapConnection.AuthenticationResult)pair.first).propagate();
        throw new IllegalStateException("Should never get here");
    }

    private Pair<LdapConnection.AuthenticationResult, LdapContext> createContext(String principal, GuardedString credentials) {
        ArrayList<Pair<LdapConnection.AuthenticationResult, LdapContext>> result = new ArrayList<Pair<LdapConnection.AuthenticationResult, LdapContext>>(1);
        final Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", LDAP_CTX_FACTORY);
        env.put("java.naming.provider.url", this.getLdapUrls());
        env.put("java.naming.referral", "follow");
        if (this.config.isSsl()) {
            env.put("java.naming.security.protocol", "ssl");
            if (this.config.isTrustAllCerts()) {
                env.put(LDAP_CTX_SOCKET_FACTORY, TrustAllSocketFactory.class.getName());
            }
        }
        env.put(LDAP_BINARY_ATTRIBUTE, "ntSecurityDescriptor objectGUID objectSID");
        String authentication = StringUtil.isNotBlank((String)principal) ? "simple" : "none";
        env.put("java.naming.security.authentication", authentication);
        if (LOG.isOk()) {
            LOG.ok("Initial context environment: {0}", new Object[]{env});
        }
        if (StringUtil.isNotBlank((String)principal)) {
            env.put("java.naming.security.principal", principal);
            if (credentials != null) {
                credentials.access(new GuardedString.Accessor(){

                    public void access(char[] clearChars) {
                        env.put("java.naming.security.credentials", new String(clearChars));
                    }
                });
            }
        }
        result.add(this.createContext(env));
        return (Pair)result.get(0);
    }

    private Pair<LdapConnection.AuthenticationResult, LdapContext> createContext(Hashtable<?, ?> env) {
        LdapConnection.AuthenticationResult authnResult = null;
        InitialLdapContext context = null;
        try {
            context = new InitialLdapContext(env, null);
            if (this.config.isRespectResourcePasswordPolicyChangeAfterReset() && ADConnection.hasPasswordExpiredControl(context.getResponseControls())) {
                authnResult = new LdapConnection.AuthenticationResult(LdapConnection.AuthenticationResultType.PASSWORD_EXPIRED);
            }
        }
        catch (AuthenticationException e) {
            String message = e.getMessage().toLowerCase();
            authnResult = message.contains("password expired") ? new LdapConnection.AuthenticationResult(LdapConnection.AuthenticationResultType.PASSWORD_EXPIRED, (Exception)e) : (message.contains("password has expired") ? new LdapConnection.AuthenticationResult(LdapConnection.AuthenticationResultType.PASSWORD_EXPIRED, (Exception)e) : new LdapConnection.AuthenticationResult(LdapConnection.AuthenticationResultType.FAILED, (Exception)e));
        }
        catch (NamingException e) {
            authnResult = new LdapConnection.AuthenticationResult(LdapConnection.AuthenticationResultType.FAILED, (Exception)e);
        }
        if (authnResult == null) {
            assert (context != null);
            authnResult = new LdapConnection.AuthenticationResult(LdapConnection.AuthenticationResultType.SUCCESS);
        }
        return new Pair((Object)authnResult, (Object)context);
    }

    private static boolean hasPasswordExpiredControl(Control[] controls) {
        if (controls != null) {
            for (Control control : controls) {
                if (!(control instanceof PasswordExpiredResponseControl)) continue;
                return true;
            }
        }
        return false;
    }

    private String getLdapUrls() {
        StringBuilder builder = new StringBuilder();
        builder.append("ldap://").append(this.config.getHost()).append(':').append(this.config.getPort());
        for (String failover : LdapUtil.nullAsEmpty((String[])this.config.getFailover())) {
            builder.append(' ');
            builder.append(failover);
        }
        return builder.toString();
    }

    public void test() {
        this.checkAlive();
    }

    public void checkAlive() {
        try {
            Attributes attrs = this.getInitialContext().getAttributes("", new String[]{"subschemaSubentry"});
            attrs.get("subschemaSubentry");
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }
}

