/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel.exps;

import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.exps.Args;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.apache.openjpa.kernel.exps.FilterListener;
import org.apache.openjpa.kernel.exps.Val;

class Extension
extends Val {
    private static final long serialVersionUID = 1L;
    private final FilterListener _listener;
    private final Val _target;
    private final Val _arg;

    public Extension(FilterListener listener, Val target, Val arg) {
        this._listener = listener;
        this._target = target;
        this._arg = arg;
    }

    @Override
    public Class getType() {
        Class targetClass = this._target == null ? null : this._target.getType();
        return this._listener.getType(targetClass, this.getArgTypes());
    }

    @Override
    public void setImplicitType(Class type) {
    }

    @Override
    protected Object eval(Object candidate, Object orig, StoreContext ctx, Object[] params) {
        Object target = null;
        Class targetClass = null;
        if (this._target != null) {
            target = this._target.eval(candidate, orig, ctx, params);
            targetClass = this._target.getType();
        }
        Object arg = null;
        if (this._arg != null) {
            arg = this._arg.eval(candidate, orig, ctx, params);
        }
        return this._listener.evaluate(target, targetClass, this.getArgs(arg), this.getArgTypes(), candidate, ctx);
    }

    private Class[] getArgTypes() {
        if (this._arg == null) {
            return null;
        }
        if (this._arg instanceof Args) {
            return ((Args)this._arg).getTypes();
        }
        return new Class[]{this._arg.getType()};
    }

    private Object[] getArgs(Object arg) {
        if (arg == null) {
            return null;
        }
        if (this._arg instanceof Args) {
            return (Object[])arg;
        }
        return new Object[]{arg};
    }

    @Override
    public void acceptVisit(ExpressionVisitor visitor) {
        visitor.enter(this);
        if (this._target != null) {
            this._target.acceptVisit(visitor);
        }
        if (this._arg != null) {
            this._arg.acceptVisit(visitor);
        }
        visitor.exit(this);
    }
}

