/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.client.console.panels.OIDCProvidersDirectoryPanel;
import org.apache.syncope.client.console.rest.OIDCProviderRestClient;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wizards.AjaxWizardBuilder;
import org.apache.syncope.client.console.wizards.OIDCProviderMappingPanel;
import org.apache.syncope.client.console.wizards.resources.ItemTransformersTogglePanel;
import org.apache.syncope.client.console.wizards.resources.JEXLTransformersTogglePanel;
import org.apache.syncope.common.lib.to.OIDCProviderTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.UrlValidator;

public class OIDCProviderWizardBuilder
extends AjaxWizardBuilder<OIDCProviderTO> {
    private static final long serialVersionUID = -3310772400714122768L;
    private final OIDCProviderRestClient restClient = new OIDCProviderRestClient();
    private final OIDCProvidersDirectoryPanel directoryPanel;
    private final IModel<List<String>> actionsClasses = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return new ArrayList<String>(OIDCProviderWizardBuilder.this.restClient.getActionsClasses());
        }
    };

    public OIDCProviderWizardBuilder(OIDCProvidersDirectoryPanel directoryPanel, OIDCProviderTO defaultItem, PageReference pageRef) {
        super((Serializable)defaultItem, pageRef);
        this.directoryPanel = directoryPanel;
    }

    protected Serializable onApplyInternal(OIDCProviderTO modelObject) {
        if (modelObject.getKey() == null) {
            if (modelObject.getHasDiscovery()) {
                this.restClient.createFromDiscovery(modelObject);
            } else {
                this.restClient.create(modelObject);
            }
        } else {
            this.restClient.update(modelObject);
        }
        return modelObject;
    }

    protected WizardModel buildModelSteps(OIDCProviderTO modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new OP(modelObject));
        if (modelObject.getKey() == null) {
            wizardModel.add((IWizardStep)new OPContinue(modelObject));
        } else {
            wizardModel.add((IWizardStep)new OPContinue(modelObject, true));
        }
        Mapping mapping = new Mapping(modelObject);
        mapping.setOutputMarkupId(true);
        ItemTransformersTogglePanel mapItemTransformers = new ItemTransformersTogglePanel((WebMarkupContainer)mapping, this.pageRef);
        this.addOuterObject(new Component[]{mapItemTransformers});
        JEXLTransformersTogglePanel jexlTransformers = new JEXLTransformersTogglePanel((WebMarkupContainer)mapping, this.pageRef);
        this.addOuterObject(new Component[]{jexlTransformers});
        mapping.add(new Component[]{new OIDCProviderMappingPanel("mapping", modelObject, mapItemTransformers, jexlTransformers)});
        wizardModel.add((IWizardStep)mapping);
        return wizardModel;
    }

    private void showHide(AjaxCheckBoxPanel hasDiscovery, WebMarkupContainer visibleParams) {
        if (hasDiscovery.getField().getValue().equals("false")) {
            visibleParams.setVisible(true);
        } else {
            visibleParams.setVisible(false);
        }
    }

    private static final class Mapping
    extends WizardStep {
        private static final long serialVersionUID = 3454904947720856253L;

        Mapping(OIDCProviderTO item) {
            this.setTitleModel((IModel)Model.of((Serializable)((Object)"Mapping")));
            this.setSummaryModel((IModel)Model.of((Serializable)((Object)"")));
        }
    }

    public class OPContinue
    extends WizardStep {
        private static final long serialVersionUID = -7087008312629522790L;

        public OPContinue(OIDCProviderTO opTO) {
            WebMarkupContainer content = new WebMarkupContainer("content");
            this.setOutputMarkupId(true);
            content.setOutputMarkupId(true);
            this.add(new Component[]{content});
            UrlValidator urlValidator = new UrlValidator();
            AjaxTextFieldPanel issuer = new AjaxTextFieldPanel("issuer", "issuer", (IModel)new PropertyModel((Object)opTO, "issuer"));
            issuer.addValidator((IValidator)urlValidator);
            issuer.addRequiredLabel();
            content.add(new Component[]{issuer});
            final AjaxCheckBoxPanel hasDiscovery = new AjaxCheckBoxPanel("hasDiscovery", "hasDiscovery", (IModel)new PropertyModel((Object)opTO, "hasDiscovery"));
            content.add(new Component[]{hasDiscovery});
            AjaxTextFieldPanel authorizationEndpoint = new AjaxTextFieldPanel("authorizationEndpoint", "authorizationEndpoint", (IModel)new PropertyModel((Object)opTO, "authorizationEndpoint"));
            authorizationEndpoint.addRequiredLabel();
            authorizationEndpoint.addValidator((IValidator)urlValidator);
            content.add(new Component[]{authorizationEndpoint});
            AjaxTextFieldPanel userinfoEndpoint = new AjaxTextFieldPanel("userinfoEndpoint", "userinfoEndpoint", (IModel)new PropertyModel((Object)opTO, "userinfoEndpoint"));
            userinfoEndpoint.addValidator((IValidator)urlValidator);
            content.add(new Component[]{userinfoEndpoint});
            AjaxTextFieldPanel tokenEndpoint = new AjaxTextFieldPanel("tokenEndpoint", "tokenEndpoint", (IModel)new PropertyModel((Object)opTO, "tokenEndpoint"));
            tokenEndpoint.addRequiredLabel();
            tokenEndpoint.addValidator((IValidator)urlValidator);
            content.add(new Component[]{tokenEndpoint});
            AjaxTextFieldPanel jwksUri = new AjaxTextFieldPanel("jwksUri", "jwksUri", (IModel)new PropertyModel((Object)opTO, "jwksUri"));
            jwksUri.addRequiredLabel();
            jwksUri.addValidator((IValidator)urlValidator);
            content.add(new Component[]{jwksUri});
            AjaxTextFieldPanel endSessionEndpoint = new AjaxTextFieldPanel("endSessionEndpoint", "endSessionEndpoint", (IModel)new PropertyModel((Object)opTO, "endSessionEndpoint"));
            endSessionEndpoint.addValidator((IValidator)urlValidator);
            content.add(new Component[]{endSessionEndpoint});
            final WebMarkupContainer visibleParam = new WebMarkupContainer("visibleParams");
            visibleParam.setOutputMarkupPlaceholderTag(true);
            visibleParam.add(new Component[]{authorizationEndpoint});
            visibleParam.add(new Component[]{userinfoEndpoint});
            visibleParam.add(new Component[]{tokenEndpoint});
            visibleParam.add(new Component[]{jwksUri});
            visibleParam.add(new Component[]{endSessionEndpoint});
            content.add(new Component[]{visibleParam});
            OIDCProviderWizardBuilder.this.showHide(hasDiscovery, visibleParam);
            hasDiscovery.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    OIDCProviderWizardBuilder.this.showHide(hasDiscovery, visibleParam);
                    target.add(new Component[]{visibleParam});
                }
            }});
        }

        public OPContinue(OIDCProviderTO opTO, boolean readOnly) {
            WebMarkupContainer content = new WebMarkupContainer("content");
            this.setOutputMarkupId(true);
            content.setOutputMarkupId(true);
            this.add(new Component[]{content});
            AjaxTextFieldPanel issuer = new AjaxTextFieldPanel("issuer", "issuer", (IModel)new PropertyModel((Object)opTO, "issuer"));
            issuer.setReadOnly(readOnly);
            content.add(new Component[]{issuer});
            AjaxCheckBoxPanel hasDiscovery = new AjaxCheckBoxPanel("hasDiscovery", "hasDiscovery", (IModel)new PropertyModel((Object)opTO, "hasDiscovery"));
            hasDiscovery.setReadOnly(readOnly);
            content.add(new Component[]{hasDiscovery});
            AjaxTextFieldPanel authorizationEndpoint = new AjaxTextFieldPanel("authorizationEndpoint", "authorizationEndpoint", (IModel)new PropertyModel((Object)opTO, "authorizationEndpoint"));
            authorizationEndpoint.setReadOnly(readOnly);
            content.add(new Component[]{authorizationEndpoint});
            AjaxTextFieldPanel userinfoEndpoint = new AjaxTextFieldPanel("userinfoEndpoint", "userinfoEndpoint", (IModel)new PropertyModel((Object)opTO, "userinfoEndpoint"));
            userinfoEndpoint.setReadOnly(readOnly);
            content.add(new Component[]{userinfoEndpoint});
            AjaxTextFieldPanel tokenEndpoint = new AjaxTextFieldPanel("tokenEndpoint", "tokenEndpoint", (IModel)new PropertyModel((Object)opTO, "tokenEndpoint"));
            tokenEndpoint.setReadOnly(readOnly);
            content.add(new Component[]{tokenEndpoint});
            AjaxTextFieldPanel jwksUri = new AjaxTextFieldPanel("jwksUri", "jwksUri", (IModel)new PropertyModel((Object)opTO, "jwksUri"));
            jwksUri.setReadOnly(readOnly);
            content.add(new Component[]{jwksUri});
            AjaxTextFieldPanel endSessionEndpoint = new AjaxTextFieldPanel("endSessionEndpoint", "endSessionEndpoint", (IModel)new PropertyModel((Object)opTO, "endSessionEndpoint"));
            endSessionEndpoint.setReadOnly(readOnly);
            content.add(new Component[]{endSessionEndpoint});
            WebMarkupContainer visibleParam = new WebMarkupContainer("visibleParams");
            visibleParam.setOutputMarkupPlaceholderTag(true);
            visibleParam.add(new Component[]{authorizationEndpoint});
            visibleParam.add(new Component[]{userinfoEndpoint});
            visibleParam.add(new Component[]{tokenEndpoint});
            visibleParam.add(new Component[]{jwksUri});
            visibleParam.add(new Component[]{endSessionEndpoint});
            content.add(new Component[]{visibleParam});
        }
    }

    public class OP
    extends WizardStep {
        private static final long serialVersionUID = 7127421283216134900L;

        public OP(OIDCProviderTO opTO) {
            AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", "name", (IModel)new PropertyModel((Object)opTO, "name"), false);
            name.addRequiredLabel();
            name.setEnabled(true);
            this.add(new Component[]{name});
            AjaxTextFieldPanel clientID = new AjaxTextFieldPanel("clientID", "clientID", (IModel)new PropertyModel((Object)opTO, "clientID"), false);
            clientID.addRequiredLabel();
            clientID.setEnabled(true);
            this.add(new Component[]{clientID});
            AjaxTextFieldPanel clientSecret = new AjaxTextFieldPanel("clientSecret", "clientSecret", (IModel)new PropertyModel((Object)opTO, "clientSecret"), false);
            clientSecret.addRequiredLabel();
            clientSecret.setEnabled(true);
            this.add(new Component[]{clientSecret});
            AjaxCheckBoxPanel createUnmatching = new AjaxCheckBoxPanel("createUnmatching", "createUnmatching", (IModel)new PropertyModel((Object)opTO, "createUnmatching"), false);
            this.add(new Component[]{createUnmatching});
            AjaxCheckBoxPanel selfRegUnmatching = new AjaxCheckBoxPanel("selfRegUnmatching", "selfRegUnmatching", (IModel)new PropertyModel((Object)opTO, "selfRegUnmatching"), false);
            this.add(new Component[]{selfRegUnmatching});
            AjaxCheckBoxPanel updateMatching = new AjaxCheckBoxPanel("updateMatching", "updateMatching", (IModel)new PropertyModel((Object)opTO, "updateMatching"), false);
            this.add(new Component[]{updateMatching});
            AjaxPalettePanel actionsClassNames = new AjaxPalettePanel.Builder().setAllowMoveAll(true).setAllowOrder(true).setName(new StringResourceModel("actionsClassNames", (Component)OIDCProviderWizardBuilder.this.directoryPanel).getString()).build("actionsClassNames", (IModel)new PropertyModel((Object)opTO, "actionsClassNames"), (IModel)new ListModel((List)OIDCProviderWizardBuilder.this.actionsClasses.getObject()));
            actionsClassNames.setOutputMarkupId(true);
            this.add(new Component[]{actionsClassNames});
        }
    }
}

