/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.to.DelegationTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.DelegationDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Delegation;
import org.apache.syncope.core.provisioning.api.data.DelegationDataBinder;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class DelegationLogic
extends AbstractTransactionalLogic<DelegationTO> {
    @Autowired
    private DelegationDataBinder binder;
    @Autowired
    private DelegationDAO delegationDAO;
    @Autowired
    private UserDAO userDAO;

    private void securityChecks(String delegating, String entitlement) {
        if (!(AuthContextUtils.getAuthorizations().keySet().contains(entitlement) || delegating != null && delegating.equals(this.userDAO.findKey(AuthContextUtils.getUsername())))) {
            throw new DelegatedAdministrationException("/", AnyTypeKind.USER.name(), delegating);
        }
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public DelegationTO read(String key) {
        Delegation delegation = this.delegationDAO.find(key);
        if (delegation == null) {
            LOG.error("Could not find delegation '" + key + "'");
            throw new NotFoundException(key);
        }
        this.securityChecks(delegation.getDelegating().getKey(), "DELEGATION_READ");
        return this.binder.getDelegationTO(delegation);
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public List<DelegationTO> list() {
        Stream<DelegationTO> delegations = this.delegationDAO.findAll().stream().map(arg_0 -> ((DelegationDataBinder)this.binder).getDelegationTO(arg_0));
        if (!AuthContextUtils.getAuthorizations().keySet().contains("DELEGATION_LIST")) {
            String authUserKey = this.userDAO.findKey(AuthContextUtils.getUsername());
            delegations = delegations.filter(delegation -> delegation.getDelegating().equals(authUserKey));
        }
        return delegations.collect(Collectors.toList());
    }

    @PreAuthorize(value="isAuthenticated()")
    public DelegationTO create(DelegationTO delegationTO) {
        if (delegationTO.getDelegating() != null && !SyncopeConstants.UUID_PATTERN.matcher(delegationTO.getDelegating()).matches()) {
            delegationTO.setDelegating(this.userDAO.findKey(delegationTO.getDelegating()));
        }
        if (delegationTO.getDelegated() != null && !SyncopeConstants.UUID_PATTERN.matcher(delegationTO.getDelegated()).matches()) {
            delegationTO.setDelegated(this.userDAO.findKey(delegationTO.getDelegated()));
        }
        this.securityChecks(delegationTO.getDelegating(), "DELEGATION_CREATE");
        return this.binder.getDelegationTO(this.delegationDAO.save(this.binder.create(delegationTO)));
    }

    @PreAuthorize(value="isAuthenticated()")
    public DelegationTO update(DelegationTO delegationTO) {
        Delegation delegation = this.delegationDAO.find(delegationTO.getKey());
        if (delegation == null) {
            LOG.error("Could not find delegation '" + delegationTO.getKey() + "'");
            throw new NotFoundException(delegationTO.getKey());
        }
        this.securityChecks(delegation.getDelegating().getKey(), "DELEGATION_UPDATE");
        return this.binder.getDelegationTO(this.delegationDAO.save(this.binder.update(delegation, delegationTO)));
    }

    @PreAuthorize(value="isAuthenticated()")
    public DelegationTO delete(String key) {
        Delegation delegation = this.delegationDAO.find(key);
        if (delegation == null) {
            LOG.error("Could not find delegation '" + key + "'");
            throw new NotFoundException(key);
        }
        this.securityChecks(delegation.getDelegating().getKey(), "DELEGATION_DELETE");
        DelegationTO deleted = this.binder.getDelegationTO(delegation);
        this.delegationDAO.delete(key);
        return deleted;
    }

    @Override
    protected DelegationTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof DelegationTO)) continue;
                key = ((DelegationTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getDelegationTO(this.delegationDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

