/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.model;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.model.PlanItemRule;

public class ReactivationRule
extends PlanItemRule {
    protected String activateCondition;
    protected String ignoreCondition;
    protected String defaultCondition;

    public ReactivationRule() {
    }

    public ReactivationRule(String activateCondition, String ignoreCondition, String defaultCondition) {
        this.activateCondition = activateCondition;
        this.ignoreCondition = ignoreCondition;
        this.defaultCondition = defaultCondition;
    }

    public boolean hasActivationRule() {
        return StringUtils.isNotEmpty((CharSequence)this.activateCondition);
    }

    public boolean hasIgnoreRule() {
        return StringUtils.isNotEmpty((CharSequence)this.ignoreCondition);
    }

    public boolean hasDefaultRule() {
        return StringUtils.isNotEmpty((CharSequence)this.defaultCondition);
    }

    public boolean hasActivationCondition() {
        return this.hasActivationRule() && (this.activateCondition.contains("#") || this.activateCondition.contains("$"));
    }

    public boolean hasIgnoreCondition() {
        return this.hasIgnoreRule() && (this.ignoreCondition.contains("#") || this.ignoreCondition.contains("$"));
    }

    public boolean hasDefaultCondition() {
        return this.hasDefaultRule() && (this.defaultCondition.contains("#") || this.defaultCondition.contains("$"));
    }

    public String getDefaultCondition() {
        return this.defaultCondition;
    }

    public void setDefaultCondition(String defaultCondition) {
        this.defaultCondition = defaultCondition;
    }

    public String getActivateCondition() {
        return this.activateCondition;
    }

    public void setActivateCondition(String activateCondition) {
        this.activateCondition = activateCondition;
    }

    public String getIgnoreCondition() {
        return this.ignoreCondition;
    }

    public void setIgnoreCondition(String ignoreCondition) {
        this.ignoreCondition = ignoreCondition;
    }

    @Override
    public String toString() {
        return "ReactivationRule{} " + super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReactivationRule that = (ReactivationRule)o;
        return Objects.equals(this.activateCondition, that.activateCondition) && Objects.equals(this.ignoreCondition, that.ignoreCondition) && Objects.equals(this.defaultCondition, that.defaultCondition);
    }

    public int hashCode() {
        return Objects.hash(this.activateCondition, this.ignoreCondition, this.defaultCondition);
    }
}

