/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.annotations.Resource;
import org.apache.syncope.client.enduser.resources.BaseResource;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.UserRequestForm;
import org.apache.syncope.common.lib.types.UserRequestFormPropertyType;
import org.apache.syncope.common.rest.api.beans.UserRequestQuery;
import org.apache.syncope.common.rest.api.service.UserRequestService;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.string.StringValue;

@Resource(key="userRequestsForms", path="/api/flowable/userRequests/forms")
public class UserRequestsFormsResource
extends BaseResource {
    private static final long serialVersionUID = 7273151109078469253L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.setContentType("application/json");
        response.setTextEncoding(StandardCharsets.UTF_8.name());
        StringValue username = StringValue.valueOf((String)SyncopeEnduserSession.get().getSelfTO().getUsername());
        try {
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN does not match");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN does not match");
                return response;
            }
            switch (request.getMethod()) {
                case "GET": {
                    IRequestParameters requestParameters = attributes.getRequest().getQueryParameters();
                    StringValue page = requestParameters.getParameterValue("page");
                    StringValue size = requestParameters.getParameterValue("size");
                    LOG.debug("List available Flowable User Requests Forms by user [{}]", (Object)username);
                    final PagedResult userRequestForms = ((UserRequestService)SyncopeEnduserSession.get().getService(UserRequestService.class)).listForms((UserRequestQuery)((UserRequestQuery.Builder)((UserRequestQuery.Builder)new UserRequestQuery.Builder().user(username.isEmpty() ? SyncopeEnduserSession.get().getSelfTO().getUsername() : username.toString()).page(Integer.valueOf(page.isEmpty() ? 1 : page.toInt()))).size(Integer.valueOf(size.isEmpty() ? 10 : size.toInt()))).build());
                    userRequestForms.getResult().stream().forEach(form -> form.getProperties().stream().filter(prop -> UserRequestFormPropertyType.Date == prop.getType() && StringUtils.isNotBlank((CharSequence)prop.getValue())).forEach(prop -> {
                        try {
                            prop.setValue(String.valueOf(FastDateFormat.getInstance((String)prop.getDatePattern()).parse(prop.getValue()).getTime()));
                        }
                        catch (ParseException e) {
                            LOG.error("Unable to parse date", (Throwable)e);
                        }
                    }));
                    response.setWriteCallback(new AbstractResource.WriteCallback(){

                        public void writeData(IResource.Attributes attributes) throws IOException {
                            attributes.getResponse().write((CharSequence)BaseResource.MAPPER.writeValueAsString((Object)userRequestForms));
                        }
                    });
                    break;
                }
                case "POST": {
                    UserRequestForm requestForm = (UserRequestForm)MAPPER.readValue(request.getReader().readLine(), UserRequestForm.class);
                    if (requestForm == null) {
                        throw new IllegalArgumentException("Empty userRequestForm, please provide a valid one");
                    }
                    UserRequestService userRequestService = (UserRequestService)SyncopeEnduserSession.get().getService(UserRequestService.class);
                    userRequestService.claimForm(requestForm.getTaskId());
                    requestForm.getProperties().stream().filter(prop -> UserRequestFormPropertyType.Date == prop.getType() && StringUtils.isNotBlank((CharSequence)prop.getValue())).forEach(prop -> {
                        try {
                            prop.setValue(FastDateFormat.getInstance((String)prop.getDatePattern()).format((Object)Long.valueOf(prop.getValue())));
                        }
                        catch (NumberFormatException e) {
                            LOG.error("Unable to format date", (Throwable)e);
                        }
                    });
                    LOG.debug("Submit Flowable User Request Form for user [{}]", (Object)requestForm.getUsername());
                    userRequestService.submitForm(requestForm);
                    response.setStatusCode(Integer.valueOf(Response.Status.NO_CONTENT.getStatusCode()));
                    response.setWriteCallback(new AbstractResource.WriteCallback(){

                        public void writeData(IResource.Attributes attributes) throws IOException {
                        }
                    });
                    break;
                }
                default: {
                    LOG.error("Method [{}] not supported", (Object)request.getMethod());
                    response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + "Method not supported" + " }}");
                }
            }
            response.setContentType("application/json");
            response.setTextEncoding(StandardCharsets.UTF_8.name());
            response.setStatusCode(Integer.valueOf(Response.Status.OK.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error("Error dealing with forms of user [{}]", (Object)username, (Object)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }
}

