/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldap.sync.sunds;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.framework.common.exceptions.ConnectorException;

public class PasswordDecryptor {
    private static final String ENCRYPTION_ALGORITHM = "DESede/CBC/NoPadding";
    private static final int KEY_VERSION_MAGIC = 321721347;
    private static final int LENGTH_INDEX = 4;
    private final Cipher cipher;
    private final int blockSize;

    public PasswordDecryptor(byte[] desedeKey, byte[] iv) {
        Assertions.nullCheck((Object)desedeKey, (String)"desedeKey");
        Assertions.nullCheck((Object)iv, (String)"iv");
        IvParameterSpec ivspec = new IvParameterSpec(iv);
        SecretKeySpec keyspec = new SecretKeySpec(desedeKey, "DESede");
        try {
            this.cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM);
            this.cipher.init(2, (Key)keyspec, ivspec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ConnectorException((Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            throw new ConnectorException((Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new ConnectorException((Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new ConnectorException((Throwable)e);
        }
        this.blockSize = this.cipher.getBlockSize();
    }

    public String decryptPassword(byte[] encryptedPassword) {
        byte[] decryptedBytes;
        byte[] decryptInput;
        if (encryptedPassword.length % this.blockSize != 0) {
            decryptInput = new byte[(encryptedPassword.length / this.blockSize + 1) * this.blockSize];
            System.arraycopy(encryptedPassword, 0, decryptInput, 0, encryptedPassword.length);
            Arrays.fill(decryptInput, encryptedPassword.length, decryptInput.length, (byte)0);
        } else {
            decryptInput = encryptedPassword;
        }
        try {
            decryptedBytes = this.cipher.doFinal(decryptInput);
        }
        catch (IllegalStateException e) {
            throw new ConnectorException((Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            throw new ConnectorException((Throwable)e);
        }
        catch (BadPaddingException e) {
            throw new ConnectorException((Throwable)e);
        }
        try {
            return this.getDecryptedPassword(decryptedBytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    private final String getDecryptedPassword(byte[] password) throws ConnectorException, UnsupportedEncodingException {
        if (password.length < 8) {
            throw new ConnectorException("Invalid decrypted password value: too short");
        }
        int len = this.getIntValueFromByteArray(password, 4);
        if (len < 0) {
            throw new ConnectorException("Weird decrypted password value: negative length");
        }
        if (len <= password.length - 12 - this.blockSize || len > password.length - 12) {
            throw new ConnectorException("Invalid password length");
        }
        this.checkKeyVersionMagic(password, 8 + len);
        return new String(password, 8, len, "UTF8");
    }

    private final void checkKeyVersionMagic(byte[] password, int postMagicIndex) throws ConnectorException {
        if (postMagicIndex < 8 || postMagicIndex > password.length - 4) {
            throw new ConnectorException("Invalid start index for post password magic");
        }
        int premagic = this.getIntValueFromByteArray(password, 0);
        int postmagic = this.getIntValueFromByteArray(password, postMagicIndex);
        if (premagic != 321721347 || postmagic != 321721347) {
            throw new ConnectorException("Key magic mismatch");
        }
    }

    private int getIntValueFromByteArray(byte[] bytes, int index) {
        return (this.getUnsignedByteValueAsInt(bytes[index]) << 24) + (this.getUnsignedByteValueAsInt(bytes[index + 1]) << 16) + (this.getUnsignedByteValueAsInt(bytes[index + 2]) << 8) + this.getUnsignedByteValueAsInt(bytes[index + 3]);
    }

    private int getUnsignedByteValueAsInt(byte b) {
        if (b < 0) {
            return 256 + b;
        }
        return b;
    }
}

