/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.java;

import java.io.Serializable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.ConfDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.UserWorkflowResult;
import org.apache.syncope.core.workflow.api.WorkflowException;
import org.apache.syncope.core.workflow.java.AbstractUserWorkflowAdapter;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultUserWorkflowAdapter
extends AbstractUserWorkflowAdapter {
    @Autowired
    private ConfDAO confDAO;

    @Override
    protected UserWorkflowResult<Pair<String, Boolean>> doCreate(UserTO userTO, boolean disablePwdPolicyCheck, Boolean enabled, boolean storePassword) {
        boolean propagateEnable;
        String status;
        User user = (User)this.entityFactory.newEntity(User.class);
        this.dataBinder.create(user, userTO, storePassword);
        if (disablePwdPolicyCheck) {
            user.removeClearPassword();
        }
        if (enabled == null) {
            status = "created";
            propagateEnable = true;
        } else {
            status = enabled != false ? "active" : "suspended";
            propagateEnable = enabled;
            user.setSuspended(Boolean.valueOf(enabled == false));
        }
        user.setStatus(status);
        user = (User)this.userDAO.save((Any)user);
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.set(ResourceOperation.CREATE, this.userDAO.findAllResourceKeys(user.getKey()));
        PropagationByResource propByLinkedAccount = new PropagationByResource();
        user.getLinkedAccounts().forEach(account -> propByLinkedAccount.add(ResourceOperation.CREATE, (Serializable)Pair.of((Object)account.getResource().getKey(), (Object)account.getConnObjectKeyValue())));
        return new UserWorkflowResult((Object)Pair.of((Object)user.getKey(), (Object)propagateEnable), propByRes, propByLinkedAccount, "create");
    }

    @Override
    protected UserWorkflowResult<String> doActivate(User user, String token) {
        if (!user.checkToken(token)) {
            throw new WorkflowException((Throwable)new IllegalArgumentException("Wrong token: " + token + " for " + user));
        }
        user.removeToken();
        user.setStatus("active");
        User updated = (User)this.userDAO.save((Any)user);
        return new UserWorkflowResult((Object)updated.getKey(), null, null, "activate");
    }

    @Override
    protected UserWorkflowResult<Pair<UserPatch, Boolean>> doUpdate(User user, UserPatch userPatch) {
        Pair propInfo = this.dataBinder.update(user, userPatch);
        return new UserWorkflowResult((Object)Pair.of((Object)userPatch, (Object)(user.isSuspended() == false ? 1 : 0)), (PropagationByResource)propInfo.getLeft(), (PropagationByResource)propInfo.getRight(), "update");
    }

    @Override
    protected UserWorkflowResult<String> doSuspend(User user) {
        user.setStatus("suspended");
        User updated = (User)this.userDAO.save((Any)user);
        return new UserWorkflowResult((Object)updated.getKey(), null, null, "suspend");
    }

    @Override
    protected UserWorkflowResult<String> doReactivate(User user) {
        user.setStatus("active");
        User updated = (User)this.userDAO.save((Any)user);
        return new UserWorkflowResult((Object)updated.getKey(), null, null, "reactivate");
    }

    @Override
    protected void doRequestPasswordReset(User user) {
        user.generateToken(((Long)this.confDAO.find("token.length", (Object)256L)).intValue(), ((Long)this.confDAO.find("token.expireTime", (Object)60L)).intValue());
        this.userDAO.save((Any)user);
    }

    @Override
    protected UserWorkflowResult<Pair<UserPatch, Boolean>> doConfirmPasswordReset(User user, String token, String password) {
        if (!user.checkToken(token)) {
            throw new WorkflowException((Throwable)new IllegalArgumentException("Wrong token: " + token + " for " + user));
        }
        user.removeToken();
        UserPatch userPatch = new UserPatch();
        userPatch.setKey(user.getKey());
        userPatch.setPassword((PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().onSyncope(true).resources(this.userDAO.findAllResourceKeys(user.getKey())).value((Object)password)).build());
        return this.doUpdate(user, userPatch);
    }

    @Override
    protected void doDelete(User user) {
        this.userDAO.delete((Any)user);
    }
}

