/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.servicenow.service;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.HashMap;
import net.tirasa.connid.bundles.servicenow.SNConnectorConfiguration;
import net.tirasa.connid.bundles.servicenow.dto.PagedResults;
import net.tirasa.connid.bundles.servicenow.dto.Resource;
import net.tirasa.connid.bundles.servicenow.service.SNService;
import net.tirasa.connid.bundles.servicenow.utils.SNUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;

public class SNClient
extends SNService {
    private static final Log LOG = Log.getLog(SNClient.class);

    public SNClient(SNConnectorConfiguration config) {
        super(config);
    }

    public PagedResults<Resource> getResources(SNService.ResourceTable type) {
        return this.doGetResources(this.getWebclient(type, null));
    }

    public PagedResults<Resource> getResources(SNService.ResourceTable type, Integer startIndex, Integer count, Boolean backward) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sysparm_offset", String.valueOf(startIndex));
        if (count != null) {
            params.put("sysparm_limit", String.valueOf(count));
        }
        if (backward.booleanValue()) {
            params.put("rel", "prev");
        } else {
            params.put("rel", "next");
        }
        return this.doGetResources(this.getWebclient(type, params));
    }

    public PagedResults<Resource> getResources(SNService.ResourceTable type, String filterQuery) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sysparm_query", filterQuery);
        return this.doGetResources(this.getWebclient(type, params));
    }

    public PagedResults<Resource> getResources(SNService.ResourceTable type, String filterQuery, Integer startIndex, Integer count, Boolean backward) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sysparm_query", filterQuery);
        params.put("sysparm_offset", String.valueOf(startIndex));
        if (count != null) {
            params.put("sysparm_limit", String.valueOf(count));
        }
        if (backward.booleanValue()) {
            params.put("rel", "prev");
        } else {
            params.put("rel", "next");
        }
        return this.doGetResources(this.getWebclient(type, params));
    }

    public Resource getResource(SNService.ResourceTable type, String id) {
        return this.doGetResource(this.getWebclient(type, null).path((Object)id));
    }

    public Resource createResource(SNService.ResourceTable type, Resource resource) {
        return (Resource)Resource.class.cast(this.doCreateResource(type, resource));
    }

    public Resource updateResource(SNService.ResourceTable type, Resource resource) {
        return (Resource)Resource.class.cast(this.doUpdateResource(type, resource));
    }

    public void deleteResource(SNService.ResourceTable type, String id) {
        WebClient webClient = this.getWebclient(type, null).path((Object)id);
        this.doDeleteResource(id, webClient);
    }

    public boolean testService() {
        return this.getResources(SNService.ResourceTable.sys_user, 0, 1, false) != null;
    }

    private PagedResults<Resource> doGetResources(WebClient webClient) {
        PagedResults resources = null;
        try {
            resources = (PagedResults)SNUtils.MAPPER.readValue(this.doGet(webClient).toString(), (TypeReference)new TypeReference<PagedResults<Resource>>(){});
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "While converting from JSON to Resources", new Object[0]);
        }
        if (resources == null) {
            SNUtils.handleGeneralError("While retrieving Resources from service");
        }
        return resources;
    }

    private Resource doGetResource(WebClient webClient) {
        Resource resource = null;
        try {
            resource = (Resource)SNUtils.MAPPER.readValue(this.doGet(webClient).toString(), Resource.class);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "While converting from JSON to Resource", new Object[0]);
        }
        if (resource == null) {
            SNUtils.handleGeneralError("While retrieving Resource from service after create");
        }
        return resource;
    }

    private Resource doUpdateResource(SNService.ResourceTable type, Resource resource) {
        if (StringUtil.isBlank((String)resource.getSysId())) {
            SNUtils.handleGeneralError("Missing required Resource id attribute for update");
        }
        Resource updated = null;
        try {
            updated = (Resource)SNUtils.MAPPER.readValue(this.doUpdate(resource, this.getWebclient(type, null).path((Object)resource.getSysId())).toString(), Resource.class);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "While converting from JSON to Resource", new Object[0]);
        }
        if (updated == null) {
            SNUtils.handleGeneralError("While retrieving Resource from service after update");
        }
        return updated;
    }

    private Resource doCreateResource(SNService.ResourceTable type, Resource resource) {
        this.doCreate(resource, this.getWebclient(type, null));
        return resource;
    }

    private void doDeleteResource(String id, WebClient webClient) {
        this.doDelete(id, webClient);
    }
}

