/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.Remediation;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.RemediationCheck;

public class RemediationValidator
extends AbstractValidator<RemediationCheck, Remediation> {
    public boolean isValid(Remediation remediation, ConstraintValidatorContext context) {
        boolean isValid = true;
        switch (remediation.getOperation()) {
            case CREATE: {
                if (remediation.getPayloadAsTO(remediation.getAnyType().getKind().getTOClass()) != null) break;
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidRemediation, "Expected " + remediation.getAnyType().getKind().getTOClass().getName())).addPropertyNode("payload").addConstraintViolation();
                isValid = false;
                break;
            }
            case UPDATE: {
                if (remediation.getPayloadAsPatch(remediation.getAnyType().getKind().getPatchClass()) != null) break;
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidRemediation, "Expected " + remediation.getAnyType().getKind().getPatchClass().getName())).addPropertyNode("payload").addConstraintViolation();
                isValid = false;
                break;
            }
            case DELETE: {
                if (SyncopeConstants.UUID_PATTERN.matcher(remediation.getPayloadAsKey()).matches()) break;
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidRemediation, "Expected UUID")).addPropertyNode("payload").addConstraintViolation();
                isValid = false;
                break;
            }
            default: {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidRemediation, "NONE is not allowed")).addPropertyNode("operation").addConstraintViolation();
                isValid = false;
            }
        }
        return isValid;
    }
}

