/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import java.util.Set;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.validation.Validator;
import org.apache.commons.lang3.ClassUtils;
import org.apache.syncope.core.persistence.api.attrvalue.validation.InvalidEntityException;
import org.apache.syncope.core.persistence.api.entity.AnnotatedEntity;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.DynMembership;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.GroupableRelatable;
import org.apache.syncope.core.persistence.api.entity.ProvidedKeyEntity;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityValidationListener {
    private static final Logger LOG = LoggerFactory.getLogger(EntityValidationListener.class);

    @PrePersist
    @PreUpdate
    public void validate(Object object) {
        Validator validator = (Validator)ApplicationContextProvider.getBeanFactory().getBean(Validator.class);
        Set violations = validator.validate(object, new Class[0]);
        if (!violations.isEmpty()) {
            LOG.warn("Bean validation errors found: {}", (Object)violations);
            Class entityInt = null;
            for (Class interf : ClassUtils.getAllInterfaces(object.getClass())) {
                if (Entity.class.equals((Object)interf) || AnnotatedEntity.class.equals((Object)interf) || ProvidedKeyEntity.class.equals((Object)interf) || Schema.class.equals((Object)interf) || Task.class.equals((Object)interf) || Policy.class.equals((Object)interf) || GroupableRelatable.class.equals((Object)interf) || Any.class.equals((Object)interf) || DynMembership.class.equals((Object)interf) || !Entity.class.isAssignableFrom(interf)) continue;
                entityInt = interf;
            }
            throw new InvalidEntityException(entityInt == null ? "Entity" : entityInt.getSimpleName(), violations);
        }
    }
}

