/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.task;

import org.apache.syncope.common.lib.to.NotificationTaskTO;
import org.apache.syncope.common.lib.to.PropagationTaskTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.to.TaskTO;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.task.NotificationTask;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtils;
import org.springframework.beans.factory.annotation.Autowired;

public final class JPATaskUtils
implements TaskUtils {
    private final TaskType type;
    @Autowired
    private EntityFactory entityFactory;

    protected JPATaskUtils(TaskType type) {
        this.type = type;
    }

    public TaskType getType() {
        return this.type;
    }

    public <T extends Task> Class<T> taskClass() {
        Class<PropagationTask> result = null;
        switch (this.type) {
            case PROPAGATION: {
                result = PropagationTask.class;
                break;
            }
            case SCHEDULED: {
                result = SchedTask.class;
                break;
            }
            case PULL: {
                result = PullTask.class;
                break;
            }
            case PUSH: {
                result = PushTask.class;
                break;
            }
            case NOTIFICATION: {
                result = NotificationTask.class;
                break;
            }
        }
        return result;
    }

    public <T extends Task> T newTask() {
        Task result = null;
        switch (this.type) {
            case PROPAGATION: {
                result = (Task)this.entityFactory.newEntity(PropagationTask.class);
                break;
            }
            case SCHEDULED: {
                result = (Task)this.entityFactory.newEntity(SchedTask.class);
                break;
            }
            case PULL: {
                result = (Task)this.entityFactory.newEntity(PullTask.class);
                break;
            }
            case PUSH: {
                result = (Task)this.entityFactory.newEntity(PushTask.class);
                break;
            }
            case NOTIFICATION: {
                result = (Task)this.entityFactory.newEntity(NotificationTask.class);
                break;
            }
        }
        return (T)result;
    }

    public <T extends TaskTO> Class<T> taskTOClass() {
        Class<PropagationTaskTO> result = null;
        switch (this.type) {
            case PROPAGATION: {
                result = PropagationTaskTO.class;
                break;
            }
            case SCHEDULED: {
                result = SchedTaskTO.class;
                break;
            }
            case PULL: {
                result = PullTaskTO.class;
                break;
            }
            case PUSH: {
                result = PushTaskTO.class;
                break;
            }
            case NOTIFICATION: {
                result = NotificationTaskTO.class;
                break;
            }
        }
        return result;
    }

    public <T extends TaskTO> T newTaskTO() {
        Class<T> taskClass = this.taskTOClass();
        try {
            return (T)(taskClass == null ? null : (TaskTO)taskClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            return null;
        }
    }
}

