/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.to.PropagationTaskTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.dao.RemediationDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Notification;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.task.AbstractTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPANotificationTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPropagationTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPullTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPushTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPASchedTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

@Repository
public class JPATaskDAO
extends AbstractDAO<Task>
implements TaskDAO {
    @Autowired
    private RemediationDAO remediationDAO;

    public Class<? extends Task> getEntityReference(TaskType type) {
        Class result = null;
        switch (type) {
            case NOTIFICATION: {
                result = JPANotificationTask.class;
                break;
            }
            case PROPAGATION: {
                result = JPAPropagationTask.class;
                break;
            }
            case PUSH: {
                result = JPAPushTask.class;
                break;
            }
            case SCHEDULED: {
                result = JPASchedTask.class;
                break;
            }
            case PULL: {
                result = JPAPullTask.class;
                break;
            }
        }
        return result;
    }

    private String getEntityTableName(TaskType type) {
        String result = null;
        switch (type) {
            case NOTIFICATION: {
                result = JPANotificationTask.class.getAnnotation(DiscriminatorValue.class).value();
                break;
            }
            case PROPAGATION: {
                result = JPAPropagationTask.class.getAnnotation(DiscriminatorValue.class).value();
                break;
            }
            case PUSH: {
                result = JPAPushTask.class.getAnnotation(DiscriminatorValue.class).value();
                break;
            }
            case SCHEDULED: {
                result = JPASchedTask.class.getAnnotation(DiscriminatorValue.class).value();
                break;
            }
            case PULL: {
                result = JPAPullTask.class.getAnnotation(DiscriminatorValue.class).value();
                break;
            }
        }
        return result;
    }

    @Transactional(readOnly=true)
    public <T extends Task> T find(String key) {
        return (T)((Task)this.entityManager().find(AbstractTask.class, (Object)key));
    }

    public List<SchedTask> findByDelegate(Implementation delegate) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPASchedTask.class.getSimpleName() + " e WHERE e.jobDelegate=:delegate", SchedTask.class);
        query.setParameter("delegate", (Object)delegate);
        return query.getResultList();
    }

    public List<PullTask> findByReconFilterBuilder(Implementation reconFilterBuilder) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAPullTask.class.getSimpleName() + " e WHERE e.reconFilterBuilder=:reconFilterBuilder", PullTask.class);
        query.setParameter("reconFilterBuilder", (Object)reconFilterBuilder);
        return query.getResultList();
    }

    public List<PullTask> findByPullActions(Implementation pullActions) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAPullTask.class.getSimpleName() + " e WHERE :pullActions MEMBER OF e.actions", PullTask.class);
        query.setParameter("pullActions", (Object)pullActions);
        return query.getResultList();
    }

    public List<PushTask> findByPushActions(Implementation pushActions) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAPushTask.class.getSimpleName() + " e WHERE :pushActions MEMBER OF e.actions", PushTask.class);
        query.setParameter("pushActions", (Object)pushActions);
        return query.getResultList();
    }

    private <T extends Task> StringBuilder buildFindAllQueryJPA(TaskType type) {
        StringBuilder builder = new StringBuilder("SELECT t FROM ").append(this.getEntityReference(type).getSimpleName()).append(" t WHERE ");
        if (type == TaskType.SCHEDULED) {
            builder.append("t.id NOT IN (SELECT t.id FROM ").append(JPAPushTask.class.getSimpleName()).append(" t) ").append("AND ").append("t.id NOT IN (SELECT t.id FROM ").append(JPAPullTask.class.getSimpleName()).append(" t)");
        } else {
            builder.append("1=1");
        }
        return builder.append(' ');
    }

    public <T extends Task> List<T> findToExec(TaskType type) {
        StringBuilder queryString = this.buildFindAllQueryJPA(type).append("AND ");
        if (type == TaskType.NOTIFICATION) {
            queryString.append("t.executed = false ");
        } else {
            queryString.append("t.executions IS EMPTY ");
        }
        queryString.append("ORDER BY t.id DESC");
        Query query = this.entityManager().createQuery(queryString.toString());
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public <T extends Task> List<T> findAll(TaskType type) {
        return this.findAll(type, null, null, null, null, -1, -1, Collections.emptyList());
    }

    private StringBuilder buildFindAllQuery(TaskType type, ExternalResource resource, Notification notification, AnyTypeKind anyTypeKind, String entityKey, boolean orderByTaskExecInfo, List<Object> queryParameters) {
        if (resource != null && type != TaskType.PROPAGATION && type != TaskType.PUSH && type != TaskType.PULL) {
            throw new IllegalArgumentException(type + " is not related to " + ExternalResource.class.getSimpleName());
        }
        if ((anyTypeKind != null || entityKey != null) && type != TaskType.PROPAGATION && type != TaskType.NOTIFICATION) {
            throw new IllegalArgumentException(type + " is not related to users, groups or any objects");
        }
        if (notification != null && type != TaskType.NOTIFICATION) {
            throw new IllegalArgumentException(type + " is not related to notifications");
        }
        StringBuilder queryString = new StringBuilder("SELECT ").append("Task").append(".*");
        if (orderByTaskExecInfo) {
            queryString.append(",").append("TaskExec").append(".startDate AS startDate").append(",").append("TaskExec").append(".endDate AS endDate").append(",").append("TaskExec").append(".status AS status").append(" FROM ").append("Task").append(",").append("TaskExec").append(",").append("(SELECT ").append("TaskExec").append(".task_id, ").append("MAX(").append("TaskExec").append(".startDate) AS startDate").append(" FROM ").append("TaskExec").append(" GROUP BY ").append("TaskExec").append(".task_id) GRP").append(" WHERE ").append("Task").append(".id=").append("TaskExec").append(".task_id").append(" AND ").append("Task").append(".id=").append("GRP.task_id").append(" AND ").append("TaskExec").append(".startDate=").append("GRP.startDate").append(" AND ").append("Task").append(".DTYPE = ?1");
        } else {
            queryString.append(", null AS startDate, null AS endDate, null AS status FROM ").append("Task").append(" WHERE ").append("Task").append(".DTYPE = ?1");
        }
        queryParameters.add(this.getEntityTableName(type));
        if (type == TaskType.SCHEDULED) {
            queryString.append(" AND ").append("Task").append(".id NOT IN (SELECT ").append("Task").append(".id FROM ").append("Task").append(" WHERE ").append("Task").append(".DTYPE = ?2)").append(" AND ").append("Task").append(".id NOT IN (SELECT id FROM ").append("Task").append(" WHERE ").append("Task").append(".DTYPE = ?3)");
            queryParameters.add(JPAPushTask.class.getAnnotation(DiscriminatorValue.class).value());
            queryParameters.add(JPAPullTask.class.getAnnotation(DiscriminatorValue.class).value());
        }
        queryString.append(' ');
        if (resource != null) {
            queryParameters.add(resource.getKey());
            queryString.append(" AND ").append("Task").append(".resource_id=?").append(queryParameters.size());
        }
        if (notification != null) {
            queryParameters.add(notification.getKey());
            queryString.append(" AND ").append("Task").append(".notification_id=?").append(queryParameters.size());
        }
        if (anyTypeKind != null && entityKey != null) {
            queryParameters.add(anyTypeKind.name());
            queryParameters.add(entityKey);
            queryString.append(" AND ").append("Task").append(".anyTypeKind=?").append(queryParameters.size() - 1).append(" AND ").append("Task").append(".entityKey=?").append(queryParameters.size());
        }
        return queryString;
    }

    private String toOrderByStatement(Class<? extends Task> beanClass, List<OrderByClause> orderByClauses) {
        StringBuilder statement = new StringBuilder();
        statement.append(" ORDER BY ");
        StringBuilder subStatement = new StringBuilder();
        orderByClauses.forEach(clause -> {
            String field;
            switch (field = clause.getField().trim()) {
                case "latestExecStatus": {
                    field = "status";
                    break;
                }
                case "start": {
                    field = "startDate";
                    break;
                }
                case "end": {
                    field = "endDate";
                    break;
                }
                default: {
                    Field beanField = ReflectionUtils.findField((Class)beanClass, (String)field);
                    if (beanField == null || beanField.getAnnotation(ManyToOne.class) == null && beanField.getAnnotation(OneToMany.class) == null) break;
                    field = field + "_id";
                }
            }
            subStatement.append(field).append(' ').append(clause.getDirection().name()).append(',');
        });
        if (subStatement.length() == 0) {
            statement.append("id DESC");
        } else {
            subStatement.deleteCharAt(subStatement.length() - 1);
            statement.append((CharSequence)subStatement);
        }
        return statement.toString();
    }

    public <T extends Task> List<T> findAll(TaskType type, ExternalResource resource, Notification notification, AnyTypeKind anyTypeKind, String entityKey, int page, int itemsPerPage, List<OrderByClause> orderByClauses) {
        ArrayList<Object> queryParameters = new ArrayList<Object>();
        boolean orderByTaskExecInfo = orderByClauses.stream().anyMatch(clause -> clause.getField().equals("start") || clause.getField().equals("end") || clause.getField().equals("latestExecStatus") || clause.getField().equals("status"));
        StringBuilder queryString = this.buildFindAllQuery(type, resource, notification, anyTypeKind, entityKey, orderByTaskExecInfo, queryParameters);
        if (orderByTaskExecInfo) {
            queryString.insert(0, "SELECT T.id FROM ((").append(") UNION ALL (").append((CharSequence)this.buildFindAllQuery(type, resource, notification, anyTypeKind, entityKey, false, queryParameters)).append(" AND id NOT IN ").append("(SELECT task_id AS id FROM ").append("TaskExec").append(")").append(")) T");
        } else {
            queryString.insert(0, "SELECT T.id FROM (").append(") T");
        }
        queryString.append(this.toOrderByStatement(this.getEntityReference(type), orderByClauses));
        Query query = this.entityManager().createNativeQuery(queryString.toString());
        for (int i = 1; i <= queryParameters.size(); ++i) {
            query.setParameter(i, queryParameters.get(i - 1));
        }
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        if (itemsPerPage > 0) {
            query.setMaxResults(itemsPerPage);
        }
        ArrayList result = new ArrayList();
        List raw = query.getResultList();
        raw.stream().map(key -> key instanceof Object[] ? (String)((Object[])key)[0] : (String)key).forEach(key -> {
            Object task = this.find((String)key);
            if (task == null) {
                LOG.error("Could not find task with key {}, even if returned by native query", key);
            } else if (!result.contains(task)) {
                result.add(task);
            }
        });
        return result;
    }

    public int count(TaskType type, ExternalResource resource, Notification notification, AnyTypeKind anyTypeKind, String entityKey) {
        ArrayList<Object> queryParameters = new ArrayList<Object>();
        StringBuilder queryString = this.buildFindAllQuery(type, resource, notification, anyTypeKind, entityKey, false, queryParameters);
        Query query = this.entityManager().createNativeQuery(StringUtils.replaceOnce((String)queryString.toString(), (String)"SELECT Task.*, null AS startDate, null AS endDate, null AS status", (String)"SELECT COUNT(Task.id)"));
        for (int i = 1; i <= queryParameters.size(); ++i) {
            query.setParameter(i, queryParameters.get(i - 1));
        }
        return ((Number)query.getSingleResult()).intValue();
    }

    @Transactional(rollbackFor={Throwable.class})
    public <T extends Task> T save(T task) {
        return (T)((Task)this.entityManager().merge(task));
    }

    public void delete(String id) {
        Object task = this.find(id);
        if (task == null) {
            return;
        }
        this.delete((Task)task);
    }

    public void delete(Task task) {
        if (task instanceof PullTask) {
            this.remediationDAO.findByPullTask((PullTask)task).forEach(remediation -> remediation.setPullTask(null));
        }
        this.entityManager().remove((Object)task);
    }

    public void deleteAll(ExternalResource resource, TaskType type) {
        this.findAll(type, resource, null, null, null, -1, -1, Collections.emptyList()).stream().map(Entity::getKey).forEach(this::delete);
    }

    public List<PropagationTaskTO> purgePropagations(Date since, List<ExecStatus> statuses) {
        StringBuilder queryString = new StringBuilder("SELECT t.task_id FROM TaskExec t INNER JOIN Task z ON t.task_id=z.id AND z.dtype='PropagationTask' WHERE t.enddate=(SELECT MAX(e.enddate) FROM TaskExec e WHERE e.task_id=t.task_id) ");
        ArrayList<Date> queryParameters = new ArrayList<Date>();
        if (since != null) {
            queryParameters.add(since);
            queryString.append("AND t.enddate <= ?").append(queryParameters.size()).append(' ');
        }
        if (!CollectionUtils.isEmpty(statuses)) {
            queryString.append("AND (").append(statuses.stream().map(status -> {
                queryParameters.add((Date)((Object)status.name()));
                return "t.status = ?" + queryParameters.size();
            }).collect(Collectors.joining(" OR "))).append(")");
        }
        Query query = this.entityManager().createNativeQuery(queryString.toString());
        for (int i = 1; i <= queryParameters.size(); ++i) {
            query.setParameter(i, queryParameters.get(i - 1));
        }
        List raw = query.getResultList();
        ArrayList<PropagationTaskTO> purged = new ArrayList<PropagationTaskTO>();
        raw.stream().map(Object::toString).distinct().forEach(key -> {
            PropagationTask task = (PropagationTask)this.find((String)key);
            if (task != null) {
                PropagationTaskTO taskTO = new PropagationTaskTO();
                taskTO.setOperation(task.getOperation());
                taskTO.setConnObjectKey(task.getConnObjectKey());
                taskTO.setOldConnObjectKey(task.getOldConnObjectKey());
                taskTO.setAttributes(task.getSerializedAttributes());
                taskTO.setResource(task.getResource().getKey());
                taskTO.setObjectClassName(task.getObjectClassName());
                taskTO.setAnyTypeKind(task.getAnyTypeKind());
                taskTO.setAnyType(task.getAnyType());
                taskTO.setEntityKey(task.getEntityKey());
                purged.add(taskTO);
                this.delete((Task)task);
            }
        });
        return purged;
    }
}

