/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.sql.Clob;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.log.AuditEntry;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.LoggerLevel;
import org.apache.syncope.common.lib.types.LoggerType;
import org.apache.syncope.core.persistence.api.dao.LoggerDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.Logger;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPALogger;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.springframework.transaction.annotation.Transactional;

public class JPALoggerDAO
extends AbstractDAO<Logger>
implements LoggerDAO {
    public Logger find(String key) {
        return (Logger)this.entityManager().find(JPALogger.class, (Object)key);
    }

    public List<Logger> findAll(LoggerType type) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPALogger.class.getSimpleName() + " e WHERE e.type=:type", Logger.class);
        query.setParameter("type", (Object)type);
        return query.getResultList();
    }

    public Logger save(Logger logger) {
        if (LoggerType.AUDIT == logger.getType() && LoggerLevel.OFF != logger.getLevel()) {
            logger.setLevel(LoggerLevel.DEBUG);
        }
        return (Logger)this.entityManager().merge((Object)logger);
    }

    public void delete(Logger logger) {
        this.entityManager().remove((Object)logger);
    }

    public void delete(String key) {
        Logger logger = this.find(key);
        if (logger == null) {
            return;
        }
        this.delete(logger);
    }

    protected MessageCriteriaBuilder messageCriteriaBuilder(String entityKey) {
        return new MessageCriteriaBuilder().entityKey(entityKey);
    }

    public int countAuditEntries(String entityKey, AuditElements.EventCategoryType type, String category, String subcategory, List<String> events, AuditElements.Result result) {
        String queryString = "SELECT COUNT(0) FROM SYNCOPEAUDIT WHERE " + this.messageCriteriaBuilder(entityKey).type(type).category(category).subcategory(subcategory).result(result).events(events).build();
        Query countQuery = this.entityManager().createNativeQuery(queryString);
        return ((Number)countQuery.getSingleResult()).intValue();
    }

    protected String select() {
        return "MESSAGE";
    }

    @Transactional(readOnly=true)
    public List<AuditEntry> findAuditEntries(String entityKey, int page, int itemsPerPage, AuditElements.EventCategoryType type, String category, String subcategory, List<String> events, AuditElements.Result result, List<OrderByClause> orderByClauses) {
        String queryString = "SELECT " + this.select() + " FROM " + "SYNCOPEAUDIT" + " WHERE " + this.messageCriteriaBuilder(entityKey).type(type).category(category).subcategory(subcategory).result(result).events(events).build();
        if (!orderByClauses.isEmpty()) {
            queryString = queryString + " ORDER BY " + orderByClauses.stream().map(orderBy -> orderBy.getField() + ' ' + orderBy.getDirection().name()).collect(Collectors.joining(","));
        }
        Query query = this.entityManager().createNativeQuery(queryString);
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        if (itemsPerPage >= 0) {
            query.setMaxResults(itemsPerPage);
        }
        List entries = query.getResultList();
        return entries.stream().map(row -> {
            String value;
            if (row instanceof Clob) {
                Clob clob = (Clob)row;
                try {
                    value = clob.getSubString(1L, (int)clob.length());
                }
                catch (SQLException e) {
                    LOG.error("Unexpected error reading Audit Entry for entity key {}", (Object)entityKey, (Object)e);
                    return null;
                }
            } else {
                value = row.toString();
            }
            return (AuditEntry)POJOHelper.deserialize((String)value, AuditEntry.class);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected static class MessageCriteriaBuilder {
        protected final StringBuilder query = new StringBuilder();

        protected MessageCriteriaBuilder() {
        }

        protected String andIfNeeded() {
            return this.query.length() == 0 ? " " : " AND ";
        }

        protected MessageCriteriaBuilder entityKey(String entityKey) {
            if (entityKey != null) {
                this.query.append(this.andIfNeeded()).append("MESSAGE").append(" LIKE '%key%").append(entityKey).append("%'");
            }
            return this;
        }

        public MessageCriteriaBuilder type(AuditElements.EventCategoryType type) {
            if (type != null) {
                this.query.append(this.andIfNeeded()).append("MESSAGE").append(" LIKE '%\"type\":\"").append(type.name()).append("\"%'");
            }
            return this;
        }

        public MessageCriteriaBuilder category(String category) {
            if (StringUtils.isNotBlank((CharSequence)category)) {
                this.query.append(this.andIfNeeded()).append("MESSAGE").append(" LIKE '%\"category\":\"").append(category).append("\"%'");
            }
            return this;
        }

        public MessageCriteriaBuilder subcategory(String subcategory) {
            if (StringUtils.isNotBlank((CharSequence)subcategory)) {
                this.query.append(this.andIfNeeded()).append("MESSAGE").append(" LIKE '%\"subcategory\":\"").append(subcategory).append("\"%'");
            }
            return this;
        }

        public MessageCriteriaBuilder events(List<String> events) {
            if (!events.isEmpty()) {
                this.query.append(this.andIfNeeded()).append("( ").append(events.stream().map(event -> "MESSAGE LIKE '%\"event\":\"" + event + "\"%'").collect(Collectors.joining(" OR "))).append(" )");
            }
            return this;
        }

        public MessageCriteriaBuilder result(AuditElements.Result result) {
            if (result != null) {
                this.query.append(this.andIfNeeded()).append("MESSAGE").append(" LIKE '%\"result\":\"").append(result.name()).append("\"%' ");
            }
            return this;
        }

        public String build() {
            return this.query.toString();
        }
    }
}

