/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AssignableCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.DynRealmCond;
import org.apache.syncope.core.persistence.api.dao.search.MemberCond;
import org.apache.syncope.core.persistence.api.dao.search.MembershipCond;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAPlainSchema;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractAnySearchDAO
extends AbstractDAO<Any<?>>
implements AnySearchDAO {
    private static final String[] ORDER_BY_NOT_ALLOWED = new String[]{"serialVersionUID", "password", "securityQuestion", "securityAnswer", "token", "tokenExpireTime"};
    protected static final String[] RELATIONSHIP_FIELDS = new String[]{"realm", "userOwner", "groupOwner"};
    @Autowired
    protected RealmDAO realmDAO;
    @Autowired
    protected DynRealmDAO dynRealmDAO;
    @Autowired
    protected AnyObjectDAO anyObjectDAO;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected PlainSchemaDAO schemaDAO;
    @Autowired
    protected EntityFactory entityFactory;
    @Autowired
    protected AnyUtilsFactory anyUtilsFactory;

    protected SearchCond buildEffectiveCond(SearchCond cond, Set<String> dynRealmKeys, Set<String> groupOwners, AnyTypeKind kind) {
        List groupOwnerConds;
        ArrayList<SearchCond> result = new ArrayList<SearchCond>();
        result.add(cond);
        List dynRealmConds = dynRealmKeys.stream().map(key -> {
            DynRealmCond dynRealmCond = new DynRealmCond();
            dynRealmCond.setDynRealm(key);
            return SearchCond.getLeaf((AbstractSearchCond)dynRealmCond);
        }).collect(Collectors.toList());
        if (!dynRealmConds.isEmpty()) {
            result.add(SearchCond.getOr(dynRealmConds));
        }
        if (!(groupOwnerConds = groupOwners.stream().map(key -> {
            MembershipCond asc;
            if (kind == AnyTypeKind.GROUP) {
                AnyCond anyCond = new AnyCond(AttrCond.Type.EQ);
                anyCond.setSchema("id");
                anyCond.setExpression(key);
                asc = anyCond;
            } else {
                MembershipCond membershipCond = new MembershipCond();
                membershipCond.setGroup(key);
                asc = membershipCond;
            }
            return SearchCond.getLeaf((AbstractSearchCond)asc);
        }).collect(Collectors.toList())).isEmpty()) {
            result.add(SearchCond.getOr(groupOwnerConds));
        }
        return SearchCond.getAnd(result);
    }

    protected abstract int doCount(Set<String> var1, SearchCond var2, AnyTypeKind var3);

    public int count(Set<String> adminRealms, SearchCond cond, AnyTypeKind kind) {
        if (adminRealms == null || adminRealms.isEmpty()) {
            LOG.error("No realms provided");
            return 0;
        }
        LOG.debug("Search condition:\n{}", (Object)cond);
        if (cond == null || !cond.isValid()) {
            LOG.error("Invalid search condition:\n{}", (Object)cond);
            return 0;
        }
        return this.doCount(adminRealms, cond, kind);
    }

    public <T extends Any<?>> List<T> search(SearchCond cond, AnyTypeKind kind) {
        return this.search(cond, Collections.emptyList(), kind);
    }

    public <T extends Any<?>> List<T> search(SearchCond cond, List<OrderByClause> orderBy, AnyTypeKind kind) {
        return this.search(SyncopeConstants.FULL_ADMIN_REALMS, cond, -1, -1, orderBy, kind);
    }

    protected abstract <T extends Any<?>> List<T> doSearch(Set<String> var1, SearchCond var2, int var3, int var4, List<OrderByClause> var5, AnyTypeKind var6);

    protected Pair<PlainSchema, PlainAttrValue> check(AttrCond cond, AnyTypeKind kind) {
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(kind);
        PlainSchema schema = (PlainSchema)this.schemaDAO.find(cond.getSchema());
        if (schema == null) {
            LOG.warn("Ignoring invalid schema '{}'", (Object)cond.getSchema());
            throw new IllegalArgumentException();
        }
        PlainAttrValue attrValue = schema.isUniqueConstraint() ? anyUtils.newPlainAttrUniqueValue() : anyUtils.newPlainAttrValue();
        try {
            if (cond.getType() != AttrCond.Type.LIKE && cond.getType() != AttrCond.Type.ILIKE && cond.getType() != AttrCond.Type.ISNULL && cond.getType() != AttrCond.Type.ISNOTNULL) {
                ((JPAPlainSchema)schema).validator().validate(cond.getExpression(), attrValue);
            }
        }
        catch (ValidationException e) {
            LOG.error("Could not validate expression '" + cond.getExpression() + "'", (Throwable)e);
            throw new IllegalArgumentException();
        }
        return Pair.of((Object)schema, (Object)attrValue);
    }

    protected Triple<PlainSchema, PlainAttrValue, AnyCond> check(AnyCond cond, AnyTypeKind kind) {
        AnyCond computed = new AnyCond(cond.getType());
        computed.setSchema(cond.getSchema());
        computed.setExpression(cond.getExpression());
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(kind);
        Field anyField = anyUtils.getField(computed.getSchema());
        if (anyField == null) {
            LOG.warn("Ignoring invalid field '{}'", (Object)computed.getSchema());
            throw new IllegalArgumentException();
        }
        if ("key".equals(computed.getSchema())) {
            computed.setSchema("id");
        }
        PlainSchema schema = (PlainSchema)this.entityFactory.newEntity(PlainSchema.class);
        schema.setKey(anyField.getName());
        for (AttrSchemaType attrSchemaType : AttrSchemaType.values()) {
            if (!anyField.getType().isAssignableFrom(attrSchemaType.getType())) continue;
            schema.setType(attrSchemaType);
        }
        boolean foundBooleanMin = false;
        boolean foundBooleanMax = false;
        if (Integer.class.equals(anyField.getType())) {
            for (Annotation annotation : anyField.getAnnotations()) {
                if (Min.class.equals(annotation.annotationType())) {
                    foundBooleanMin = ((Min)annotation).value() == 0L;
                    continue;
                }
                if (!Max.class.equals(annotation.annotationType())) continue;
                foundBooleanMax = ((Max)annotation).value() == 1L;
            }
        }
        if (foundBooleanMin && foundBooleanMax) {
            schema.setType(AttrSchemaType.Boolean);
        }
        if (ArrayUtils.contains((Object[])RELATIONSHIP_FIELDS, (Object)computed.getSchema())) {
            computed.setSchema(computed.getSchema() + "_id");
            schema.setType(AttrSchemaType.String);
        }
        PlainAttrValue attrValue = anyUtils.newPlainAttrValue();
        if (computed.getType() != AttrCond.Type.LIKE && computed.getType() != AttrCond.Type.ILIKE && computed.getType() != AttrCond.Type.ISNULL && computed.getType() != AttrCond.Type.ISNOTNULL) {
            try {
                ((JPAPlainSchema)schema).validator().validate(computed.getExpression(), attrValue);
            }
            catch (ValidationException e) {
                LOG.error("Could not validate expression '" + computed.getExpression() + "'", (Throwable)e);
                throw new IllegalArgumentException();
            }
        }
        return Triple.of((Object)schema, (Object)attrValue, (Object)computed);
    }

    protected List<String> check(MembershipCond cond) {
        List matching;
        if (SyncopeConstants.UUID_PATTERN.matcher(cond.getGroup()).matches()) {
            return Collections.singletonList(cond.getGroup());
        }
        List list = matching = cond.getGroup().indexOf(37) == -1 ? Optional.ofNullable(this.groupDAO.findKey(cond.getGroup())).map(Collections::singletonList).orElseGet(() -> Collections.emptyList()) : this.groupDAO.findKeysByNamePattern(cond.getGroup());
        if (matching.isEmpty()) {
            LOG.error("Could not find group(s) for '{}'", (Object)cond.getGroup());
            throw new IllegalArgumentException();
        }
        return matching;
    }

    protected String check(RelationshipCond cond) {
        String rightAnyObjectKey;
        if (SyncopeConstants.UUID_PATTERN.matcher(cond.getAnyObject()).matches()) {
            rightAnyObjectKey = cond.getAnyObject();
        } else {
            AnyObject anyObject = this.anyObjectDAO.findByName(cond.getAnyObject());
            String string = rightAnyObjectKey = anyObject == null ? null : anyObject.getKey();
        }
        if (rightAnyObjectKey == null) {
            LOG.error("Could not find any object for '" + cond.getAnyObject() + "'");
            throw new IllegalArgumentException();
        }
        return rightAnyObjectKey;
    }

    protected Realm check(AssignableCond cond) {
        Realm realm = this.realmDAO.findByFullPath(cond.getRealmFullPath());
        if (realm == null) {
            LOG.error("Could not find realm for '" + cond.getRealmFullPath() + "'");
            throw new IllegalArgumentException();
        }
        return realm;
    }

    protected String check(MemberCond cond) {
        String memberKey;
        if (SyncopeConstants.UUID_PATTERN.matcher(cond.getMember()).matches()) {
            memberKey = cond.getMember();
        } else {
            User member = this.userDAO.findByUsername(cond.getMember());
            if (member == null) {
                member = this.anyObjectDAO.findByName(cond.getMember());
            }
            String string = memberKey = member == null ? null : member.getKey();
        }
        if (memberKey == null) {
            LOG.error("Could not find user or any object for '" + cond.getMember() + "'");
            throw new IllegalArgumentException();
        }
        return memberKey;
    }

    protected <T extends Any<?>> List<T> buildResult(List<Object> raw, AnyTypeKind kind) {
        List keys = raw.stream().map(key -> key instanceof Object[] ? (String)((Object[])key)[0] : (String)key).collect(Collectors.toList());
        List anys = this.anyUtilsFactory.getInstance(kind).dao().findByKeys(keys).stream().sorted(Comparator.comparing(any -> keys.indexOf(any.getKey()))).collect(Collectors.toList());
        keys.stream().filter(key -> !anys.stream().anyMatch(any -> key.equals(any.getKey()))).forEach(key -> LOG.error("Could not find {} with id {}, even if returned by native query", (Object)kind, key));
        return anys;
    }

    public <T extends Any<?>> List<T> search(Set<String> adminRealms, SearchCond cond, int page, int itemsPerPage, List<OrderByClause> orderBy, AnyTypeKind kind) {
        List<OrderByClause> effectiveOrderBy;
        if (adminRealms == null || adminRealms.isEmpty()) {
            LOG.error("No realms provided");
            return Collections.emptyList();
        }
        LOG.debug("Search condition:\n{}", (Object)cond);
        if (cond == null || !cond.isValid()) {
            LOG.error("Invalid search condition:\n{}", (Object)cond);
            return Collections.emptyList();
        }
        if (orderBy.isEmpty()) {
            OrderByClause keyClause = new OrderByClause();
            keyClause.setField(kind == AnyTypeKind.USER ? "username" : "name");
            keyClause.setDirection(OrderByClause.Direction.ASC);
            effectiveOrderBy = Collections.singletonList(keyClause);
        } else {
            effectiveOrderBy = orderBy.stream().filter(clause -> !ArrayUtils.contains((Object[])ORDER_BY_NOT_ALLOWED, (Object)clause.getField())).collect(Collectors.toList());
        }
        return this.doSearch(adminRealms, cond, page, itemsPerPage, effectiveOrderBy, kind);
    }
}

