/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public final class RealmUtils {
    public static String getGroupOwnerRealm(String realmPath, String groupKey) {
        return realmPath + "@" + groupKey;
    }

    public static Optional<Pair<String, String>> parseGroupOwnerRealm(String input) {
        String[] split = input.split("@");
        return split == null || split.length < 2 ? Optional.empty() : Optional.of(Pair.of((Object)split[0], (Object)split[1]));
    }

    public static boolean normalizingAddTo(Set<String> realms, String newRealm) {
        boolean dontAdd = false;
        HashSet<String> toRemove = new HashSet<String>();
        for (String realm : realms) {
            if (newRealm.startsWith(realm)) {
                dontAdd = true;
                continue;
            }
            if (!realm.startsWith(newRealm)) continue;
            toRemove.add(realm);
        }
        realms.removeAll(toRemove);
        if (!dontAdd) {
            realms.add(newRealm);
        }
        return !dontAdd;
    }

    public static Pair<Set<String>, Set<String>> normalize(Collection<String> realms) {
        HashSet normalized = new HashSet();
        HashSet groupOwnership = new HashSet();
        if (realms != null) {
            realms.forEach(realm -> {
                if (realm.indexOf(64) == -1) {
                    RealmUtils.normalizingAddTo(normalized, realm);
                } else {
                    groupOwnership.add(realm);
                }
            });
        }
        return Pair.of(normalized, groupOwnership);
    }

    public static Set<String> getEffective(Set<String> allowedRealms, String requestedRealm) {
        Pair<Set<String>, Set<String>> normalized = RealmUtils.normalize(allowedRealms);
        List<String> requested = Arrays.asList(requestedRealm);
        HashSet<String> effective = new HashSet<String>();
        effective.addAll(requested.stream().filter(new StartsWithPredicate((Collection)normalized.getLeft())).collect(Collectors.toSet()));
        effective.addAll(((Set)normalized.getLeft()).stream().filter(new StartsWithPredicate(requested)).collect(Collectors.toSet()));
        effective.addAll((Collection)normalized.getRight());
        if (allowedRealms != null) {
            effective.addAll(allowedRealms.stream().filter(new DynRealmsPredicate()).collect(Collectors.toSet()));
        }
        return effective;
    }

    private RealmUtils() {
    }

    public static class DynRealmsPredicate
    implements Predicate<String> {
        @Override
        public boolean test(String realm) {
            return !realm.startsWith("/");
        }
    }

    private static class StartsWithPredicate
    implements Predicate<String> {
        private final Collection<String> targets;

        StartsWithPredicate(Collection<String> targets) {
            this.targets = targets;
        }

        @Override
        public boolean test(String realm) {
            return this.targets.stream().anyMatch(realm::startsWith);
        }
    }
}

