/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.task.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.query.CacheAwareQuery;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.persistence.cache.EntityCache;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.flowable.task.service.TaskServiceConfiguration;
import org.flowable.task.service.impl.HistoricTaskInstanceQueryProperty;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.AbstractVariableQueryImpl;
import org.flowable.variable.service.impl.QueryVariableValue;
import org.flowable.variable.service.impl.persistence.entity.HistoricVariableInstanceEntity;

public class HistoricTaskInstanceQueryImpl
extends AbstractVariableQueryImpl<HistoricTaskInstanceQuery, HistoricTaskInstance>
implements HistoricTaskInstanceQuery,
CacheAwareQuery<HistoricTaskInstanceEntity> {
    private static final long serialVersionUID = 1L;
    protected TaskServiceConfiguration taskServiceConfiguration;
    protected VariableServiceConfiguration variableServiceConfiguration;
    protected String taskDefinitionId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String processDefinitionKeyLike;
    protected String processDefinitionKeyLikeIgnoreCase;
    protected Collection<String> processDefinitionKeys;
    protected String processDefinitionName;
    protected String processDefinitionNameLike;
    protected Collection<String> processCategoryInList;
    protected Collection<String> processCategoryNotInList;
    protected String deploymentId;
    protected Collection<String> deploymentIds;
    protected String cmmnDeploymentId;
    protected Collection<String> cmmnDeploymentIds;
    protected String processInstanceId;
    protected Collection<String> processInstanceIds;
    protected String processInstanceBusinessKey;
    protected String processInstanceBusinessKeyLike;
    protected String processInstanceBusinessKeyLikeIgnoreCase;
    protected String executionId;
    protected String scopeId;
    protected String subScopeId;
    protected String scopeType;
    protected String scopeDefinitionId;
    protected String propagatedStageInstanceId;
    protected String processInstanceIdWithChildren;
    protected String caseInstanceIdWithChildren;
    protected String caseDefinitionKey;
    protected String caseDefinitionKeyLike;
    protected String caseDefinitionKeyLikeIgnoreCase;
    protected Collection<String> caseDefinitionKeys;
    protected String taskId;
    protected String taskName;
    protected String taskNameLike;
    protected String taskNameLikeIgnoreCase;
    protected Collection<String> taskNameList;
    protected Collection<String> taskNameListIgnoreCase;
    protected String taskParentTaskId;
    protected String taskDescription;
    protected String taskDescriptionLike;
    protected String taskDescriptionLikeIgnoreCase;
    protected String taskDeleteReason;
    protected String taskDeleteReasonLike;
    protected String taskOwner;
    protected String taskOwnerLike;
    protected String taskOwnerLikeIgnoreCase;
    protected String taskAssignee;
    protected String taskAssigneeLike;
    protected String taskAssigneeLikeIgnoreCase;
    protected boolean withAssignee;
    protected boolean withoutAssignee;
    protected Collection<String> taskAssigneeIds;
    protected String taskDefinitionKey;
    protected String taskDefinitionKeyLike;
    protected Collection<String> taskDefinitionKeys;
    protected String candidateUser;
    protected String candidateGroup;
    protected Collection<String> candidateGroups;
    private List<List<String>> safeCandidateGroups;
    protected String involvedUser;
    protected Collection<String> involvedGroups;
    private List<List<String>> safeInvolvedGroups;
    protected boolean ignoreAssigneeValue;
    protected Integer taskPriority;
    protected Integer taskMinPriority;
    protected Integer taskMaxPriority;
    protected boolean finished;
    protected boolean unfinished;
    protected boolean processFinished;
    protected boolean processUnfinished;
    protected Date dueDate;
    protected Date dueAfter;
    protected Date dueBefore;
    protected boolean withoutDueDate;
    protected Date creationDate;
    protected Date creationAfterDate;
    protected Date creationBeforeDate;
    protected Date completedDate;
    protected Date completedAfterDate;
    protected Date completedBeforeDate;
    protected String category;
    protected boolean withFormKey;
    protected String formKey;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected boolean withoutDeleteReason;
    protected String locale;
    protected boolean withLocalizationFallback;
    protected boolean includeTaskLocalVariables;
    protected boolean includeProcessVariables;
    protected boolean includeIdentityLinks;
    protected List<HistoricTaskInstanceQueryImpl> orQueryObjects = new ArrayList<HistoricTaskInstanceQueryImpl>();
    protected HistoricTaskInstanceQueryImpl currentOrQueryObject;
    protected boolean inOrStatement;

    public HistoricTaskInstanceQueryImpl() {
    }

    public HistoricTaskInstanceQueryImpl(CommandExecutor commandExecutor, TaskServiceConfiguration taskServiceConfiguration, VariableServiceConfiguration variableServiceConfiguration) {
        super(commandExecutor, variableServiceConfiguration);
        this.taskServiceConfiguration = taskServiceConfiguration;
        this.variableServiceConfiguration = variableServiceConfiguration;
    }

    public HistoricTaskInstanceQueryImpl(CommandExecutor commandExecutor, String databaseType, TaskServiceConfiguration taskServiceConfiguration, VariableServiceConfiguration variableServiceConfiguration) {
        super(commandExecutor, variableServiceConfiguration);
        this.databaseType = databaseType;
        this.taskServiceConfiguration = taskServiceConfiguration;
        this.variableServiceConfiguration = variableServiceConfiguration;
    }

    public long executeCount(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        if (this.taskServiceConfiguration.getHistoricTaskQueryInterceptor() != null) {
            this.taskServiceConfiguration.getHistoricTaskQueryInterceptor().beforeHistoricTaskQueryExecute((HistoricTaskInstanceQuery)this);
        }
        return this.taskServiceConfiguration.getHistoricTaskInstanceEntityManager().findHistoricTaskInstanceCountByQueryCriteria(this);
    }

    public List<HistoricTaskInstance> executeList(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        List<HistoricTaskInstance> tasks = null;
        if (this.taskServiceConfiguration.getHistoricTaskQueryInterceptor() != null) {
            this.taskServiceConfiguration.getHistoricTaskQueryInterceptor().beforeHistoricTaskQueryExecute((HistoricTaskInstanceQuery)this);
        }
        if (this.includeTaskLocalVariables || this.includeProcessVariables || this.includeIdentityLinks) {
            tasks = this.taskServiceConfiguration.getHistoricTaskInstanceEntityManager().findHistoricTaskInstancesAndRelatedEntitiesByQueryCriteria(this);
            if (this.taskId != null) {
                if (this.includeProcessVariables) {
                    this.addCachedVariableForQueryById(commandContext, tasks, false);
                } else if (this.includeTaskLocalVariables) {
                    this.addCachedVariableForQueryById(commandContext, tasks, true);
                }
            }
        } else {
            tasks = this.taskServiceConfiguration.getHistoricTaskInstanceEntityManager().findHistoricTaskInstancesByQueryCriteria(this);
        }
        if (tasks != null && this.taskServiceConfiguration.getInternalTaskLocalizationManager() != null && this.taskServiceConfiguration.isEnableLocalization()) {
            for (HistoricTaskInstance task : tasks) {
                this.taskServiceConfiguration.getInternalTaskLocalizationManager().localize(task, this.locale, this.withLocalizationFallback);
            }
        }
        if (this.taskServiceConfiguration.getHistoricTaskQueryInterceptor() != null) {
            this.taskServiceConfiguration.getHistoricTaskQueryInterceptor().afterHistoricTaskQueryExecute((HistoricTaskInstanceQuery)this, tasks);
        }
        return tasks;
    }

    protected void addCachedVariableForQueryById(CommandContext commandContext, List<HistoricTaskInstance> results, boolean local) {
        for (HistoricTaskInstance task : results) {
            if (!Objects.equals(this.taskId, task.getId())) continue;
            EntityCache entityCache = (EntityCache)commandContext.getSession(EntityCache.class);
            List cachedVariableEntities = entityCache.findInCache(HistoricVariableInstanceEntity.class);
            for (HistoricVariableInstanceEntity cachedVariableEntity : cachedVariableEntities) {
                if (local) {
                    if (!task.getId().equals(cachedVariableEntity.getTaskId())) continue;
                    ((HistoricTaskInstanceEntity)task).getQueryVariables().add(cachedVariableEntity);
                    continue;
                }
                if (!task.getProcessInstanceId().equals(cachedVariableEntity.getProcessInstanceId())) continue;
                ((HistoricTaskInstanceEntity)task).getQueryVariables().add(cachedVariableEntity);
            }
        }
    }

    public void enhanceCachedValue(HistoricTaskInstanceEntity task) {
        if (this.includeProcessVariables) {
            task.getQueryVariables().addAll(this.variableServiceConfiguration.getHistoricVariableInstanceEntityManager().findHistoricalVariableInstancesByProcessInstanceId(task.getProcessInstanceId()));
        } else if (this.includeTaskLocalVariables) {
            task.getQueryVariables().addAll(this.variableServiceConfiguration.getHistoricVariableInstanceEntityManager().findHistoricalVariableInstancesByTaskId(task.getId()));
        }
    }

    public HistoricTaskInstanceQueryImpl processInstanceId(String processInstanceId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.processInstanceId = processInstanceId;
        } else {
            this.processInstanceId = processInstanceId;
        }
        return this;
    }

    public HistoricTaskInstanceQueryImpl processInstanceIdIn(Collection<String> processInstanceIds) {
        if (processInstanceIds == null) {
            throw new FlowableIllegalArgumentException("Process instance id list is null");
        }
        if (processInstanceIds.isEmpty()) {
            throw new FlowableIllegalArgumentException("Process instance id list is empty");
        }
        for (String processInstanceId : processInstanceIds) {
            if (processInstanceId != null) continue;
            throw new FlowableIllegalArgumentException("None of the given process instance ids can be null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.processInstanceIds = processInstanceIds;
        } else {
            this.processInstanceIds = processInstanceIds;
        }
        return this;
    }

    public HistoricTaskInstanceQueryImpl processInstanceBusinessKey(String processInstanceBusinessKey) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.processInstanceBusinessKey = processInstanceBusinessKey;
        } else {
            this.processInstanceBusinessKey = processInstanceBusinessKey;
        }
        return this;
    }

    public HistoricTaskInstanceQueryImpl processInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
        } else {
            this.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
        }
        return this;
    }

    public HistoricTaskInstanceQuery processInstanceBusinessKeyLikeIgnoreCase(String processInstanceBusinessKeyLikeIgnoreCase) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.processInstanceBusinessKeyLikeIgnoreCase = processInstanceBusinessKeyLikeIgnoreCase.toLowerCase();
        } else {
            this.processInstanceBusinessKeyLikeIgnoreCase = processInstanceBusinessKeyLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    public HistoricTaskInstanceQueryImpl executionId(String executionId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.executionId = executionId;
        } else {
            this.executionId = executionId;
        }
        return this;
    }

    public HistoricTaskInstanceQueryImpl caseInstanceId(String caseInstanceId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.scopeId(caseInstanceId);
            this.currentOrQueryObject.scopeType("cmmn");
        } else {
            this.scopeId(caseInstanceId);
            this.scopeType("cmmn");
        }
        return this;
    }

    public HistoricTaskInstanceQueryImpl caseDefinitionId(String caseDefinitionId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.scopeDefinitionId(caseDefinitionId);
            this.currentOrQueryObject.scopeType("cmmn");
        } else {
            this.scopeDefinitionId(caseDefinitionId);
            this.scopeType("cmmn");
        }
        return this;
    }

    public HistoricTaskInstanceQueryImpl caseDefinitionKey(String caseDefinitionKey) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionKey = caseDefinitionKey;
        } else {
            this.caseDefinitionKey = caseDefinitionKey;
        }
        return this;
    }

    public HistoricTaskInstanceQueryImpl caseDefinitionKeyLike(String caseDefinitionKeyLike) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionKeyLike = caseDefinitionKeyLike;
        } else {
            this.caseDefinitionKeyLike = caseDefinitionKeyLike;
        }
        return this;
    }

    public HistoricTaskInstanceQueryImpl caseDefinitionKeyLikeIgnoreCase(String caseDefinitionKeyLikeIgnoreCase) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionKeyLikeIgnoreCase = caseDefinitionKeyLikeIgnoreCase;
        } else {
            this.caseDefinitionKeyLikeIgnoreCase = caseDefinitionKeyLikeIgnoreCase;
        }
        return this;
    }

    public HistoricTaskInstanceQueryImpl caseDefinitionKeyIn(Collection<String> caseDefinitionKeys) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionKeys = caseDefinitionKeys;
        } else {
            this.caseDefinitionKeys = caseDefinitionKeys;
        }
        return this;
    }

    public HistoricTaskInstanceQueryImpl processInstanceIdWithChildren(String processInstanceId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.processInstanceIdWithChildren(processInstanceId);
        } else {
            this.processInstanceIdWithChildren = processInstanceId;
        }
        return this;
    }

    public HistoricTaskInstanceQueryImpl caseInstanceIdWithChildren(String caseInstanceId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseInstanceIdWithChildren(caseInstanceId);
        } else {
            this.caseInstanceIdWithChildren = caseInstanceId;
        }
        return this;
    }

    public HistoricTaskInstanceQueryImpl planItemInstanceId(String planItemInstanceId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.subScopeId(planItemInstanceId);
            this.currentOrQueryObject.scopeType("cmmn");
        } else {
            this.subScopeId(planItemInstanceId);
            this.scopeType("cmmn");
        }
        return this;
    }

    public HistoricTaskInstanceQueryImpl scopeId(String scopeId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.scopeId = scopeId;
        } else {
            this.scopeId = scopeId;
        }
        return this;
    }

    public HistoricTaskInstanceQueryImpl subScopeId(String subScopeId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.subScopeId = subScopeId;
        } else {
            this.subScopeId = subScopeId;
        }
        return this;
    }

    public HistoricTaskInstanceQueryImpl scopeType(String scopeType) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.scopeType = scopeType;
        } else {
            this.scopeType = scopeType;
        }
        return this;
    }

    public HistoricTaskInstanceQueryImpl scopeDefinitionId(String scopeDefinitionId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.scopeDefinitionId = scopeDefinitionId;
        } else {
            this.scopeDefinitionId = scopeDefinitionId;
        }
        return this;
    }

    public HistoricTaskInstanceQuery propagatedStageInstanceId(String propagatedStageInstanceId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.propagatedStageInstanceId = propagatedStageInstanceId;
        } else {
            this.propagatedStageInstanceId = propagatedStageInstanceId;
        }
        return this;
    }

    public HistoricTaskInstanceQueryImpl taskDefinitionId(String taskDefinitionId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskDefinitionId = taskDefinitionId;
        } else {
            this.taskDefinitionId = taskDefinitionId;
        }
        return this;
    }

    public HistoricTaskInstanceQueryImpl processDefinitionId(String processDefinitionId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionId = processDefinitionId;
        } else {
            this.processDefinitionId = processDefinitionId;
        }
        return this;
    }

    public HistoricTaskInstanceQuery processDefinitionKey(String processDefinitionKey) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionKey = processDefinitionKey;
        } else {
            this.processDefinitionKey = processDefinitionKey;
        }
        return this;
    }

    public HistoricTaskInstanceQuery processDefinitionKeyLike(String processDefinitionKeyLike) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionKeyLike = processDefinitionKeyLike;
        } else {
            this.processDefinitionKeyLike = processDefinitionKeyLike;
        }
        return this;
    }

    public HistoricTaskInstanceQuery processDefinitionKeyLikeIgnoreCase(String processDefinitionKeyLikeIgnoreCase) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionKeyLikeIgnoreCase = processDefinitionKeyLikeIgnoreCase.toLowerCase();
        } else {
            this.processDefinitionKeyLikeIgnoreCase = processDefinitionKeyLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    public HistoricTaskInstanceQuery processDefinitionKeyIn(Collection<String> processDefinitionKeys) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionKeys = processDefinitionKeys;
        } else {
            this.processDefinitionKeys = processDefinitionKeys;
        }
        return this;
    }

    public HistoricTaskInstanceQuery processDefinitionName(String processDefinitionName) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionName = processDefinitionName;
        } else {
            this.processDefinitionName = processDefinitionName;
        }
        return this;
    }

    public HistoricTaskInstanceQuery processDefinitionNameLike(String processDefinitionNameLike) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionNameLike = processDefinitionNameLike;
        } else {
            this.processDefinitionNameLike = processDefinitionNameLike;
        }
        return this;
    }

    public HistoricTaskInstanceQuery processCategoryIn(Collection<String> processCategoryInList) {
        if (processCategoryInList == null) {
            throw new FlowableIllegalArgumentException("Process category list is null");
        }
        if (processCategoryInList.isEmpty()) {
            throw new FlowableIllegalArgumentException("Process category list is empty");
        }
        for (String processCategory : processCategoryInList) {
            if (processCategory != null) continue;
            throw new FlowableIllegalArgumentException("None of the given process categories can be null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.processCategoryInList = processCategoryInList;
        } else {
            this.processCategoryInList = processCategoryInList;
        }
        return this;
    }

    public HistoricTaskInstanceQuery processCategoryNotIn(Collection<String> processCategoryNotInList) {
        if (processCategoryNotInList == null) {
            throw new FlowableIllegalArgumentException("Process category list is null");
        }
        if (processCategoryNotInList.isEmpty()) {
            throw new FlowableIllegalArgumentException("Process category list is empty");
        }
        for (String processCategory : processCategoryNotInList) {
            if (processCategory != null) continue;
            throw new FlowableIllegalArgumentException("None of the given process categories can be null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.processCategoryNotInList = processCategoryNotInList;
        } else {
            this.processCategoryNotInList = processCategoryNotInList;
        }
        return this;
    }

    public HistoricTaskInstanceQuery deploymentId(String deploymentId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.deploymentId = deploymentId;
        } else {
            this.deploymentId = deploymentId;
        }
        return this;
    }

    public HistoricTaskInstanceQuery deploymentIdIn(Collection<String> deploymentIds) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.deploymentIds = deploymentIds;
        } else {
            this.deploymentIds = deploymentIds;
        }
        return this;
    }

    public HistoricTaskInstanceQuery cmmnDeploymentId(String cmmnDeploymentId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.cmmnDeploymentId = cmmnDeploymentId;
        } else {
            this.cmmnDeploymentId = cmmnDeploymentId;
        }
        return this;
    }

    public HistoricTaskInstanceQuery cmmnDeploymentIdIn(Collection<String> cmmnDeploymentIds) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.cmmnDeploymentIds = cmmnDeploymentIds;
        } else {
            this.cmmnDeploymentIds = cmmnDeploymentIds;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskId(String taskId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskId = taskId;
        } else {
            this.taskId = taskId;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskName(String taskName) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskName = taskName;
        } else {
            this.taskName = taskName;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskNameIn(Collection<String> taskNameList) {
        if (taskNameList == null) {
            throw new FlowableIllegalArgumentException("Task name list is null");
        }
        if (taskNameList.isEmpty()) {
            throw new FlowableIllegalArgumentException("Task name list is empty");
        }
        if (this.taskName != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set both taskNameIn and taskName");
        }
        if (this.taskNameLike != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set both taskNameIn and taskNameLike");
        }
        if (this.taskNameLikeIgnoreCase != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set both taskNameIn and taskNameLikeIgnoreCase");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskNameList = taskNameList;
        } else {
            this.taskNameList = taskNameList;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskNameInIgnoreCase(Collection<String> taskNameList) {
        if (taskNameList == null) {
            throw new FlowableIllegalArgumentException("Task name list is null");
        }
        if (taskNameList.isEmpty()) {
            throw new FlowableIllegalArgumentException("Task name list is empty");
        }
        for (String taskName : taskNameList) {
            if (taskName != null) continue;
            throw new FlowableIllegalArgumentException("None of the given task names can be null");
        }
        if (this.taskName != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set both taskNameInIgnoreCase and name");
        }
        if (this.taskNameLike != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set both taskNameInIgnoreCase and nameLike");
        }
        if (this.taskNameLikeIgnoreCase != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set both taskNameInIgnoreCase and nameLikeIgnoreCase");
        }
        int nameListSize = taskNameList.size();
        ArrayList<String> caseIgnoredTaskNameList = new ArrayList<String>(nameListSize);
        for (String taskName : taskNameList) {
            caseIgnoredTaskNameList.add(taskName.toLowerCase());
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskNameListIgnoreCase = caseIgnoredTaskNameList;
        } else {
            this.taskNameListIgnoreCase = caseIgnoredTaskNameList;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskNameLike(String taskNameLike) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskNameLike = taskNameLike;
        } else {
            this.taskNameLike = taskNameLike;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskNameLikeIgnoreCase(String taskNameLikeIgnoreCase) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskNameLikeIgnoreCase = taskNameLikeIgnoreCase.toLowerCase();
        } else {
            this.taskNameLikeIgnoreCase = taskNameLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskParentTaskId(String parentTaskId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskParentTaskId = parentTaskId;
        } else {
            this.taskParentTaskId = parentTaskId;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskDescription(String taskDescription) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskDescription = taskDescription;
        } else {
            this.taskDescription = taskDescription;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskDescriptionLike(String taskDescriptionLike) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskDescriptionLike = taskDescriptionLike;
        } else {
            this.taskDescriptionLike = taskDescriptionLike;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskDescriptionLikeIgnoreCase(String taskDescriptionLikeIgnoreCase) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskDescriptionLikeIgnoreCase = taskDescriptionLikeIgnoreCase.toLowerCase();
        } else {
            this.taskDescriptionLikeIgnoreCase = taskDescriptionLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskDeleteReason(String taskDeleteReason) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskDeleteReason = taskDeleteReason;
        } else {
            this.taskDeleteReason = taskDeleteReason;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskDeleteReasonLike(String taskDeleteReasonLike) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskDeleteReasonLike = taskDeleteReasonLike;
        } else {
            this.taskDeleteReasonLike = taskDeleteReasonLike;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskAssignee(String taskAssignee) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskAssignee = taskAssignee;
        } else {
            this.taskAssignee = taskAssignee;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskAssigneeLike(String taskAssigneeLike) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskAssigneeLike = taskAssigneeLike;
        } else {
            this.taskAssigneeLike = taskAssigneeLike;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskAssigneeLikeIgnoreCase(String taskAssigneeLikeIgnoreCase) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskAssigneeLikeIgnoreCase = taskAssigneeLikeIgnoreCase.toLowerCase();
        } else {
            this.taskAssigneeLikeIgnoreCase = taskAssigneeLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskUnassigned() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.withoutAssignee = true;
        } else {
            this.withoutAssignee = true;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskAssigned() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.withAssignee = true;
        } else {
            this.withAssignee = true;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskAssigneeIds(Collection<String> assigneeIds) {
        if (assigneeIds == null) {
            throw new FlowableIllegalArgumentException("Task assignee list is null");
        }
        if (assigneeIds.isEmpty()) {
            throw new FlowableIllegalArgumentException("Task assignee list is empty");
        }
        for (String assignee : assigneeIds) {
            if (assignee != null) continue;
            throw new FlowableIllegalArgumentException("None of the given task assignees can be null");
        }
        if (this.taskAssignee != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set both taskAssigneeIds and taskAssignee");
        }
        if (this.taskAssigneeLike != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set both taskAssigneeIds and taskAssigneeLike");
        }
        if (this.taskAssigneeLikeIgnoreCase != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set both taskAssigneeIds and taskAssigneeLikeIgnoreCase");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskAssigneeIds = assigneeIds;
        } else {
            this.taskAssigneeIds = assigneeIds;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskOwner(String taskOwner) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskOwner = taskOwner;
        } else {
            this.taskOwner = taskOwner;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskOwnerLike(String taskOwnerLike) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskOwnerLike = taskOwnerLike;
        } else {
            this.taskOwnerLike = taskOwnerLike;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskOwnerLikeIgnoreCase(String taskOwnerLikeIgnoreCase) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskOwnerLikeIgnoreCase = taskOwnerLikeIgnoreCase.toLowerCase();
        } else {
            this.taskOwnerLikeIgnoreCase = taskOwnerLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    public HistoricTaskInstanceQuery finished() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.finished = true;
        } else {
            this.finished = true;
        }
        return this;
    }

    public HistoricTaskInstanceQuery unfinished() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.unfinished = true;
        } else {
            this.unfinished = true;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskVariableValueEquals(String variableName, Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEquals(variableName, variableValue);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueEquals(variableName, variableValue);
    }

    public HistoricTaskInstanceQuery taskVariableValueEquals(Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEquals(variableValue);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueEquals(variableValue);
    }

    public HistoricTaskInstanceQuery taskVariableValueEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEqualsIgnoreCase(name, value);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueEqualsIgnoreCase(name, value);
    }

    public HistoricTaskInstanceQuery taskVariableValueNotEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueNotEqualsIgnoreCase(name, value);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueNotEqualsIgnoreCase(name, value);
    }

    public HistoricTaskInstanceQuery taskVariableValueNotEquals(String variableName, Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueNotEquals(variableName, variableValue);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueNotEquals(variableName, variableValue);
    }

    public HistoricTaskInstanceQuery taskVariableValueGreaterThan(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueGreaterThan(name, value);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueGreaterThan(name, value);
    }

    public HistoricTaskInstanceQuery taskVariableValueGreaterThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueGreaterThanOrEqual(name, value);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueGreaterThanOrEqual(name, value);
    }

    public HistoricTaskInstanceQuery taskVariableValueLessThan(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLessThan(name, value);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueLessThan(name, value);
    }

    public HistoricTaskInstanceQuery taskVariableValueLessThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLessThanOrEqual(name, value);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueLessThanOrEqual(name, value);
    }

    public HistoricTaskInstanceQuery taskVariableValueLike(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLike(name, value);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueLike(name, value);
    }

    public HistoricTaskInstanceQuery taskVariableValueLikeIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLikeIgnoreCase(name, value, true);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueLikeIgnoreCase(name, value, true);
    }

    public HistoricTaskInstanceQuery taskVariableExists(String name) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableExists(name, true);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableExists(name, true);
    }

    public HistoricTaskInstanceQuery taskVariableNotExists(String name) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableNotExists(name, true);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableNotExists(name, true);
    }

    public HistoricTaskInstanceQuery processVariableValueEquals(String variableName, Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEquals(variableName, variableValue, false);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueEquals(variableName, variableValue, false);
    }

    public HistoricTaskInstanceQuery processVariableValueNotEquals(String variableName, Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueNotEquals(variableName, variableValue, false);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueNotEquals(variableName, variableValue, false);
    }

    public HistoricTaskInstanceQuery processVariableValueEquals(Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEquals(variableValue, false);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueEquals(variableValue, false);
    }

    public HistoricTaskInstanceQuery processVariableValueEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEqualsIgnoreCase(name, value, false);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueEqualsIgnoreCase(name, value, false);
    }

    public HistoricTaskInstanceQuery processVariableValueNotEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueNotEqualsIgnoreCase(name, value, false);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueNotEqualsIgnoreCase(name, value, false);
    }

    public HistoricTaskInstanceQuery processVariableValueGreaterThan(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueGreaterThan(name, value, false);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueGreaterThan(name, value, false);
    }

    public HistoricTaskInstanceQuery processVariableValueGreaterThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueGreaterThanOrEqual(name, value, false);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueGreaterThanOrEqual(name, value, false);
    }

    public HistoricTaskInstanceQuery processVariableValueLessThan(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLessThan(name, value, false);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueLessThan(name, value, false);
    }

    public HistoricTaskInstanceQuery processVariableValueLessThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLessThanOrEqual(name, value, false);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueLessThanOrEqual(name, value, false);
    }

    public HistoricTaskInstanceQuery processVariableValueLike(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLike(name, value, false);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueLike(name, value, false);
    }

    public HistoricTaskInstanceQuery processVariableValueLikeIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLikeIgnoreCase(name, value, false);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueLikeIgnoreCase(name, value, false);
    }

    public HistoricTaskInstanceQuery processVariableExists(String name) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableExists(name, false);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableExists(name, false);
    }

    public HistoricTaskInstanceQuery processVariableNotExists(String name) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableNotExists(name, false);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableNotExists(name, false);
    }

    public HistoricTaskInstanceQuery taskDefinitionKey(String taskDefinitionKey) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskDefinitionKey = taskDefinitionKey;
        } else {
            this.taskDefinitionKey = taskDefinitionKey;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskDefinitionKeyLike(String taskDefinitionKeyLike) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskDefinitionKeyLike = taskDefinitionKeyLike;
        } else {
            this.taskDefinitionKeyLike = taskDefinitionKeyLike;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskDefinitionKeys(Collection<String> taskDefinitionKeys) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskDefinitionKeys = taskDefinitionKeys;
        } else {
            this.taskDefinitionKeys = taskDefinitionKeys;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskPriority(Integer taskPriority) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskPriority = taskPriority;
        } else {
            this.taskPriority = taskPriority;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskMinPriority(Integer taskMinPriority) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskMinPriority = taskMinPriority;
        } else {
            this.taskMinPriority = taskMinPriority;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskMaxPriority(Integer taskMaxPriority) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.taskMaxPriority = taskMaxPriority;
        } else {
            this.taskMaxPriority = taskMaxPriority;
        }
        return this;
    }

    public HistoricTaskInstanceQuery processFinished() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.processFinished = true;
        } else {
            this.processFinished = true;
        }
        return this;
    }

    public HistoricTaskInstanceQuery processUnfinished() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.processUnfinished = true;
        } else {
            this.processUnfinished = true;
        }
        return this;
    }

    protected void ensureVariablesInitialized() {
        for (QueryVariableValue var : this.queryVariableValues) {
            var.initialize(this.variableServiceConfiguration);
        }
        for (HistoricTaskInstanceQueryImpl orQueryObject : this.orQueryObjects) {
            orQueryObject.ensureVariablesInitialized();
        }
    }

    public HistoricTaskInstanceQuery taskDueDate(Date dueDate) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.dueDate = dueDate;
        } else {
            this.dueDate = dueDate;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskDueAfter(Date dueAfter) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.dueAfter = dueAfter;
        } else {
            this.dueAfter = dueAfter;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskDueBefore(Date dueBefore) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.dueBefore = dueBefore;
        } else {
            this.dueBefore = dueBefore;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskCreatedOn(Date creationDate) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.creationDate = creationDate;
        } else {
            this.creationDate = creationDate;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskCreatedBefore(Date creationBeforeDate) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.creationBeforeDate = creationBeforeDate;
        } else {
            this.creationBeforeDate = creationBeforeDate;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskCreatedAfter(Date creationAfterDate) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.creationAfterDate = creationAfterDate;
        } else {
            this.creationAfterDate = creationAfterDate;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskCompletedOn(Date completedDate) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.completedDate = completedDate;
        } else {
            this.completedDate = completedDate;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskCompletedBefore(Date completedBeforeDate) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.completedBeforeDate = completedBeforeDate;
        } else {
            this.completedBeforeDate = completedBeforeDate;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskCompletedAfter(Date completedAfterDate) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.completedAfterDate = completedAfterDate;
        } else {
            this.completedAfterDate = completedAfterDate;
        }
        return this;
    }

    public HistoricTaskInstanceQuery withoutTaskDueDate() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.withoutDueDate = true;
        } else {
            this.withoutDueDate = true;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskCategory(String category) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.category = category;
        } else {
            this.category = category;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskWithFormKey() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.withFormKey = true;
        } else {
            this.withFormKey = true;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskFormKey(String formKey) {
        if (formKey == null) {
            throw new FlowableIllegalArgumentException("Task formKey is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.formKey = formKey;
        } else {
            this.formKey = formKey;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskCandidateUser(String candidateUser) {
        if (candidateUser == null) {
            throw new FlowableIllegalArgumentException("Candidate user is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.candidateUser = candidateUser;
        } else {
            this.candidateUser = candidateUser;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskCandidateGroup(String candidateGroup) {
        if (candidateGroup == null) {
            throw new FlowableIllegalArgumentException("Candidate group is null");
        }
        if (this.candidateGroups != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set both candidateGroup and candidateGroupIn");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.candidateGroup = candidateGroup;
        } else {
            this.candidateGroup = candidateGroup;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskCandidateGroupIn(Collection<String> candidateGroups) {
        if (candidateGroups == null) {
            throw new FlowableIllegalArgumentException("Candidate group list is null");
        }
        if (candidateGroups.isEmpty()) {
            throw new FlowableIllegalArgumentException("Candidate group list is empty");
        }
        if (this.candidateGroup != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set both candidateGroupIn and candidateGroup");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.candidateGroups = candidateGroups;
        } else {
            this.candidateGroups = candidateGroups;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskInvolvedUser(String involvedUser) {
        if (involvedUser == null) {
            throw new FlowableIllegalArgumentException("involved user is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.involvedUser = involvedUser;
        } else {
            this.involvedUser = involvedUser;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskInvolvedGroups(Collection<String> involvedGroups) {
        if (involvedGroups == null) {
            throw new FlowableIllegalArgumentException("Involved groups are null");
        }
        if (involvedGroups.isEmpty()) {
            throw new FlowableIllegalArgumentException("Involved groups are empty");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.involvedGroups = involvedGroups;
        } else {
            this.involvedGroups = involvedGroups;
        }
        return this;
    }

    public HistoricTaskInstanceQuery ignoreAssigneeValue() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.ignoreAssigneeValue = true;
        } else {
            this.ignoreAssigneeValue = true;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("task tenant id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.tenantId = tenantId;
        } else {
            this.tenantId = tenantId;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new FlowableIllegalArgumentException("task tenant id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.tenantIdLike = tenantIdLike;
        } else {
            this.tenantIdLike = tenantIdLike;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskWithoutTenantId() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.withoutTenantId = true;
        } else {
            this.withoutTenantId = true;
        }
        return this;
    }

    public HistoricTaskInstanceQuery taskWithoutDeleteReason() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.withoutDeleteReason = true;
        } else {
            this.withoutDeleteReason = true;
        }
        return this;
    }

    public HistoricTaskInstanceQuery locale(String locale) {
        this.locale = locale;
        return this;
    }

    public HistoricTaskInstanceQuery withLocalizationFallback() {
        this.withLocalizationFallback = true;
        return this;
    }

    public HistoricTaskInstanceQuery includeTaskLocalVariables() {
        this.includeTaskLocalVariables = true;
        return this;
    }

    public HistoricTaskInstanceQuery includeProcessVariables() {
        this.includeProcessVariables = true;
        return this;
    }

    public HistoricTaskInstanceQuery limitTaskVariables(Integer taskVariablesLimit) {
        return this;
    }

    public HistoricTaskInstanceQuery includeIdentityLinks() {
        this.includeIdentityLinks = true;
        return this;
    }

    public HistoricTaskInstanceQuery or() {
        if (this.inOrStatement) {
            throw new FlowableException("the query is already in an or statement");
        }
        this.inOrStatement = true;
        this.currentOrQueryObject = this.databaseType != null ? new HistoricTaskInstanceQueryImpl(this.commandExecutor, this.databaseType, this.taskServiceConfiguration, this.variableServiceConfiguration) : new HistoricTaskInstanceQueryImpl(this.commandExecutor, this.taskServiceConfiguration, this.variableServiceConfiguration);
        this.orQueryObjects.add(this.currentOrQueryObject);
        return this;
    }

    public HistoricTaskInstanceQuery endOr() {
        if (!this.inOrStatement) {
            throw new FlowableException("endOr() can only be called after calling or()");
        }
        this.inOrStatement = false;
        this.currentOrQueryObject = null;
        return this;
    }

    public HistoricTaskInstanceQueryImpl orderByTaskId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.HISTORIC_TASK_INSTANCE_ID);
        return this;
    }

    public HistoricTaskInstanceQueryImpl orderByHistoricActivityInstanceId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.PROCESS_DEFINITION_ID);
        return this;
    }

    public HistoricTaskInstanceQueryImpl orderByProcessDefinitionId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.PROCESS_DEFINITION_ID);
        return this;
    }

    public HistoricTaskInstanceQueryImpl orderByProcessInstanceId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.PROCESS_INSTANCE_ID);
        return this;
    }

    public HistoricTaskInstanceQueryImpl orderByExecutionId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.EXECUTION_ID);
        return this;
    }

    public HistoricTaskInstanceQueryImpl orderByHistoricTaskInstanceDuration() {
        this.orderBy(HistoricTaskInstanceQueryProperty.DURATION);
        return this;
    }

    public HistoricTaskInstanceQueryImpl orderByHistoricTaskInstanceEndTime() {
        this.orderBy(HistoricTaskInstanceQueryProperty.END);
        return this;
    }

    public HistoricTaskInstanceQueryImpl orderByHistoricActivityInstanceStartTime() {
        this.orderBy(HistoricTaskInstanceQueryProperty.START);
        return this;
    }

    public HistoricTaskInstanceQuery orderByHistoricTaskInstanceStartTime() {
        this.orderBy(HistoricTaskInstanceQueryProperty.START);
        return this;
    }

    public HistoricTaskInstanceQuery orderByTaskCreateTime() {
        return this.orderByHistoricTaskInstanceStartTime();
    }

    public HistoricTaskInstanceQueryImpl orderByTaskName() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_NAME);
        return this;
    }

    public HistoricTaskInstanceQueryImpl orderByTaskDescription() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_DESCRIPTION);
        return this;
    }

    public HistoricTaskInstanceQuery orderByTaskAssignee() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_ASSIGNEE);
        return this;
    }

    public HistoricTaskInstanceQuery orderByTaskOwner() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_OWNER);
        return this;
    }

    public HistoricTaskInstanceQuery orderByTaskDueDate() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_DUE_DATE);
        return this;
    }

    public HistoricTaskInstanceQuery orderByDueDateNullsFirst() {
        return (HistoricTaskInstanceQuery)this.orderBy(HistoricTaskInstanceQueryProperty.TASK_DUE_DATE, Query.NullHandlingOnOrder.NULLS_FIRST);
    }

    public HistoricTaskInstanceQuery orderByDueDateNullsLast() {
        return (HistoricTaskInstanceQuery)this.orderBy(HistoricTaskInstanceQueryProperty.TASK_DUE_DATE, Query.NullHandlingOnOrder.NULLS_LAST);
    }

    public HistoricTaskInstanceQuery orderByCategory() {
        this.orderBy(HistoricTaskInstanceQueryProperty.CATEGORY);
        return this;
    }

    public HistoricTaskInstanceQueryImpl orderByDeleteReason() {
        this.orderBy(HistoricTaskInstanceQueryProperty.DELETE_REASON);
        return this;
    }

    public HistoricTaskInstanceQuery orderByTaskDefinitionKey() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_DEFINITION_KEY);
        return this;
    }

    public HistoricTaskInstanceQuery orderByTaskPriority() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_PRIORITY);
        return this;
    }

    public HistoricTaskInstanceQuery orderByTenantId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TENANT_ID_);
        return this;
    }

    public Collection<String> getCandidateGroups() {
        if (this.candidateGroup != null) {
            ArrayList<String> candidateGroupList = new ArrayList<String>(1);
            candidateGroupList.add(this.candidateGroup);
            return candidateGroupList;
        }
        if (this.candidateGroups != null) {
            return this.candidateGroups;
        }
        if (this.candidateUser != null) {
            return this.getGroupsForCandidateUser(this.candidateUser);
        }
        return null;
    }

    protected Collection<String> getGroupsForCandidateUser(String candidateUser) {
        ArrayList<String> groupIds = new ArrayList<String>();
        IdmIdentityService idmIdentityService = this.taskServiceConfiguration.getIdmIdentityService();
        if (idmIdentityService != null) {
            List groups = idmIdentityService.createGroupQuery().groupMember(candidateUser).list();
            for (Group group : groups) {
                groupIds.add(group.getId());
            }
        }
        return groupIds;
    }

    public void delete() {
        if (this.commandExecutor != null) {
            this.commandExecutor.execute(context -> {
                this.taskServiceConfiguration.getHistoricTaskInstanceEntityManager().deleteHistoricTaskInstances(this);
                return null;
            });
        } else {
            this.taskServiceConfiguration.getHistoricTaskInstanceEntityManager().deleteHistoricTaskInstances(this);
        }
    }

    public void deleteWithRelatedData() {
        this.delete();
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public Collection<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public String getProcessInstanceBusinessKey() {
        return this.processInstanceBusinessKey;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public String getSubScopeId() {
        return this.subScopeId;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public String getScopeDefinitionId() {
        return this.scopeDefinitionId;
    }

    public String getPropagatedStageInstanceId() {
        return this.propagatedStageInstanceId;
    }

    public String getTaskDefinitionId() {
        return this.taskDefinitionId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionKeyLike() {
        return this.processDefinitionKeyLike;
    }

    public Collection<String> getProcessDefinitionKeys() {
        return this.processDefinitionKeys;
    }

    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public String getProcessDefinitionNameLike() {
        return this.processDefinitionNameLike;
    }

    public Collection<String> getProcessCategoryInList() {
        return this.processCategoryInList;
    }

    public Collection<String> getProcessCategoryNotInList() {
        return this.processCategoryNotInList;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public Collection<String> getDeploymentIds() {
        return this.deploymentIds;
    }

    public String getCmmnDeploymentId() {
        return this.cmmnDeploymentId;
    }

    public Collection<String> getCmmnDeploymentIds() {
        return this.cmmnDeploymentIds;
    }

    public String getProcessInstanceBusinessKeyLike() {
        return this.processInstanceBusinessKeyLike;
    }

    public String getTaskDefinitionKeyLike() {
        return this.taskDefinitionKeyLike;
    }

    public String getProcessInstanceIdWithChildren() {
        return this.processInstanceIdWithChildren;
    }

    public String getCaseInstanceIdWithChildren() {
        return this.caseInstanceIdWithChildren;
    }

    public Integer getTaskPriority() {
        return this.taskPriority;
    }

    public Integer getTaskMinPriority() {
        return this.taskMinPriority;
    }

    public Integer getTaskMaxPriority() {
        return this.taskMaxPriority;
    }

    public boolean isProcessFinished() {
        return this.processFinished;
    }

    public boolean isProcessUnfinished() {
        return this.processUnfinished;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public Date getDueAfter() {
        return this.dueAfter;
    }

    public Date getDueBefore() {
        return this.dueBefore;
    }

    public boolean isWithoutDueDate() {
        return this.withoutDueDate;
    }

    public Date getCreationAfterDate() {
        return this.creationAfterDate;
    }

    public Date getCreationBeforeDate() {
        return this.creationBeforeDate;
    }

    public Date getCompletedDate() {
        return this.completedDate;
    }

    public Date getCompletedAfterDate() {
        return this.completedAfterDate;
    }

    public Date getCompletedBeforeDate() {
        return this.completedBeforeDate;
    }

    public String getCategory() {
        return this.category;
    }

    public boolean isWithFormKey() {
        return this.withFormKey;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public boolean isIncludeTaskLocalVariables() {
        return this.includeTaskLocalVariables;
    }

    public boolean isIncludeProcessVariables() {
        return this.includeProcessVariables;
    }

    public boolean isIncludeIdentityLinks() {
        return this.includeIdentityLinks;
    }

    public boolean isInOrStatement() {
        return this.inOrStatement;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isUnfinished() {
        return this.unfinished;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskNameLike() {
        return this.taskNameLike;
    }

    public Collection<String> getTaskNameList() {
        return this.taskNameList;
    }

    public Collection<String> getTaskNameListIgnoreCase() {
        return this.taskNameListIgnoreCase;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public String getTaskDescriptionLike() {
        return this.taskDescriptionLike;
    }

    public String getTaskDeleteReason() {
        return this.taskDeleteReason;
    }

    public String getTaskDeleteReasonLike() {
        return this.taskDeleteReasonLike;
    }

    public String getTaskAssignee() {
        return this.taskAssignee;
    }

    public String getTaskAssigneeLike() {
        return this.taskAssigneeLike;
    }

    public boolean isWithAssignee() {
        return this.withAssignee;
    }

    public boolean isWithoutAssignee() {
        return this.withoutAssignee;
    }

    public Collection<String> getTaskAssigneeIds() {
        return this.taskAssigneeIds;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getId() {
        return this.taskId;
    }

    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    public String getTaskOwnerLike() {
        return this.taskOwnerLike;
    }

    public String getTaskOwner() {
        return this.taskOwner;
    }

    public Collection<String> getTaskDefinitionKeys() {
        return this.taskDefinitionKeys;
    }

    public String getTaskParentTaskId() {
        return this.taskParentTaskId;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getCandidateUser() {
        return this.candidateUser;
    }

    public String getCandidateGroup() {
        return this.candidateGroup;
    }

    public String getInvolvedUser() {
        return this.involvedUser;
    }

    public Collection<String> getInvolvedGroups() {
        return this.involvedGroups;
    }

    public boolean isIgnoreAssigneeValue() {
        return this.ignoreAssigneeValue;
    }

    public String getProcessDefinitionKeyLikeIgnoreCase() {
        return this.processDefinitionKeyLikeIgnoreCase;
    }

    public String getProcessInstanceBusinessKeyLikeIgnoreCase() {
        return this.processInstanceBusinessKeyLikeIgnoreCase;
    }

    public String getTaskNameLikeIgnoreCase() {
        return this.taskNameLikeIgnoreCase;
    }

    public String getTaskDescriptionLikeIgnoreCase() {
        return this.taskDescriptionLikeIgnoreCase;
    }

    public String getTaskOwnerLikeIgnoreCase() {
        return this.taskOwnerLikeIgnoreCase;
    }

    public String getTaskAssigneeLikeIgnoreCase() {
        return this.taskAssigneeLikeIgnoreCase;
    }

    public boolean isWithoutDeleteReason() {
        return this.withoutDeleteReason;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public String getCaseDefinitionKeyLike() {
        return this.caseDefinitionKeyLike;
    }

    public String getCaseDefinitionKeyLikeIgnoreCase() {
        return this.caseDefinitionKeyLikeIgnoreCase;
    }

    public Collection<String> getCaseDefinitionKeys() {
        return this.caseDefinitionKeys;
    }

    public boolean isWithLocalizationFallback() {
        return this.withLocalizationFallback;
    }

    public List<HistoricTaskInstanceQueryImpl> getOrQueryObjects() {
        return this.orQueryObjects;
    }

    public List<List<String>> getSafeCandidateGroups() {
        return this.safeCandidateGroups;
    }

    public void setSafeCandidateGroups(List<List<String>> safeCandidateGroups) {
        this.safeCandidateGroups = safeCandidateGroups;
    }

    public List<List<String>> getSafeInvolvedGroups() {
        return this.safeInvolvedGroups;
    }

    public void setSafeInvolvedGroups(List<List<String>> safeInvolvedGroups) {
        this.safeInvolvedGroups = safeInvolvedGroups;
    }
}

