/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.persistence.entity.data.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.flowable.common.engine.impl.Direction;
import org.flowable.common.engine.impl.Page;
import org.flowable.common.engine.impl.cfg.IdGenerator;
import org.flowable.common.engine.impl.db.AbstractDataManager;
import org.flowable.common.engine.impl.db.ListQueryParameterObject;
import org.flowable.job.api.HistoryJob;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.HistoryJobQueryImpl;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntityImpl;
import org.flowable.job.service.impl.persistence.entity.data.HistoryJobDataManager;

public class MybatisHistoryJobDataManager
extends AbstractDataManager<HistoryJobEntity>
implements HistoryJobDataManager {
    protected JobServiceConfiguration jobServiceConfiguration;

    public MybatisHistoryJobDataManager(JobServiceConfiguration jobServiceConfiguration) {
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public Class<? extends HistoryJobEntity> getManagedEntityClass() {
        return HistoryJobEntityImpl.class;
    }

    public HistoryJobEntity create() {
        return new HistoryJobEntityImpl();
    }

    @Override
    public List<HistoryJobEntity> findJobsToExecute(List<String> enabledCategories, Page page) {
        ListQueryParameterObject params = new ListQueryParameterObject();
        params.setParameter((Object)this.jobServiceConfiguration.getHistoryJobExecutionScope());
        params.setFirstResult(page.getFirstResult());
        params.setMaxResults(page.getMaxResults());
        params.addOrder("CREATE_TIME_", Direction.ASCENDING.getName(), null);
        return this.getDbSqlSession().selectList("selectHistoryJobsToExecute", params);
    }

    @Override
    public List<HistoryJobEntity> findJobsByExecutionId(String executionId) {
        return this.getDbSqlSession().selectList("selectHistoryJobsByExecutionId", (Object)executionId);
    }

    @Override
    public List<HistoryJobEntity> findJobsByProcessInstanceId(String processInstanceId) {
        return this.getDbSqlSession().selectList("selectHistoryJobsByProcessInstanceId", (Object)processInstanceId);
    }

    @Override
    public List<HistoryJobEntity> findExpiredJobs(List<String> enabledCategories, Page page) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("jobExecutionScope", this.jobServiceConfiguration.getHistoryJobExecutionScope());
        Date now = this.jobServiceConfiguration.getClock().getCurrentTime();
        params.put("now", now);
        Date maxTimeout = new Date(now.getTime() - (long)this.jobServiceConfiguration.getAsyncExecutorResetExpiredJobsMaxTimeout());
        params.put("maxTimeout", maxTimeout);
        return this.getDbSqlSession().selectList("selectExpiredHistoryJobs", params, page);
    }

    @Override
    public List<HistoryJob> findHistoryJobsByQueryCriteria(HistoryJobQueryImpl jobQuery) {
        String query = "selectHistoryJobByQueryCriteria";
        return this.getDbSqlSession().selectList("selectHistoryJobByQueryCriteria", (ListQueryParameterObject)jobQuery);
    }

    @Override
    public long findHistoryJobCountByQueryCriteria(HistoryJobQueryImpl jobQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectHistoryJobCountByQueryCriteria", (Object)jobQuery);
    }

    @Override
    public void updateJobTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().update("updateHistoryJobTenantIdForDeployment", params);
    }

    @Override
    public void bulkUpdateJobLockWithoutRevisionCheck(List<HistoryJobEntity> historyJobs, String lockOwner, Date lockExpirationTime) {
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put("lockOwner", lockOwner);
        params.put("lockExpirationTime", lockExpirationTime);
        this.bulkUpdateEntities("updateHistoryJobLocks", params, "historyJobs", historyJobs);
    }

    @Override
    public void resetExpiredJob(String jobId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("id", jobId);
        this.getDbSqlSession().update("resetExpiredHistoryJob", params);
    }

    protected IdGenerator getIdGenerator() {
        return this.jobServiceConfiguration.getIdGenerator();
    }
}

