/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl;

import java.util.List;
import java.util.Set;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.query.AbstractQuery;
import org.flowable.variable.api.history.HistoricVariableInstance;
import org.flowable.variable.api.history.HistoricVariableInstanceQuery;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.HistoricVariableInstanceQueryProperty;
import org.flowable.variable.service.impl.QueryOperator;
import org.flowable.variable.service.impl.QueryVariableValue;
import org.flowable.variable.service.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.flowable.variable.service.impl.types.CacheableVariable;

public class HistoricVariableInstanceQueryImpl
extends AbstractQuery<HistoricVariableInstanceQuery, HistoricVariableInstance>
implements HistoricVariableInstanceQuery {
    private static final long serialVersionUID = 1L;
    protected VariableServiceConfiguration variableServiceConfiguration;
    protected String id;
    protected String taskId;
    protected Set<String> taskIds;
    protected String executionId;
    protected Set<String> executionIds;
    protected String processInstanceId;
    protected String activityInstanceId;
    protected String variableName;
    protected String variableNameLike;
    protected boolean excludeTaskRelated;
    protected boolean excludeVariableInitialization;
    protected String scopeId;
    protected String subScopeId;
    protected String scopeType;
    protected QueryVariableValue queryVariableValue;

    public HistoricVariableInstanceQueryImpl() {
    }

    public HistoricVariableInstanceQueryImpl(CommandContext commandContext, VariableServiceConfiguration variableServiceConfiguration) {
        super(commandContext);
        this.variableServiceConfiguration = variableServiceConfiguration;
    }

    public HistoricVariableInstanceQueryImpl(CommandExecutor commandExecutor, VariableServiceConfiguration variableServiceConfiguration) {
        super(commandExecutor);
        this.variableServiceConfiguration = variableServiceConfiguration;
    }

    public HistoricVariableInstanceQuery id(String id) {
        this.id = id;
        return this;
    }

    public HistoricVariableInstanceQueryImpl processInstanceId(String processInstanceId) {
        if (processInstanceId == null) {
            throw new FlowableIllegalArgumentException("processInstanceId is null");
        }
        this.processInstanceId = processInstanceId;
        return this;
    }

    public HistoricVariableInstanceQueryImpl executionId(String executionId) {
        if (executionId == null) {
            throw new FlowableIllegalArgumentException("Execution id is null");
        }
        this.executionId = executionId;
        return this;
    }

    public HistoricVariableInstanceQueryImpl executionIds(Set<String> executionIds) {
        if (executionIds == null) {
            throw new FlowableIllegalArgumentException("executionIds is null");
        }
        if (executionIds.isEmpty()) {
            throw new FlowableIllegalArgumentException("Set of executionIds is empty");
        }
        this.executionIds = executionIds;
        return this;
    }

    public HistoricVariableInstanceQuery activityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
        return this;
    }

    public HistoricVariableInstanceQuery taskId(String taskId) {
        if (taskId == null) {
            throw new FlowableIllegalArgumentException("taskId is null");
        }
        if (this.excludeTaskRelated) {
            throw new FlowableIllegalArgumentException("Cannot use taskId together with excludeTaskVariables");
        }
        this.taskId = taskId;
        return this;
    }

    public HistoricVariableInstanceQueryImpl taskIds(Set<String> taskIds) {
        if (taskIds == null) {
            throw new FlowableIllegalArgumentException("taskIds is null");
        }
        if (taskIds.isEmpty()) {
            throw new FlowableIllegalArgumentException("Set of taskIds is empty");
        }
        if (this.excludeTaskRelated) {
            throw new FlowableIllegalArgumentException("Cannot use taskIds together with excludeTaskVariables");
        }
        this.taskIds = taskIds;
        return this;
    }

    public HistoricVariableInstanceQuery excludeTaskVariables() {
        if (this.taskId != null) {
            throw new FlowableIllegalArgumentException("Cannot use taskId together with excludeTaskVariables");
        }
        if (this.taskIds != null) {
            throw new FlowableIllegalArgumentException("Cannot use taskIds together with excludeTaskVariables");
        }
        this.excludeTaskRelated = true;
        return this;
    }

    public HistoricVariableInstanceQuery excludeVariableInitialization() {
        this.excludeVariableInitialization = true;
        return this;
    }

    public HistoricVariableInstanceQuery variableName(String variableName) {
        if (variableName == null) {
            throw new FlowableIllegalArgumentException("variableName is null");
        }
        this.variableName = variableName;
        return this;
    }

    public HistoricVariableInstanceQuery variableValueEquals(String variableName, Object variableValue) {
        if (variableName == null) {
            throw new FlowableIllegalArgumentException("variableName is null");
        }
        if (variableValue == null) {
            throw new FlowableIllegalArgumentException("variableValue is null");
        }
        this.variableName = variableName;
        this.queryVariableValue = new QueryVariableValue(variableName, variableValue, QueryOperator.EQUALS, true);
        return this;
    }

    public HistoricVariableInstanceQuery variableValueNotEquals(String variableName, Object variableValue) {
        if (variableName == null) {
            throw new FlowableIllegalArgumentException("variableName is null");
        }
        if (variableValue == null) {
            throw new FlowableIllegalArgumentException("variableValue is null");
        }
        this.variableName = variableName;
        this.queryVariableValue = new QueryVariableValue(variableName, variableValue, QueryOperator.NOT_EQUALS, true);
        return this;
    }

    public HistoricVariableInstanceQuery variableValueLike(String variableName, String variableValue) {
        if (variableName == null) {
            throw new FlowableIllegalArgumentException("variableName is null");
        }
        if (variableValue == null) {
            throw new FlowableIllegalArgumentException("variableValue is null");
        }
        this.variableName = variableName;
        this.queryVariableValue = new QueryVariableValue(variableName, variableValue, QueryOperator.LIKE, true);
        return this;
    }

    public HistoricVariableInstanceQuery variableValueLikeIgnoreCase(String variableName, String variableValue) {
        if (variableName == null) {
            throw new FlowableIllegalArgumentException("variableName is null");
        }
        if (variableValue == null) {
            throw new FlowableIllegalArgumentException("variableValue is null");
        }
        this.variableName = variableName;
        this.queryVariableValue = new QueryVariableValue(variableName, variableValue.toLowerCase(), QueryOperator.LIKE_IGNORE_CASE, true);
        return this;
    }

    public HistoricVariableInstanceQuery variableNameLike(String variableNameLike) {
        if (variableNameLike == null) {
            throw new FlowableIllegalArgumentException("variableNameLike is null");
        }
        this.variableNameLike = variableNameLike;
        return this;
    }

    public HistoricVariableInstanceQuery scopeId(String scopeId) {
        this.scopeId = scopeId;
        return this;
    }

    public HistoricVariableInstanceQuery subScopeId(String subScopeId) {
        this.subScopeId = subScopeId;
        return this;
    }

    public HistoricVariableInstanceQuery scopeType(String scopeType) {
        this.scopeType = scopeType;
        return this;
    }

    protected void ensureVariablesInitialized() {
        if (this.queryVariableValue != null) {
            this.queryVariableValue.initialize(this.variableServiceConfiguration);
        }
    }

    public long executeCount(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        return this.variableServiceConfiguration.getHistoricVariableInstanceEntityManager().findHistoricVariableInstanceCountByQueryCriteria(this);
    }

    public List<HistoricVariableInstance> executeList(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        List<HistoricVariableInstance> historicVariableInstances = this.variableServiceConfiguration.getHistoricVariableInstanceEntityManager().findHistoricVariableInstancesByQueryCriteria(this);
        if (!this.excludeVariableInitialization) {
            for (HistoricVariableInstance historicVariableInstance : historicVariableInstances) {
                HistoricVariableInstanceEntity variableEntity;
                if (!(historicVariableInstance instanceof HistoricVariableInstanceEntity) || (variableEntity = (HistoricVariableInstanceEntity)historicVariableInstance).getVariableType() == null) continue;
                variableEntity.getValue();
                if (!"jpa-entity".equals(variableEntity.getVariableType().getTypeName()) && !"jpa-entity-list".equals(variableEntity.getVariableType().getTypeName())) continue;
                ((CacheableVariable)variableEntity.getVariableType()).setForceCacheable(true);
            }
        }
        return historicVariableInstances;
    }

    public HistoricVariableInstanceQuery orderByProcessInstanceId() {
        this.orderBy(HistoricVariableInstanceQueryProperty.PROCESS_INSTANCE_ID);
        return this;
    }

    public HistoricVariableInstanceQuery orderByVariableName() {
        this.orderBy(HistoricVariableInstanceQueryProperty.VARIABLE_NAME);
        return this;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public boolean getExcludeTaskRelated() {
        return this.excludeTaskRelated;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getVariableNameLike() {
        return this.variableNameLike;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public String getSubScopeId() {
        return this.subScopeId;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getTaskIds() {
        return this.taskIds;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public Set<String> getExecutionIds() {
        return this.executionIds;
    }

    public boolean isExcludeTaskRelated() {
        return this.excludeTaskRelated;
    }

    public boolean isExcludeVariableInitialization() {
        return this.excludeVariableInitialization;
    }

    public QueryVariableValue getQueryVariableValue() {
        return this.queryVariableValue;
    }
}

