/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.persistence.api.entity.Domain;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.AuthDataAccessor;
import org.apache.syncope.core.spring.security.DefaultCredentialChecker;
import org.apache.syncope.core.spring.security.Encryptor;
import org.apache.syncope.core.spring.security.SyncopeAuthenticationDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

@Configurable
public class UsernamePasswordAuthenticationProvider
implements AuthenticationProvider {
    protected static final Logger LOG = LoggerFactory.getLogger(UsernamePasswordAuthenticationProvider.class);
    protected static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    @Autowired
    protected AuthDataAccessor dataAccessor;
    @Autowired
    protected UserProvisioningManager provisioningManager;
    @Autowired
    private DefaultCredentialChecker credentialChecker;
    @Resource(name="adminUser")
    protected String adminUser;
    @Resource(name="adminPassword")
    protected String adminPassword;
    @Resource(name="adminPasswordAlgorithm")
    protected String adminPasswordAlgorithm;
    @Resource(name="anonymousUser")
    protected String anonymousUser;
    @Resource(name="anonymousKey")
    protected String anonymousKey;

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public void setAdminPasswordAlgorithm(String adminPasswordAlgorithm) {
        this.adminPasswordAlgorithm = adminPasswordAlgorithm;
    }

    public void setAnonymousKey(String anonymousKey) {
        this.anonymousKey = anonymousKey;
    }

    public Authentication authenticate(Authentication authentication) {
        Boolean authenticated;
        String domainKey = ((SyncopeAuthenticationDetails)SyncopeAuthenticationDetails.class.cast(authentication.getDetails())).getDomain();
        AtomicReference<String> username = new AtomicReference<String>();
        AtomicReference<Object> delegationKey = new AtomicReference<Object>();
        if (this.anonymousUser.equals(authentication.getName())) {
            username.set(this.anonymousUser);
            this.credentialChecker.checkIsDefaultAnonymousKeyInUse();
            authenticated = authentication.getCredentials().toString().equals(this.anonymousKey);
        } else if (this.adminUser.equals(authentication.getName())) {
            username.set(this.adminUser);
            if ("Master".equals(domainKey)) {
                this.credentialChecker.checkIsDefaultAdminPasswordInUse();
                authenticated = ENCRYPTOR.verify(authentication.getCredentials().toString(), CipherAlgorithm.valueOf((String)this.adminPasswordAlgorithm), this.adminPassword);
            } else {
                authenticated = AuthContextUtils.execWithAuthContext("Master", () -> {
                    Domain domain = this.dataAccessor.findDomain(domainKey);
                    return ENCRYPTOR.verify(authentication.getCredentials().toString(), domain.getAdminCipherAlgorithm(), domain.getAdminPwd());
                });
            }
        } else {
            Triple authResult = AuthContextUtils.execWithAuthContext(domainKey, () -> this.dataAccessor.authenticate(authentication));
            authenticated = (Boolean)authResult.getMiddle();
            if (authResult.getLeft() != null && authResult.getMiddle() != null) {
                username.set(((User)authResult.getLeft()).getUsername());
                if (!authenticated.booleanValue()) {
                    AuthContextUtils.execWithAuthContext(domainKey, () -> {
                        this.provisioningManager.internalSuspend(((User)authResult.getLeft()).getKey());
                        return null;
                    });
                }
            }
            delegationKey.set(authResult.getRight());
        }
        if (username.get() == null) {
            username.set(authentication.getPrincipal().toString());
        }
        if (!BooleanUtils.isTrue((Boolean)authenticated)) {
            AuthContextUtils.execWithAuthContext(domainKey, () -> {
                this.dataAccessor.audit((String)username.get(), (String)delegationKey.get(), AuditElements.Result.FAILURE, false, authentication, "Not authenticated");
                return null;
            });
            LOG.debug("User {} not authenticated", username.get());
            throw new BadCredentialsException("User " + (String)username.get() + " not authenticated");
        }
        UsernamePasswordAuthenticationToken token = AuthContextUtils.execWithAuthContext(domainKey, () -> {
            UsernamePasswordAuthenticationToken upat = new UsernamePasswordAuthenticationToken(username.get(), null, this.dataAccessor.getAuthorities((String)username.get(), (String)delegationKey.get()));
            upat.setDetails(authentication.getDetails());
            this.dataAccessor.audit((String)username.get(), (String)delegationKey.get(), AuditElements.Result.SUCCESS, true, authentication, "Successfully authenticated, with entitlements: " + upat.getAuthorities());
            return upat;
        });
        LOG.debug("User {} successfully authenticated, with entitlements {}", username.get(), (Object)token.getAuthorities());
        return token;
    }

    public boolean supports(Class<? extends Object> type) {
        return type.equals(UsernamePasswordAuthenticationToken.class);
    }
}

