/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.role;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.UserSearchPanel;
import org.apache.syncope.client.console.rest.ApplicationRestClient;
import org.apache.syncope.client.console.rest.DynRealmRestClient;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.rest.RoleRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wizards.AjaxWizardBuilder;
import org.apache.syncope.client.console.wizards.role.RoleWrapper;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.RoleTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;

public class RoleWizardBuilder
extends AjaxWizardBuilder<RoleWrapper> {
    private static final long serialVersionUID = 5945391813567245081L;
    private final RoleRestClient restClient = new RoleRestClient();

    public RoleWizardBuilder(RoleTO roleTO, PageReference pageRef) {
        super(new RoleWrapper(roleTO), pageRef);
    }

    @Override
    public AjaxWizardBuilder<RoleWrapper> setItem(RoleWrapper item) {
        return (AjaxWizardBuilder)(item == null ? super.setItem(null) : super.setItem(new RoleWrapper(item.getInnerObject())));
    }

    @Override
    protected Serializable onApplyInternal(RoleWrapper modelObject) {
        modelObject.fillDynamicConditions();
        if (this.getOriginalItem() == null || ((RoleWrapper)this.getOriginalItem()).getInnerObject() == null || StringUtils.isBlank((CharSequence)((RoleWrapper)this.getOriginalItem()).getInnerObject().getKey())) {
            this.restClient.create(modelObject.getInnerObject());
        } else {
            this.restClient.update(modelObject.getInnerObject());
        }
        return null;
    }

    @Override
    protected WizardModel buildModelSteps(RoleWrapper modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Details(modelObject));
        wizardModel.add((IWizardStep)new Entitlements(modelObject.getInnerObject()));
        wizardModel.add((IWizardStep)new Realms(modelObject.getInnerObject()));
        wizardModel.add((IWizardStep)new DynRealms(modelObject.getInnerObject()));
        wizardModel.add((IWizardStep)new Privileges(modelObject.getInnerObject()));
        return wizardModel;
    }

    public static class Privileges
    extends WizardStep {
        private static final long serialVersionUID = 6896014330702958579L;

        public Privileges(RoleTO modelObject) {
            this.setTitleModel((IModel)new ResourceModel("privileges"));
            this.add(new Component[]{new AjaxPalettePanel.Builder().build("privileges", new PropertyModel((Object)modelObject, "privileges"), new ListModel(new ApplicationRestClient().list().stream().flatMap(application -> application.getPrivileges().stream()).map(EntityTO::getKey).collect(Collectors.toList()))).hideLabel().setOutputMarkupId(true)});
        }
    }

    public static class DynRealms
    extends WizardStep {
        private static final long serialVersionUID = 6846234574424462255L;

        public DynRealms(RoleTO modelObject) {
            this.setTitleModel((IModel)new ResourceModel("dynRealms"));
            this.add(new Component[]{new AjaxPalettePanel.Builder().build("dynRealms", new PropertyModel((Object)modelObject, "dynRealms"), new ListModel(new DynRealmRestClient().list().stream().map(EntityTO::getKey).collect(Collectors.toList()))).hideLabel().setOutputMarkupId(true)});
        }
    }

    public static class Realms
    extends WizardStep {
        private static final long serialVersionUID = 5514523040031722257L;

        public Realms(RoleTO modelObject) {
            this.setTitleModel((IModel)new ResourceModel("realms"));
            this.add(new Component[]{new AjaxPalettePanel.Builder().build("realms", new PropertyModel((Object)modelObject, "realms"), new ListModel(new RealmRestClient().list().stream().map(RealmTO::getFullPath).collect(Collectors.toList()))).hideLabel().setOutputMarkupId(true)});
        }
    }

    public static class Entitlements
    extends WizardStep {
        private static final long serialVersionUID = 5514523040031722256L;

        public Entitlements(final RoleTO modelObject) {
            this.setTitleModel((IModel)new ResourceModel("entitlements"));
            this.add(new Component[]{new AjaxPalettePanel.Builder().build("entitlements", new PropertyModel<List<String>>((Object)modelObject, "entitlements"){
                private static final long serialVersionUID = -7809699384012595307L;

                public List<String> getObject() {
                    return new ArrayList<String>(modelObject.getEntitlements());
                }

                public void setObject(List<String> object) {
                    modelObject.getEntitlements().clear();
                    modelObject.getEntitlements().addAll(object);
                }
            }, new ListModel(new RoleRestClient().getAllAvailableEntitlements())).hideLabel().setOutputMarkupId(true)});
        }
    }

    public static class Details
    extends WizardStep {
        private static final long serialVersionUID = 5514523040031722255L;

        public Details(final RoleWrapper modelObject) {
            this.add(new Component[]{new AjaxTextFieldPanel("key", "key", (IModel<String>)new PropertyModel((Object)modelObject.getInnerObject(), "key"), false).setEnabled(StringUtils.isEmpty((CharSequence)modelObject.getInnerObject().getKey()))});
            this.add(new Component[]{new Accordion("dynMembershipCond", Collections.singletonList(new AbstractTab((IModel)new ResourceModel("dynMembershipCond", "Dynamic USER Membership Conditions")){
                private static final long serialVersionUID = 1037272333056449378L;

                public Panel getPanel(String panelId) {
                    return new UserSearchPanel.Builder((IModel<List<SearchClause>>)new PropertyModel((Object)modelObject, "dynClauses")).required(true).build(panelId);
                }
            }), (IModel<Integer>)Model.of((Serializable)Integer.valueOf(StringUtils.isBlank((CharSequence)modelObject.getDynMembershipCond()) ? -1 : 0))).setOutputMarkupId(true)});
        }
    }
}

